/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.reflective;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.wrappers.TypeNodeWrapper;
import org.eclipse.hawk.graph.TypeNode;
import org.eclipse.hawk.timeaware.queries.RiskyFunction;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.eclipse.hawk.timeaware.queries.operations.scopes.EndingTimeAwareNodeWrapper;
import org.eclipse.hawk.timeaware.queries.operations.scopes.IScopingTimeAwareGraphNode;
import org.eclipse.hawk.timeaware.queries.operations.scopes.StartingTimeAwareNodeWrapper;

public class TypeHistoryOperationContributor
extends OperationContributor {
    private EOLQueryEngine model;

    public TypeHistoryOperationContributor(EOLQueryEngine q) {
        this.model = q;
    }

    public boolean contributesTo(Object target) {
        return target instanceof EolModelElementType || target instanceof TypeNodeWrapper;
    }

    public TypeNodeWrapper getlatest() throws Exception {
        return this.getTypeNodeVersionWrappers(taNode -> Collections.singletonList(taNode.getLatest())).get(0);
    }

    public TypeNodeWrapper getearliest() throws Exception {
        return this.getTypeNodeVersionWrappers(taNode -> Collections.singletonList(taNode.getEarliest())).get(0);
    }

    public TypeNodeWrapper getsinceThen() throws Exception {
        return this.getTypeNodeVersionWrappers(taNode -> Collections.singletonList(new StartingTimeAwareNodeWrapper((ITimeAwareGraphNode)taNode))).get(0);
    }

    public TypeNodeWrapper getuntilThen() throws Exception {
        return this.getTypeNodeVersionWrappers(taNode -> Collections.singletonList(new EndingTimeAwareNodeWrapper((ITimeAwareGraphNode)taNode))).get(0);
    }

    public TypeNodeWrapper getafterThen() throws Exception {
        ITimeAwareGraphNode nextVersion = this.getTargetTimeAwareNode().getNext();
        if (nextVersion == null) {
            return null;
        }
        StartingTimeAwareNodeWrapper scoped = new StartingTimeAwareNodeWrapper(nextVersion);
        return new TypeNodeWrapper(new TypeNode((IGraphNode)scoped), this.model);
    }

    public TypeNodeWrapper getbeforeThen() throws Exception {
        ITimeAwareGraphNode prevVersion = this.getTargetTimeAwareNode().getPrevious();
        if (prevVersion == null) {
            return null;
        }
        EndingTimeAwareNodeWrapper scoped = new EndingTimeAwareNodeWrapper(prevVersion);
        return new TypeNodeWrapper(new TypeNode((IGraphNode)scoped), this.model);
    }

    public TypeNodeWrapper unscoped() throws Exception {
        ITimeAwareGraphNode unscoped;
        ITimeAwareGraphNode taNode = this.getTargetTimeAwareNode();
        if (taNode instanceof IScopingTimeAwareGraphNode) {
            IScopingTimeAwareGraphNode scoped = (IScopingTimeAwareGraphNode)taNode;
            unscoped = scoped.unscope();
        } else {
            unscoped = taNode;
        }
        return new TypeNodeWrapper(new TypeNode((IGraphNode)unscoped), this.model);
    }

    public List<TypeNodeWrapper> getversions() throws Exception {
        return this.getTypeNodeVersionWrappers(taNode -> taNode.getAllVersions());
    }

    public TypeNodeWrapper getnext() throws Exception {
        List<TypeNodeWrapper> wrappers = this.getTypeNodeVersionWrappers(taNode -> Collections.singletonList(taNode.getNext()));
        return wrappers.isEmpty() ? null : wrappers.get(0);
    }

    public TypeNodeWrapper getprevious() throws Exception {
        List<TypeNodeWrapper> wrappers = this.getTypeNodeVersionWrappers(taNode -> Collections.singletonList(taNode.getPrevious()));
        return wrappers.isEmpty() ? null : wrappers.get(0);
    }

    public TypeNodeWrapper getprev() throws Exception {
        return this.getprevious();
    }

    public long gettime() throws Exception {
        return this.getTargetTimeAwareNode().getTime();
    }

    public List<TypeNodeWrapper> getVersionsBetween(long fromInclusive, long toInclusive) throws Exception {
        return this.getTypeNodeVersionWrappers(taNode -> taNode.getVersionsBetween(fromInclusive, toInclusive));
    }

    public List<TypeNodeWrapper> getVersionsFrom(long fromInclusive) throws Exception {
        return this.getTypeNodeVersionWrappers(taNode -> taNode.getVersionsFrom(fromInclusive));
    }

    public List<TypeNodeWrapper> getVersionsUpTo(long toInclusive) throws Exception {
        return this.getTypeNodeVersionWrappers(taNode -> taNode.getVersionsUpTo(toInclusive));
    }

    private List<TypeNodeWrapper> getTypeNodeVersionWrappers(RiskyFunction<ITimeAwareGraphNode, List<ITimeAwareGraphNode>> lambda) throws EolRuntimeException, Exception {
        ITimeAwareGraphNode taNode = this.getTargetTimeAwareNode();
        ArrayList<TypeNodeWrapper> ret = new ArrayList<TypeNodeWrapper>();
        for (ITimeAwareGraphNode typeNodeVersion : lambda.call(taNode)) {
            if (typeNodeVersion == null) continue;
            TypeNode typeNode = new TypeNode((IGraphNode)typeNodeVersion);
            ret.add(new TypeNodeWrapper(typeNode, this.model));
        }
        return ret;
    }

    protected ITimeAwareGraphNode getTargetTimeAwareNode() throws EolRuntimeException {
        ITimeAwareGraphNode taNode;
        if (this.getTarget() instanceof EolModelElementType) {
            EolModelElementType eolType = (EolModelElementType)this.getTarget();
            TimeAwareEOLQueryEngine queryEngine = (TimeAwareEOLQueryEngine)eolType.getModel();
            List typeNodes = queryEngine.getTypeNodes(eolType.getTypeName());
            this.checkTypeIsPrecise(eolType, typeNodes);
            taNode = (ITimeAwareGraphNode)typeNodes.get(0);
        } else if (this.getTarget() instanceof TypeNodeWrapper) {
            taNode = (ITimeAwareGraphNode)((TypeNodeWrapper)this.getTarget()).getNode();
        } else {
            throw new IllegalArgumentException("Unsupported target " + this.getTarget());
        }
        return taNode;
    }

    private void checkTypeIsPrecise(EolModelElementType eolType, List<IGraphNode> typeNodes) throws EolRuntimeException {
        if (typeNodes.size() > 1) {
            throw new EolRuntimeException("Type " + eolType + " is ambiguous");
        }
        if (typeNodes.isEmpty()) {
            throw new EolRuntimeException("Type " + eolType + " could not be found");
        }
    }
}

