/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.scopes.annotations;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeReference;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNodeIndex;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.Slot;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnnotatedOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAnnotatedOperation.class);
    private final Supplier<TimeAwareEOLQueryEngine> modelSupplier;

    public AbstractAnnotatedOperation(Supplier<TimeAwareEOLQueryEngine> containerModelSupplier) {
        this.modelSupplier = containerModelSupplier;
    }

    public IGraphNodeReference execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context) throws EolRuntimeException {
        EOLQueryEngine.GraphNodeWrapper gnw;
        if (expressions.isEmpty()) {
            LOGGER.warn("expected to receive the name of the derived attribute, returning null");
            return null;
        }
        if (target instanceof EOLQueryEngine.GraphNodeWrapper) {
            gnw = (EOLQueryEngine.GraphNodeWrapper)target;
            if (!(gnw.getNode() instanceof ITimeAwareGraphNode)) {
                LOGGER.warn("called on non-timeaware node {}, returning null", (Object)target.getClass().getName());
                return null;
            }
        } else {
            if (target != null) {
                LOGGER.warn("called on non-node {}, returning null", (Object)target.getClass().getName());
                return null;
            }
            LOGGER.warn("called on undefined value, returning null");
            return null;
        }
        ITimeAwareGraphNode taNode = (ITimeAwareGraphNode)gnw.getNode();
        Expression labelExpression = expressions.get(0);
        String derivedAttrName = "" + context.getExecutorFactory().execute((ModuleElement)labelExpression, context);
        Slot slot = new ModelElementNode((IGraphNode)taNode).getTypeNode().getSlot(derivedAttrName);
        if (slot == null) {
            LOGGER.warn("slot does not exist, returning null");
            return null;
        }
        String idxName = slot.getNodeIndexName();
        ITimeAwareGraphNodeIndex index = (ITimeAwareGraphNodeIndex)taNode.getGraph().getOrCreateNodeIndex(idxName);
        ITimeAwareGraphNode wrapper = this.useAnnotations(index, taNode, derivedAttrName);
        if (wrapper == null) {
            return null;
        }
        return this.modelSupplier.get().wrap((IGraphNode)wrapper);
    }

    public boolean isOverridable() {
        return false;
    }

    protected abstract ITimeAwareGraphNode useAnnotations(ITimeAwareGraphNodeIndex var1, ITimeAwareGraphNode var2, String var3);
}

