/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.runtime;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.runtime.BaseModelIndexer;

public class ModelIndexerImpl
extends BaseModelIndexer {
    private static final String UNKNOWN_REMOTE_REVISION = "-4";
    private static final String UNKNOWN_LOCAL_REVISION = "-3";
    private final Map<String, String> currLocalTopRevisions = new HashMap<String, String>();
    private final Map<String, String> currReposTopRevisions = new HashMap<String, String>();

    public ModelIndexerImpl(String name, File parentfolder, ICredentialsStore credStore, IConsole c) {
        super(name, parentfolder, credStore, c);
    }

    @Override
    public void addVCSManager(IVcsManager vcs, boolean persist) {
        this.currLocalTopRevisions.put(vcs.getLocation(), UNKNOWN_LOCAL_REVISION);
        this.currReposTopRevisions.put(vcs.getLocation(), UNKNOWN_REMOTE_REVISION);
        super.addVCSManager(vcs, persist);
    }

    @Override
    public void removeVCSManager(IVcsManager vcs) throws Exception {
        this.currLocalTopRevisions.remove(vcs.getLocation());
        this.currReposTopRevisions.remove(vcs.getLocation());
        super.removeVCSManager(vcs);
    }

    @Override
    protected void resetRepository(String repoURL) {
        System.err.println("reseting local top revision of repository: " + repoURL + "\n(as elements in it were removed or new metamodels were added to Hawk)");
        this.currLocalTopRevisions.put(repoURL, UNKNOWN_LOCAL_REVISION);
    }

    @Override
    protected boolean synchronise(IVcsManager vcsManager) throws Exception {
        boolean success = true;
        String currentRevision = this.currReposTopRevisions.get(vcsManager.getLocation());
        try {
            currentRevision = vcsManager.getCurrentRevision();
            this.currReposTopRevisions.put(vcsManager.getLocation(), currentRevision);
        }
        catch (Exception e) {
            this.console.printerrln(e);
            success = false;
        }
        if (!currentRevision.equals(this.currLocalTopRevisions.get(vcsManager.getLocation()))) {
            Collection<VcsCommitItem> files = vcsManager.getDelta(this.currLocalTopRevisions.get(vcsManager.getLocation()));
            this.latestUpdateFoundChanges = true;
            boolean updatersOK = this.synchroniseFiles(currentRevision, vcsManager, files);
            if (updatersOK) {
                this.currLocalTopRevisions.put(vcsManager.getLocation(), this.currReposTopRevisions.get(vcsManager.getLocation()));
            } else {
                success = false;
                this.currLocalTopRevisions.put(vcsManager.getLocation(), UNKNOWN_LOCAL_REVISION);
            }
        }
        return success;
    }
}

