/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileOperations {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (destFile.isDirectory()) {
            System.err.println("Directory given to copyFile(File sourceFile, File destFile), returning with no copying");
            return;
        }
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream fisSource = new FileInputStream(sourceFile);
            try {
                try (FileOutputStream fosDest = new FileOutputStream(destFile);){
                    FileChannel source = fisSource.getChannel();
                    FileChannel destination = fosDest.getChannel();
                    destination.transferFrom(source, 0L, source.size());
                }
                if (fisSource == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fisSource == null) throw throwable;
                fisSource.close();
                throw throwable;
            }
            fisSource.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static boolean deleteFiles(File file, Boolean prev) {
        boolean success = prev;
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                success = success && file.delete();
            } else {
                File[] files;
                File[] fileArray = files = file.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File temp = fileArray[n2];
                    FileOperations.deleteFiles(temp, success);
                    ++n2;
                }
                success = file.list().length == 0 ? success && file.delete() : false;
            }
        } else {
            success = success && file.delete();
        }
        return success;
    }
}

