/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class CommitConfig {
    public static final Config.SectionParser<CommitConfig> KEY = CommitConfig::new;
    private static final String CUT = " ------------------------ >8 ------------------------\n";
    private static final Charset DEFAULT_COMMIT_MESSAGE_ENCODING = StandardCharsets.UTF_8;
    private String i18nCommitEncoding;
    private String commitTemplatePath;
    private CleanupMode cleanupMode;

    private CommitConfig(Config rc) {
        this.commitTemplatePath = rc.getString("commit", null, "template");
        this.i18nCommitEncoding = rc.getString("i18n", null, "commitEncoding");
        this.cleanupMode = rc.getEnum("commit", null, "cleanup", CleanupMode.DEFAULT);
    }

    @Nullable
    public String getCommitTemplatePath() {
        return this.commitTemplatePath;
    }

    @Nullable
    public String getCommitEncoding() {
        return this.i18nCommitEncoding;
    }

    @NonNull
    public CleanupMode getCleanupMode() {
        return this.cleanupMode;
    }

    @NonNull
    public CleanupMode resolve(@NonNull CleanupMode mode, boolean defaultStrip) {
        if (CleanupMode.DEFAULT == mode) {
            CleanupMode defaultMode = this.getCleanupMode();
            if (CleanupMode.DEFAULT == defaultMode) {
                return defaultStrip ? CleanupMode.STRIP : CleanupMode.WHITESPACE;
            }
            return defaultMode;
        }
        return mode;
    }

    @Nullable
    public String getCommitTemplateContent(@NonNull Repository repository) throws FileNotFoundException, IOException, ConfigInvalidException {
        if (this.commitTemplatePath == null) {
            return null;
        }
        FS fileSystem = repository.getFS();
        File commitTemplateFile = this.commitTemplatePath.startsWith("~/") ? fileSystem.resolve(fileSystem.userHome(), this.commitTemplatePath.substring(2)) : fileSystem.resolve(null, this.commitTemplatePath);
        if (!commitTemplateFile.isAbsolute()) {
            commitTemplateFile = fileSystem.resolve(repository.getWorkTree().getAbsoluteFile(), this.commitTemplatePath);
        }
        Charset commitMessageEncoding = this.getEncoding();
        return RawParseUtils.decode(commitMessageEncoding, IO.readFully(commitTemplateFile));
    }

    private Charset getEncoding() throws ConfigInvalidException {
        Charset commitMessageEncoding = DEFAULT_COMMIT_MESSAGE_ENCODING;
        if (this.i18nCommitEncoding == null) {
            return null;
        }
        try {
            commitMessageEncoding = Charset.forName(this.i18nCommitEncoding);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().invalidEncoding, this.i18nCommitEncoding), e);
        }
        return commitMessageEncoding;
    }

    public static String cleanText(@NonNull String text, @NonNull CleanupMode mode, char commentChar) {
        String toProcess = text;
        boolean strip = false;
        switch (mode) {
            case VERBATIM: {
                return text;
            }
            case SCISSORS: {
                String cut = String.valueOf(commentChar) + CUT;
                if (text.startsWith(cut)) {
                    return "";
                }
                int cutPos = text.indexOf(String.valueOf('\n') + cut);
                if (cutPos < 0) break;
                toProcess = text.substring(0, cutPos + 1);
                break;
            }
            case STRIP: {
                strip = true;
                break;
            }
            case WHITESPACE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid clean-up mode " + mode);
            }
        }
        StringBuilder result = new StringBuilder();
        boolean lastWasEmpty = true;
        String[] stringArray = toProcess.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.stripTrailing()).isEmpty()) {
                if (!lastWasEmpty) {
                    result.append('\n');
                    lastWasEmpty = true;
                }
            } else if (!strip || !CommitConfig.isComment(line, commentChar)) {
                lastWasEmpty = false;
                result.append(line).append('\n');
            }
            ++n2;
        }
        int bufferSize = result.length();
        if (lastWasEmpty && bufferSize > 0) {
            result.setLength(--bufferSize);
        }
        if (bufferSize > 0 && !toProcess.endsWith("\n") && result.charAt(bufferSize - 1) == '\n') {
            result.setLength(bufferSize - 1);
        }
        return result.toString();
    }

    private static boolean isComment(String text, char commentChar) {
        int len = text.length();
        int i = 0;
        while (i < len) {
            char ch = text.charAt(i);
            if (!Character.isWhitespace(ch)) {
                return ch == commentChar;
            }
            ++i;
        }
        return false;
    }

    public static enum CleanupMode implements Config.ConfigEnum
    {
        STRIP,
        WHITESPACE,
        VERBATIM,
        SCISSORS,
        DEFAULT;


        @Override
        public String toConfigValue() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public boolean matchConfigValue(String in) {
            return this.toConfigValue().equals(in);
        }
    }
}

