/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emfresource.util;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEStoreEObjectImpl;

public final class AttributeUtils {
    private AttributeUtils() {
    }

    public static Object setAttribute(EFactory eFactory, EClass eClass, EObject eObject, String featureName, Object value) {
        EStructuralFeature feature = eClass.getEStructuralFeature(featureName);
        if (feature == null) {
            return null;
        }
        if (!feature.isChangeable() || feature.isDerived() && !(eObject instanceof DynamicEStoreEObjectImpl)) {
            return null;
        }
        if (feature.isMany()) {
            return AttributeUtils.setListAttribute(eFactory, eObject, value, feature);
        }
        return AttributeUtils.setScalarAttribute(eFactory, eObject, value, feature);
    }

    private static Object setScalarAttribute(EFactory eFactory, EObject eObject, Object value, EStructuralFeature feature) {
        Object singleValue = AttributeUtils.normalizeIntoScalar(value);
        if (singleValue == null) {
            eObject.eUnset(feature);
            return null;
        }
        EClassifier eType = feature.getEType();
        if (eType instanceof EEnum) {
            EEnum enumType = (EEnum)eType;
            Object literal = eFactory.createFromString((EDataType)enumType, singleValue.toString());
            eObject.eSet(feature, literal);
            return literal;
        }
        eObject.eSet(feature, singleValue);
        return singleValue;
    }

    private static Object setListAttribute(EFactory eFactory, EObject eObject, Object value, EStructuralFeature feature) {
        EList<Object> manyValue = AttributeUtils.normalizeIntoList(value);
        if (manyValue == null) {
            eObject.eUnset(feature);
            return null;
        }
        EClassifier eType = feature.getEType();
        if (eType instanceof EEnum) {
            EEnum enumType = (EEnum)eType;
            BasicEList literals = new BasicEList();
            for (Object o : manyValue) {
                literals.add(eFactory.createFromString((EDataType)enumType, o.toString()));
            }
            eObject.eSet(feature, (Object)literals);
            return literals;
        }
        eObject.eSet(feature, manyValue);
        return manyValue;
    }

    private static Object normalizeIntoScalar(Object value) {
        Collection coll;
        if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            if (arr.length > 0) {
                return arr[0];
            }
        } else if (value instanceof Collection && !(coll = (Collection)value).isEmpty()) {
            return coll.iterator().next();
        }
        return value;
    }

    private static EList<Object> normalizeIntoList(Object value) {
        if (value instanceof Object[]) {
            return new BasicEList(Arrays.asList((Object[])value));
        }
        if (value instanceof Collection) {
            return new BasicEList((Collection)value);
        }
        if (value != null) {
            BasicEList manyValue = new BasicEList();
            manyValue.add(value);
            return manyValue;
        }
        return null;
    }
}

