/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeReference;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.pgetters.GraphPropertyGetter;
import org.eclipse.hawk.timeaware.queries.operations.scopes.EndingTimeAwareNodeWrapper;
import org.eclipse.hawk.timeaware.queries.operations.scopes.IScopingTimeAwareGraphNode;
import org.eclipse.hawk.timeaware.queries.operations.scopes.StartingTimeAwareNodeWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeAwareGraphPropertyGetter
extends GraphPropertyGetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeAwareGraphPropertyGetter.class);

    protected TimeAwareGraphPropertyGetter(IGraphDatabase graph, EOLQueryEngine m) {
        super(graph, m);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invokePredefined(String property, IGraphNode node) throws EolRuntimeException {
        Object ret = super.invokePredefined(property, node);
        if (ret != null) {
            return ret;
        }
        ITimeAwareGraphNode taNode = (ITimeAwareGraphNode)node;
        try {
            switch (property) {
                case "versions": {
                    return this.getVersions(taNode);
                }
                case "latest": {
                    return this.model.wrap((IGraphNode)taNode.getLatest());
                }
                case "earliest": {
                    return this.model.wrap((IGraphNode)taNode.getEarliest());
                }
                case "previous": 
                case "prev": {
                    ITimeAwareGraphNode taPrevious = taNode.getPrevious();
                    if (taPrevious != null) return this.model.wrap((IGraphNode)taPrevious);
                    return null;
                }
                case "next": {
                    ITimeAwareGraphNode taNext = taNode.getNext();
                    if (taNext != null) return this.model.wrap((IGraphNode)taNext);
                    return null;
                }
                case "time": {
                    return taNode.getTime();
                }
                case "isAlive": {
                    return taNode.isAlive();
                }
                case "sinceThen": {
                    StartingTimeAwareNodeWrapper scoped = new StartingTimeAwareNodeWrapper(taNode);
                    return this.model.wrap((IGraphNode)scoped);
                }
                case "untilThen": {
                    EndingTimeAwareNodeWrapper scoped = new EndingTimeAwareNodeWrapper(taNode);
                    return this.model.wrap((IGraphNode)scoped);
                }
                case "afterThen": {
                    ITimeAwareGraphNode nextVersion = taNode.getNext();
                    if (nextVersion == null) {
                        return null;
                    }
                    StartingTimeAwareNodeWrapper scoped = new StartingTimeAwareNodeWrapper(nextVersion);
                    return this.model.wrap((IGraphNode)scoped);
                }
                case "beforeThen": {
                    ITimeAwareGraphNode prevVersion = taNode.getPrevious();
                    if (prevVersion == null) {
                        return null;
                    }
                    EndingTimeAwareNodeWrapper scoped = new EndingTimeAwareNodeWrapper(prevVersion);
                    return this.model.wrap((IGraphNode)scoped);
                }
                case "unscoped": {
                    ITimeAwareGraphNode unscoped;
                    if (taNode instanceof IScopingTimeAwareGraphNode) {
                        unscoped = ((IScopingTimeAwareGraphNode)taNode).unscope();
                        return this.model.wrap((IGraphNode)unscoped);
                    }
                    unscoped = taNode;
                    return this.model.wrap((IGraphNode)unscoped);
                }
            }
            return null;
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new EolRuntimeException(ex.getMessage());
        }
    }

    private List<IGraphNodeReference> getVersions(ITimeAwareGraphNode taNode) throws Exception {
        ArrayList<IGraphNodeReference> result = new ArrayList<IGraphNodeReference>();
        for (ITimeAwareGraphNode version : taNode.getAllVersions()) {
            result.add(this.model.wrap((IGraphNode)version));
        }
        return result;
    }
}

