/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.runtime;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IFileImporter;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.IMetaModelUpdater;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IModelResourceFactory;
import org.eclipse.hawk.core.IModelUpdater;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsChangeType;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.model.IHawkMetaModelResource;
import org.eclipse.hawk.core.model.IHawkModelResource;
import org.eclipse.hawk.core.model.IHawkResource;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.core.runtime.CompositeGraphChangeListener;
import org.eclipse.hawk.core.runtime.CompositeStateListener;
import org.eclipse.hawk.core.util.DerivedAttributeParameters;
import org.eclipse.hawk.core.util.FileOperations;
import org.eclipse.hawk.core.util.HawkProperties;
import org.eclipse.hawk.core.util.IndexedAttributeParameters;
import org.eclipse.hawk.core.util.XStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseModelIndexer
implements IModelIndexer {
    private static final String DEFAULT_DERIVED_QUERY_ENGINE = "org.eclipse.hawk.epsilon.emc.EOLQueryEngine";
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseModelIndexer.class);
    private static final int CEILING_DELAY_FAILED_UPDATES = 60000;
    public static final int FILECOUNT_PROGRESS_THRESHOLD = 100;
    public static final int SHUTDOWN_WAIT_SECONDS = 120;
    public static final int DEFAULT_MAXDELAY = 512000;
    public static final int DEFAULT_MINDELAY = 5000;
    protected static final boolean IS_DERIVED = true;
    protected static final boolean IS_INDEXED = false;
    protected boolean isSyncMetricsEnabled = false;
    protected Map<VcsCommitItem, IHawkModelResource> fileToResourceMap = new HashMap<VcsCommitItem, IHawkModelResource>();
    protected int deletedFiles;
    protected int interestingFiles;
    protected int currchangeditems;
    protected int loadedResources;
    private long synctime;
    protected boolean latestUpdateFoundChanges = false;
    protected String name;
    protected File parentfolder = null;
    protected boolean running = false;
    protected final ICredentialsStore credStore;
    protected IGraphDatabase graph = null;
    protected Queue<IVcsManager> monitors = new ConcurrentLinkedQueue<IVcsManager>();
    protected Queue<IModelUpdater> updaters = new ConcurrentLinkedQueue<IModelUpdater>();
    protected IMetaModelUpdater metamodelupdater = null;
    protected Map<String, IModelResourceFactory> modelParsers = new ConcurrentHashMap<String, IModelResourceFactory>();
    protected Map<String, IMetaModelResourceFactory> metamodelParsers = new ConcurrentHashMap<String, IMetaModelResourceFactory>();
    protected Map<String, IQueryEngine> knownQueryLanguages = new ConcurrentHashMap<String, IQueryEngine>();
    protected IConsole console;
    private int maxDelay = 512000;
    private int minDelay;
    private int currentDelay = this.minDelay = 5000;
    private ScheduledThreadPoolExecutor updateTimer = null;
    private ThreadLocal<Boolean> insideUpdateThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final CompositeGraphChangeListener listener = new CompositeGraphChangeListener();
    protected final CompositeStateListener stateListener = new CompositeStateListener();
    private Collection<IndexedAttributeParameters> cachedDerivedAttributes = null;

    public BaseModelIndexer(String name, File parentFolder, ICredentialsStore credStore, IConsole c) {
        this.name = name;
        this.console = c;
        this.credStore = credStore;
        this.parentfolder = parentFolder;
    }

    protected abstract void resetRepository(String var1);

    @Override
    public void addVCSManager(IVcsManager vcs, boolean persist) {
        this.monitors.add(vcs);
        try {
            if (persist) {
                this.saveIndexer();
            }
        }
        catch (Exception e) {
            LOGGER.error("addVCSManager tried to saveIndexer but failed", (Throwable)e);
        }
        this.requestImmediateSync();
    }

    @Override
    public void removeVCSManager(IVcsManager vcs) throws Exception {
        this.stateListener.state(IStateListener.HawkState.UPDATING);
        this.stateListener.info("Removing vcs...");
        this.monitors.remove(vcs);
        try {
            this.saveIndexer();
        }
        catch (Exception e) {
            System.err.println("removeVCS tried to saveIndexer but failed");
            e.printStackTrace();
        }
        for (IModelUpdater u : this.updaters) {
            try {
                u.deleteAll(vcs);
            }
            catch (Exception e) {
                System.err.println("removeVCS tried to delete index contents but failed");
                e.printStackTrace();
            }
        }
        this.stateListener.state(IStateListener.HawkState.RUNNING);
        this.stateListener.info("Removed vcs.");
    }

    protected abstract boolean synchronise(IVcsManager var1) throws Exception;

    @Override
    public void requestImmediateSync() {
        if (this.running) {
            this.updateTimer.submit(new RunUpdateTask(false));
        }
    }

    protected boolean synchronise() throws Exception {
        this.listener.synchroniseStart();
        this.stateListener.state(IStateListener.HawkState.UPDATING);
        try {
            long start = System.currentTimeMillis();
            boolean allSync = true;
            this.fileToResourceMap = new HashMap<VcsCommitItem, IHawkModelResource>();
            this.deletedFiles = 0;
            this.interestingFiles = 0;
            this.currchangeditems = 0;
            this.loadedResources = 0;
            this.synctime = 0L;
            this.latestUpdateFoundChanges = false;
            if (this.monitors.size() > 0) {
                for (IVcsManager m : this.monitors) {
                    if (!m.isFrozen()) {
                        if (m.isActive()) {
                            allSync = allSync && this.synchronise(m);
                            continue;
                        }
                        this.console.printerrln("Warning, monitor is inactive, synchronisation failed!");
                        allSync = false;
                        continue;
                    }
                    this.console.printerrln("Monitor is frozen, skipping it.");
                }
            }
            this.synctime = System.currentTimeMillis() - start;
            boolean bl = allSync;
            return bl;
        }
        finally {
            this.stateListener.info("Performing optional post-sync operations.");
            this.stateListener.state(IStateListener.HawkState.RUNNING);
            this.listener.synchroniseEnd();
        }
    }

    protected boolean deleteRemovedModels(boolean success, IModelUpdater u, Set<VcsCommitItem> deleteditems) {
        this.stateListener.info("Deleting models removed from repository...");
        try {
            this.listener.changeStart();
            for (VcsCommitItem c : deleteditems) {
                boolean bl = success = success && u.deleteAll(c);
            }
            this.listener.changeSuccess();
        }
        catch (Exception e) {
            success = false;
            LOGGER.error("Error while deleting removed files from store", (Throwable)e);
            this.listener.changeFailure();
        }
        return success;
    }

    protected void importFiles(IFileImporter importer, Set<VcsCommitItem> changedItems, Map<String, File> pathToImported) {
        int iImported = 0;
        for (VcsCommitItem s : changedItems) {
            String commitPath = s.getPath();
            if (!pathToImported.containsKey(commitPath)) {
                File imported = importer.importFile(commitPath);
                pathToImported.put(commitPath, imported);
            }
            if (++iImported % 10 != 0) continue;
            this.stateListener.info(String.format("Imported %d/%d files from %s", iImported, changedItems.size(), s.getCommit().getDelta().getManager().getLocation()));
        }
    }

    @Override
    public Collection<IModelUpdater> getModelUpdaters() {
        return this.updaters;
    }

    @Override
    public void shutdown(IModelIndexer.ShutdownRequestType type) throws Exception {
        this.stateListener.info("Hawk shutting down...");
        this.preShutdown();
        if (this.graph != null) {
            this.graph.shutdown();
            this.graph = null;
        }
        if (this.credStore != null) {
            this.credStore.shutdown();
        }
        this.stateListener.info("Hawk shut down.");
    }

    @Override
    public void delete() throws Exception {
        this.preShutdown();
        if (this.graph != null) {
            this.graph.delete();
        }
        this.graph = null;
    }

    private void preShutdown() {
        try {
            this.saveIndexer();
        }
        catch (Exception e) {
            LOGGER.error("Error while saving the indexer during shut down", (Throwable)e);
        }
        try {
            LOGGER.info("Waiting {}s for all scheduled tasks to complete", (Object)120);
            this.updateTimer.shutdownNow();
            this.updateTimer.awaitTermination(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Wait for scheduled tasks was interrupted", (Throwable)e);
        }
        for (IVcsManager monitor : this.monitors) {
            monitor.shutdown();
        }
        this.monitors.clear();
        this.running = false;
        this.stateListener.state(IStateListener.HawkState.STOPPED);
    }

    @Override
    public IGraphDatabase getGraph() {
        return this.graph;
    }

    @Override
    public Set<String> getKnownMMUris() {
        return this.graph.getKnownMMUris();
    }

    @Override
    public Set<IVcsManager> getRunningVCSManagers() {
        return new HashSet<IVcsManager>(this.monitors);
    }

    @Override
    public String getId() {
        return this.getClass().getCanonicalName();
    }

    private void registerMetamodelFiles() throws Exception {
        this.stateListener.info("Registering metamodels...");
        Throwable throwable = null;
        Object var2_3 = null;
        try (IGraphTransaction t = this.graph.beginTransaction();){
            for (IGraphNode iGraphNode : this.graph.getMetamodelIndex().query("id", "*")) {
                String s = (String)iGraphNode.getProperty("resource");
                if (s == null) continue;
                String type = "" + iGraphNode.getProperty("type");
                String ep = "" + iGraphNode.getProperty("_hawkid");
                IMetaModelResourceFactory p = this.getMetaModelParser(type);
                if (p != null) {
                    p.parseFromString("resource_from_epackage_" + ep, s);
                    continue;
                }
                this.console.printerrln("cannot register metamodel in graph, named: " + ep + ", with type: " + type + ", as no relevant parser is registered");
            }
            t.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.stateListener.info("Registered metamodels.");
    }

    @Override
    public void removeMetamodels(String ... mm) throws Exception {
        this.stateListener.state(IStateListener.HawkState.UPDATING);
        this.stateListener.info("Removing metamodels...");
        for (String repoURL : this.metamodelupdater.removeMetamodels(this, mm)) {
            this.resetRepository(repoURL);
        }
        this.stateListener.state(IStateListener.HawkState.RUNNING);
        this.stateListener.info("Removed metamodels.");
    }

    @Override
    public void registerMetamodels(File ... metamodel) throws Exception {
        this.stateListener.info("Adding metamodel(s)...");
        HashSet<IHawkMetaModelResource> set = new HashSet<IHawkMetaModelResource>();
        IMetaModelResourceFactory parser = null;
        String previousParserType = null;
        File[] fileArray = metamodel;
        int n = metamodel.length;
        int n2 = 0;
        while (n2 < n) {
            File mm = fileArray[n2];
            parser = this.getMetaModelParserFromFilename(mm.getPath());
            if (parser == null) {
                this.console.printerrln("metamodel regstration failed, no relevant factory found");
            } else {
                String parserType = parser.getType();
                IHawkMetaModelResource metamodelResource = parser.parse(mm);
                if (previousParserType != null && !previousParserType.equals(parserType)) {
                    this.console.printerrln("cannot add heterogeneous metamodels concurrently, plase add one metamodel type at a time");
                    set.clear();
                    break;
                }
                if (metamodelResource != null) {
                    this.console.println("Adding metamodels in: " + mm + " to store");
                    set.add(metamodelResource);
                    previousParserType = parserType;
                }
            }
            ++n2;
        }
        this.metamodelupdater.insertMetamodels(set, this);
        for (IVcsManager s : this.monitors) {
            this.resetRepository(s.getLocation());
        }
        this.stateListener.info("Added metamodel(s).");
    }

    @Override
    public IConsole getConsole() {
        return this.console;
    }

    @Override
    public void addModelResourceFactory(IModelResourceFactory p) {
        this.modelParsers.put(p.getType(), p);
    }

    @Override
    public void addMetaModelResourceFactory(IMetaModelResourceFactory p) {
        this.metamodelParsers.put(p.getType(), p);
    }

    @Override
    public void addQueryEngine(IQueryEngine q) {
        this.knownQueryLanguages.put(q.getType(), q);
    }

    @Override
    public Set<String> getKnownMetaModelParserTypes() {
        return this.metamodelParsers.keySet();
    }

    @Override
    public Collection<IMetaModelResourceFactory> getMetaModelParsers() {
        return this.metamodelParsers.values();
    }

    @Override
    public IMetaModelResourceFactory getMetaModelParser(String type) {
        if (type != null) {
            return this.metamodelParsers.get(type);
        }
        this.console.printerrln("null type given to getMetaModelParser(type), returning null");
        return null;
    }

    @Override
    public Collection<IModelResourceFactory> getModelParsers() {
        return this.modelParsers.values();
    }

    public IMetaModelResourceFactory getMetaModelParserFromFilename(String name) {
        if (name == null) {
            this.console.printerrln("null extension given to getMetaModelParserFromFilename(extension), returning null");
        } else {
            for (String p : this.metamodelParsers.keySet()) {
                IMetaModelResourceFactory parser = this.metamodelParsers.get(p);
                for (String ext : parser.getMetaModelExtensions()) {
                    if (!name.endsWith(ext)) continue;
                    return parser;
                }
            }
        }
        return null;
    }

    public IModelResourceFactory getModelParserFromFilename(String name) {
        if (name == null) {
            this.console.printerrln("null extension given to getModelParserFromFilename(extension), returning null");
        } else {
            for (String p : this.modelParsers.keySet()) {
                IModelResourceFactory parser = this.modelParsers.get(p);
                for (String ext : parser.getModelExtensions()) {
                    if (!name.endsWith(ext)) continue;
                    return parser;
                }
            }
        }
        return null;
    }

    @Override
    public Map<String, IQueryEngine> getKnownQueryLanguages() {
        return this.knownQueryLanguages;
    }

    @Override
    public Set<String> getKnownMetamodelFileExtensions() {
        HashSet<String> exts = new HashSet<String>();
        for (IMetaModelResourceFactory mm : this.metamodelParsers.values()) {
            exts.addAll(mm.getMetaModelExtensions());
        }
        return exts;
    }

    @Override
    public void addModelUpdater(IModelUpdater u) {
        try {
            u.run(this.console, this);
            this.updaters.add(u);
        }
        catch (Exception e) {
            LOGGER.error("Error while adding model updater", (Throwable)e);
        }
    }

    @Override
    public IMetaModelUpdater getMetaModelUpdater() {
        return this.metamodelupdater;
    }

    @Override
    public void setMetaModelUpdater(IMetaModelUpdater u) {
        if (this.metamodelupdater == null) {
            u.run();
            this.metamodelupdater = u;
        } else {
            LOGGER.warn("metamodel updater alredy registered, cannot have more than one");
        }
    }

    public void saveIndexer() throws Exception {
        this.stateListener.info("Saving Hawk metadata...");
        XStream stream = XStreamUtils.createXStreamLoader(HawkProperties.class);
        HashSet<String[]> set = new HashSet<String[]>();
        for (IVcsManager s : this.getRunningVCSManagers()) {
            String[] meta = new String[]{s.getLocation(), s.getType(), String.valueOf(s.isFrozen())};
            this.console.println("adding: " + meta[0] + ":" + meta[1] + ":" + meta[2]);
            set.add(meta);
        }
        HawkProperties hp = new HawkProperties(this.graph.getType(), set, this.minDelay, this.maxDelay);
        Files.createDirectories(this.getParentFolder().toPath(), new FileAttribute[0]);
        String out = stream.toXML((Object)hp);
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedWriter b = new BufferedWriter(new FileWriter(this.getParentFolder() + File.separator + "properties.xml"));){
            b.write(out);
            b.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.stateListener.info("Saved Hawk metadata.");
    }

    @Override
    public void setDB(IGraphDatabase db, boolean persist) {
        this.graph = db;
        try {
            if (persist) {
                this.saveIndexer();
            }
        }
        catch (Exception e) {
            System.err.println("setDB tried to saveIndexer but failed");
            e.printStackTrace();
        }
    }

    @Override
    public void init(int minDelay, int maxDelay) throws Exception {
        this.stateListener.info("Initializing Hawk...");
        this.maxDelay = maxDelay;
        this.minDelay = minDelay;
        this.currentDelay = minDelay;
        this.console.println("inserting static metamodels of registered metamodel factories to graph:");
        for (String factoryNames : this.metamodelParsers.keySet()) {
            IMetaModelResourceFactory f = this.metamodelParsers.get(factoryNames);
            this.console.println(f.getType());
            this.metamodelupdater.insertMetamodels(f.getStaticMetamodels(), this);
        }
        this.console.println("inserting static metamodels complete");
        this.registerMetamodelFiles();
        this.updateTimer = new ScheduledThreadPoolExecutor(1){

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                BaseModelIndexer.this.insideUpdateThread.set(true);
                super.beforeExecute(t, r);
            }

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                BaseModelIndexer.this.insideUpdateThread.set(false);
            }
        };
        this.insideUpdateThread.set(false);
        this.updateTimer.submit(new RunUpdateTask(true));
        this.running = true;
        this.stateListener.state(IStateListener.HawkState.RUNNING);
        this.stateListener.info("Initialized Hawk.");
    }

    @Override
    public File getParentFolder() {
        return this.parentfolder;
    }

    @Override
    public void addDerivedAttribute(String metamodeluri, String typename, String attributename, String attributetype, boolean isMany, boolean isOrdered, boolean isUnique, String derivationlanguage, String derivationlogic) {
        this.stateListener.info(String.format("Adding derived attribute %s::%s::%s...", metamodeluri, typename, attributename));
        boolean success = this.metamodelupdater.addDerivedAttribute(metamodeluri, typename, attributename, attributetype, isMany, isOrdered, isUnique, derivationlanguage, derivationlogic, this);
        if (success) {
            for (IModelUpdater u : this.getModelUpdaters()) {
                u.updateDerivedAttribute(metamodeluri, typename, attributename, attributetype, isMany, isOrdered, isUnique, derivationlanguage, derivationlogic);
            }
        }
        this.cachedDerivedAttributes = null;
        this.stateListener.info(String.format("Added derived attribute %s::%s::%s.", metamodeluri, typename, attributename));
    }

    @Override
    public Collection<IndexedAttributeParameters> getDerivedAttributes() {
        if (this.cachedDerivedAttributes == null) {
            this.cachedDerivedAttributes = this.getExtraAttributes(true);
        }
        return this.cachedDerivedAttributes;
    }

    @Override
    public boolean removeDerivedAttribute(String metamodelUri, String typeName, String attributeName) {
        this.stateListener.info(String.format("Removing derived attribute %s::%s::%s...", metamodelUri, typeName, attributeName));
        boolean removed = this.metamodelupdater.removeDerivedAttribute(metamodelUri, typeName, attributeName, this);
        this.cachedDerivedAttributes = null;
        this.stateListener.info(removed ? String.format("Removed derived attribute %s::%s::%s.", metamodelUri, typeName, attributeName) : String.format("Derived attribute %s::%s::%s did not exist so nothing happened.", metamodelUri, typeName, attributeName));
        return removed;
    }

    @Override
    public void addIndexedAttribute(String metamodeluri, String typename, String attributename) {
        this.stateListener.info(String.format("Adding indexed attribute %s::%s::%s...", metamodeluri, typename, attributename));
        if (this.metamodelupdater.addIndexedAttribute(metamodeluri, typename, attributename, this)) {
            for (IModelUpdater u : this.getModelUpdaters()) {
                u.updateIndexedAttribute(metamodeluri, typename, attributename);
            }
        }
        this.stateListener.info(String.format("Added indexed attribute %s::%s::%s.", metamodeluri, typename, attributename));
    }

    @Override
    public Collection<IndexedAttributeParameters> getIndexedAttributes() {
        return this.getExtraAttributes(false);
    }

    @Override
    public boolean removeIndexedAttribute(String metamodelUri, String typename, String attributename) {
        this.stateListener.info(String.format("Removing indexed attribute %s::%s::%s...", metamodelUri, typename, attributename));
        boolean removed = this.metamodelupdater.removeIndexedAttribute(metamodelUri, typename, attributename, this);
        this.stateListener.info(removed ? String.format("Removed indexed attribute %s::%s::%s.", metamodelUri, typename, attributename) : String.format("Indexed attribute %s::%s::%s did not exist so nothing happened.", metamodelUri, typename, attributename));
        return removed;
    }

    private boolean isDerivedAttribute(IGraphNode typenode, String attrName) {
        String[] propertyInfo = (String[])typenode.getProperty(attrName);
        if (propertyInfo == null) {
            LOGGER.warn("Information on derived attribute {} in type node {} is missing", typenode.getId(), (Object)attrName);
            return false;
        }
        return propertyInfo[0].equals("d");
    }

    private Collection<IndexedAttributeParameters> getExtraAttributes(boolean isDerived) {
        HashSet<IndexedAttributeParameters> paramsSet = new HashSet<IndexedAttributeParameters>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (IGraphTransaction t = this.graph.beginTransaction();){
                Set<String> ret = this.getAttributeIndexNames();
                for (String s : ret) {
                    String[] split = s.split("##");
                    String mmURI = split[0];
                    String typeName = split[1];
                    String attrName = split[2];
                    IGraphNode typenode = this.getTypeNode(mmURI, typeName);
                    if (this.isDerivedAttribute(typenode, attrName) != isDerived) continue;
                    String[] metadata = (String[])typenode.getProperty(attrName);
                    IndexedAttributeParameters params = this.getAttributeParametersfromMetadata(mmURI, typeName, attrName, metadata);
                    paramsSet.add(params);
                }
                t.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.err.println("error in getExtraAttributes");
            e.printStackTrace();
        }
        return paramsSet;
    }

    private IGraphNode getTypeNode(String mmURI, String typeName) {
        Iterator itMetamodelNode = this.graph.getMetamodelIndex().get("id", mmURI).iterator();
        if (!itMetamodelNode.hasNext()) {
            throw new NoSuchElementException(String.format("Metamodel %s could not be found", mmURI));
        }
        IGraphNode epackagenode = (IGraphNode)itMetamodelNode.next();
        IGraphNode typenode = null;
        for (IGraphEdge e : epackagenode.getIncomingWithType("epackage")) {
            IGraphNode temp = e.getStartNode();
            if (!temp.getProperty("_hawkid").equals(typeName)) continue;
            if (typenode == null) {
                typenode = temp;
                continue;
            }
            System.err.println("error in getExtraAttributes, typenode had more than 1 type found");
        }
        return typenode;
    }

    private Set<String> getAttributeIndexNames() {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(this.graph.getNodeIndexNames());
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (s.matches("(.*)##(.*)##(.*)")) continue;
            it.remove();
        }
        return ret;
    }

    private IndexedAttributeParameters getAttributeParametersfromMetadata(String mmURI, String typeName, String attrName, String[] metadata) {
        IndexedAttributeParameters params = metadata[0].equals("d") ? new DerivedAttributeParameters(mmURI, typeName, attrName, metadata[4], metadata[1].equals("t"), metadata[2].equals("t"), metadata[3].equals("t"), metadata[5], metadata[6]) : new IndexedAttributeParameters(mmURI, typeName, attrName);
        return params;
    }

    @Override
    public Collection<String> getIndexes() {
        HashSet<String> ret = new HashSet<String>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (IGraphTransaction t = this.graph.beginTransaction();){
                ret.addAll(this.graph.getNodeIndexNames());
                t.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public List<String> validateExpression(String derivationlanguage, String derivationlogic) {
        IQueryEngine q = this.knownQueryLanguages.get(derivationlanguage);
        return q.validate(derivationlogic);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean addGraphChangeListener(IGraphChangeListener changeListener) {
        boolean add = this.listener.add(changeListener);
        changeListener.setModelIndexer(this);
        return add;
    }

    @Override
    public boolean removeGraphChangeListener(IGraphChangeListener changeListener) {
        boolean remove = this.listener.remove(changeListener);
        changeListener.setModelIndexer(null);
        return remove;
    }

    @Override
    public CompositeGraphChangeListener getCompositeGraphChangeListener() {
        return this.listener;
    }

    @Override
    public void setSyncMetricsEnabled(Boolean enable) {
        this.isSyncMetricsEnabled = enable;
    }

    public Map<VcsCommitItem, IHawkModelResource> getFileToResourceMap() {
        if (!this.isSyncMetricsEnabled) {
            LOGGER.warn("isSyncMetricsEnabled == false, this method will return an empty Map");
        }
        return this.fileToResourceMap;
    }

    public int getDeletedFiles() {
        return this.deletedFiles;
    }

    public int getInterestingFiles() {
        return this.interestingFiles;
    }

    public int getCurrChangedItems() {
        return this.currchangeditems;
    }

    public int getLoadedResources() {
        return this.loadedResources;
    }

    public long getLatestSynctime() {
        return this.synctime;
    }

    @Override
    public ICredentialsStore getCredentialsStore() {
        return this.credStore;
    }

    @Override
    public String getDerivedAttributeExecutionEngine() {
        if (!this.getKnownQueryLanguages().keySet().contains(DEFAULT_DERIVED_QUERY_ENGINE)) {
            LOGGER.warn("Default derived attribute engine ({}) disabled - will not be able to derive features");
        }
        return DEFAULT_DERIVED_QUERY_ENGINE;
    }

    @Override
    public boolean addStateListener(IStateListener listener) {
        return this.stateListener.add(listener);
    }

    @Override
    public boolean removeStateListener(IStateListener listener) {
        return this.stateListener.remove(listener);
    }

    @Override
    public CompositeStateListener getCompositeStateListener() {
        return this.stateListener;
    }

    @Override
    public void setPolling(int base, int max) {
        this.minDelay = base;
        this.maxDelay = max;
    }

    @Override
    public void waitFor(IStateListener.HawkState targetState) throws InterruptedException {
        this.waitFor(targetState, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitFor(IStateListener.HawkState targetState, long timeoutMillis) throws InterruptedException {
        CompositeStateListener compositeStateListener = this.stateListener;
        synchronized (compositeStateListener) {
            long end = System.currentTimeMillis() + timeoutMillis;
            IStateListener.HawkState s = this.stateListener.getCurrentState();
            while (s != targetState) {
                if (s == IStateListener.HawkState.STOPPED) {
                    throw new IllegalStateException("The selected Hawk is stopped");
                }
                if (timeoutMillis == 0L) {
                    this.stateListener.wait();
                } else {
                    long remaining = end - System.currentTimeMillis();
                    if (remaining <= 0L) break;
                    this.stateListener.wait(remaining);
                }
                s = this.stateListener.getCurrentState();
            }
        }
    }

    @Override
    public <T> ScheduledFuture<T> scheduleTask(Callable<T> task, long delayMillis) {
        if (this.insideUpdateThread.get().booleanValue()) {
            Object t = null;
            Exception ex = null;
            try {
                t = task.call();
            }
            catch (Exception e) {
                ex = e;
            }
            return new DummyScheduledFuture(t, ex);
        }
        return this.updateTimer.schedule(task, delayMillis, TimeUnit.MILLISECONDS);
    }

    protected void inspectChanges(Iterable<VcsCommitItem> files, Set<VcsCommitItem> deleteditems, Set<VcsCommitItem> interestingfiles) {
        this.stateListener.info("Calculating relevant changed model files...");
        block0: for (VcsCommitItem r : files) {
            for (IModelResourceFactory parser : this.modelParsers.values()) {
                for (String ext : parser.getModelExtensions()) {
                    if (!r.getPath().toLowerCase().endsWith(ext)) continue;
                    interestingfiles.add(r);
                    continue block0;
                }
            }
        }
        Iterator<VcsCommitItem> it = interestingfiles.iterator();
        while (it.hasNext()) {
            VcsCommitItem c = it.next();
            if (!c.getChangeType().equals((Object)VcsChangeType.DELETED)) continue;
            deleteditems.add(c);
            it.remove();
        }
    }

    protected boolean internalSynchronise(String currentRevision, IVcsManager m, IModelUpdater u, Set<VcsCommitItem> deletedItems, Set<VcsCommitItem> interestingfiles, String monitorTempDir) {
        boolean success = true;
        Set<VcsCommitItem> currReposChangedItems = u.compareWithLocalFiles(interestingfiles);
        int totalFiles = currReposChangedItems.size();
        this.currchangeditems += totalFiles;
        HashMap<String, File> pathToImported = new HashMap<String, File>();
        DefaultFileImporter importer = new DefaultFileImporter(m, currentRevision, new File(monitorTempDir));
        this.importFiles(importer, currReposChangedItems, pathToImported);
        success = this.deleteRemovedModels(success, u, deletedItems);
        this.stateListener.info("Updating models to the new version...");
        this.graph.enterBatchMode();
        boolean fileCountProgress = totalFiles > 100;
        long millisSinceStart = System.currentTimeMillis();
        int totalProcessedFiles = 0;
        int filesProcessedSinceLastPrint = 0;
        long millisSinceLastPrint = millisSinceStart;
        for (VcsCommitItem v : currReposChangedItems) {
            try {
                if (fileCountProgress && (totalProcessedFiles == 0 && filesProcessedSinceLastPrint == 0 || filesProcessedSinceLastPrint == 100)) {
                    long millisPrint = System.currentTimeMillis();
                    this.stateListener.info(String.format("Processed %d/%d files in repo %s (%s sec, %s sec total)", totalProcessedFiles += filesProcessedSinceLastPrint, totalFiles, m.getLocation(), (millisPrint - millisSinceLastPrint) / 1000L, (millisPrint - millisSinceStart) / 1000L));
                    filesProcessedSinceLastPrint = 0;
                    millisSinceLastPrint = millisPrint;
                }
                IHawkResource r = null;
                if (u.caresAboutResources()) {
                    File file = (File)pathToImported.get(v.getPath());
                    if (file == null || !file.exists()) {
                        this.console.printerrln("warning, cannot find file: " + file + ", ignoring changes");
                    } else {
                        IModelResourceFactory mrf = this.getModelParserFromFilename(file.getName().toLowerCase());
                        if (mrf.canParse(file)) {
                            r = mrf.parse(importer, file);
                        }
                    }
                }
                boolean bl = success = u.updateStore(v, (IHawkModelResource)r) && success;
                if (r != null) {
                    if (!this.isSyncMetricsEnabled) {
                        r.unload();
                    } else {
                        this.fileToResourceMap.put(v, (IHawkModelResource)r);
                    }
                    ++this.loadedResources;
                }
                ++filesProcessedSinceLastPrint;
            }
            catch (Exception e) {
                this.console.printerrln("updater: " + u + "failed to update store");
                this.console.printerrln(e);
                success = false;
            }
        }
        if (fileCountProgress) {
            long millisPrint = System.currentTimeMillis();
            this.stateListener.info(String.format("Processed %d/%d files in repo %s (%s sec, %s sec total)", totalProcessedFiles += filesProcessedSinceLastPrint, totalFiles, m.getLocation(), (millisPrint - millisSinceLastPrint) / 1000L, (millisPrint - millisSinceStart) / 1000L));
        }
        this.stateListener.info("Updating proxies...");
        u.updateProxies();
        this.graph.exitBatchMode();
        this.stateListener.info("Updated proxies.");
        return success;
    }

    protected boolean synchroniseFiles(String revision, IVcsManager vcsManager, Collection<VcsCommitItem> files) {
        HashSet<VcsCommitItem> deleteditems = new HashSet<VcsCommitItem>();
        HashSet<VcsCommitItem> interestingfiles = new HashSet<VcsCommitItem>();
        this.inspectChanges(files, deleteditems, interestingfiles);
        this.deletedFiles += deleteditems.size();
        this.interestingFiles += interestingfiles.size();
        String monitorTempDir = this.graph.getTempDir();
        File temp = new File(monitorTempDir);
        temp.mkdir();
        boolean updatersOK = true;
        for (IModelUpdater updater : this.getModelUpdaters()) {
            boolean bl = updatersOK = updatersOK && this.internalSynchronise(revision, vcsManager, updater, deleteditems, interestingfiles, monitorTempDir);
        }
        if (!FileOperations.deleteFiles(new File(monitorTempDir), true)) {
            this.console.printerrln("error in deleting temporary local vcs files");
        }
        return updatersOK;
    }

    @Override
    public void removeMetaModelResourceFactory(IMetaModelResourceFactory metaModelParser) {
        this.metamodelParsers.remove(metaModelParser.getType());
        this.requestImmediateSync();
    }

    @Override
    public void removeModelResourceFactory(IModelResourceFactory modelParser) {
        this.modelParsers.remove(modelParser.getType());
        this.requestImmediateSync();
    }

    @Override
    public void removeModelUpdater(IModelUpdater updater) throws Exception {
        if (this.updaters.size() <= 1) {
            throw new Exception("Cannot remove updater, as hawk requires at least one");
        }
        this.updaters.remove(updater);
        this.requestImmediateSync();
    }

    public static class DefaultFileImporter
    implements IFileImporter {
        private final Map<String, File> cachedImports = new HashMap<String, File>();
        private final IVcsManager vcs;
        private final String revision;
        private final File tempDir;

        public DefaultFileImporter(IVcsManager vcs, String revision, File tempDir) {
            this.vcs = vcs;
            this.revision = revision;
            this.tempDir = tempDir;
        }

        @Override
        public File importFile(String commitPath) {
            if (!this.cachedImports.containsKey(commitPath)) {
                String[] commitPathSplit = commitPath.split("/");
                File destination = this.tempDir;
                if (commitPathSplit.length > 1) {
                    String[] stringArray = commitPathSplit;
                    int n = commitPathSplit.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String pathComponent = stringArray[n2];
                        destination = new File(destination, pathComponent);
                        ++n2;
                    }
                    destination.getParentFile().mkdirs();
                } else {
                    destination = new File(destination, commitPath);
                }
                File result = this.vcs.importFile(this.revision, commitPath, destination);
                this.cachedImports.put(commitPath, result);
                return result;
            }
            return this.cachedImports.get(commitPath);
        }
    }

    private static final class DummyScheduledFuture<T>
    implements ScheduledFuture<T> {
        private final T t2;
        private final Exception ex2;

        private DummyScheduledFuture(T t2, Exception ex2) {
            this.t2 = t2;
            this.ex2 = ex2;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(Delayed o) {
            return 0;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws ExecutionException {
            if (this.ex2 == null) {
                return this.t2;
            }
            throw new ExecutionException(this.ex2);
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws ExecutionException {
            return this.get();
        }
    }

    private final class RunUpdateTask
    extends TimerTask {
        private boolean periodic;

        private RunUpdateTask(boolean periodic) {
            this.periodic = periodic;
        }

        @Override
        public void run() {
            BaseModelIndexer.this.stateListener.info("Updating Hawk...");
            long start = System.currentTimeMillis();
            boolean synchronised = true;
            BaseModelIndexer.this.console.println("updating indexer: ");
            try {
                synchronised = BaseModelIndexer.this.synchronise();
            }
            catch (Throwable e) {
                LOGGER.error("Error during synchronisation", e);
            }
            if (!synchronised) {
                BaseModelIndexer.this.console.println("SYNCHRONISATION ERROR");
                BaseModelIndexer.this.stateListener.error("Update FAILED!");
            }
            if (BaseModelIndexer.this.maxDelay > 0) {
                if (!BaseModelIndexer.this.latestUpdateFoundChanges) {
                    int oldDelay = BaseModelIndexer.this.currentDelay;
                    BaseModelIndexer.this.currentDelay = Math.min(BaseModelIndexer.this.currentDelay * 2, BaseModelIndexer.this.maxDelay);
                    BaseModelIndexer.this.console.println(String.format("same revision, incrementing check timer: %s s -> %s s (max: %s s)", oldDelay / 1000, BaseModelIndexer.this.currentDelay / 1000, BaseModelIndexer.this.maxDelay / 1000));
                } else if (!synchronised) {
                    int oldDelay = BaseModelIndexer.this.currentDelay;
                    BaseModelIndexer.this.currentDelay = Math.min(BaseModelIndexer.this.currentDelay * 2, Math.min(60000, BaseModelIndexer.this.maxDelay));
                    BaseModelIndexer.this.console.println(String.format("update failed, incrementing check timer: %s s -> %s s (max: %s s with %s s ceiling)", oldDelay / 1000, BaseModelIndexer.this.currentDelay / 1000, BaseModelIndexer.this.maxDelay / 1000, 60));
                } else {
                    BaseModelIndexer.this.console.println("different revisions, resetting check timer and propagating changes!");
                    BaseModelIndexer.this.currentDelay = BaseModelIndexer.this.minDelay;
                }
                if (this.periodic) {
                    BaseModelIndexer.this.updateTimer.schedule(new RunUpdateTask(true), (long)BaseModelIndexer.this.currentDelay, TimeUnit.MILLISECONDS);
                }
            }
            long time = System.currentTimeMillis() - start;
            BaseModelIndexer.this.stateListener.info(String.format("Updated Hawk instance %s (%s). %d s %d ms", BaseModelIndexer.this.getName(), synchronised ? "success" : "failure", time / 1000L, time % 1000L));
        }
    }
}

