/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.server.users.servlet.servlets;

import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServlet;
import org.eclipse.hawk.service.api.UserExists;
import org.eclipse.hawk.service.api.UserNotFound;
import org.eclipse.hawk.service.api.UserProfile;
import org.eclipse.hawk.service.api.Users;
import org.eclipse.hawk.service.server.users.servlet.UsersPlugin;
import org.eclipse.hawk.service.server.users.servlet.db.User;
import org.eclipse.hawk.service.server.users.servlet.db.UserStorage;
import org.mapdb.BTreeMap;
import org.mapdb.DB;

public class UserServlet
extends TServlet {
    private static final long serialVersionUID = 1L;

    public UserServlet() throws Exception {
        super((TProcessor)new Users.Processor((Users.Iface)new UsersIface()), (TProtocolFactory)new TJSONProtocol.Factory());
    }

    private static class UsersIface
    implements Users.Iface {
        private UsersIface() {
        }

        public void createUser(String username, String password, UserProfile profile) throws UserExists, TException {
            UserStorage storage = UsersPlugin.getInstance().getStorage();
            try (DB db = storage.getTxMaker().makeTx();){
                BTreeMap<String, User> userMap = storage.getUserMap(db);
                if (userMap.containsKey((Object)username)) {
                    throw new UserExists();
                }
                String hashed = UserStorage.getPasswordService().encryptPassword((Object)password);
                User user = User.builder().username(username).hashedPassword(hashed).realName(profile.realName).isAdmin(profile.admin).build();
                userMap.put((Object)username, (Object)user);
                db.commit();
            }
        }

        public void updateProfile(String username, UserProfile profile) throws UserNotFound, TException {
            UserStorage storage = UsersPlugin.getInstance().getStorage();
            try (DB db = storage.getTxMaker().makeTx();){
                BTreeMap<String, User> userMap = storage.getUserMap(db);
                User oldUser = (User)userMap.get((Object)username);
                if (oldUser == null) {
                    throw new UserNotFound();
                }
                User newUser = User.builder(oldUser).realName(profile.realName).isAdmin(profile.admin).build();
                userMap.put((Object)username, (Object)newUser);
                db.commit();
            }
        }

        public void updatePassword(String username, String password) throws UserNotFound, TException {
            UserStorage storage = UsersPlugin.getInstance().getStorage();
            try (DB db = storage.getTxMaker().makeTx();){
                BTreeMap<String, User> userMap = storage.getUserMap(db);
                User oldUser = (User)userMap.get((Object)username);
                if (oldUser == null) {
                    throw new UserNotFound();
                }
                String hashed = UserStorage.getPasswordService().encryptPassword((Object)password);
                User newUser = User.builder(oldUser).hashedPassword(hashed).build();
                userMap.put((Object)username, (Object)newUser);
                db.commit();
            }
        }

        public void deleteUser(String username) throws UserNotFound, TException {
            UserStorage storage = UsersPlugin.getInstance().getStorage();
            try (DB db = storage.getTxMaker().makeTx();){
                BTreeMap<String, User> userMap = storage.getUserMap(db);
                if (!userMap.containsKey((Object)username)) {
                    throw new UserNotFound();
                }
                userMap.remove((Object)username);
                db.commit();
            }
        }
    }
}

