/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.graal;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.nativeimage.hosted.Feature;

public class DisableLoggingFeature
implements Feature {
    private static final String[] CATEGORIES = new String[]{"org.jboss.threads"};
    private final Map<String, Level> categoryMap = new HashMap<String, Level>(CATEGORIES.length);

    @Override
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        for (String category : CATEGORIES) {
            Logger logger2 = Logger.getLogger(category);
            this.categoryMap.put(category, logger2.getLevel());
            logger2.setLevel(Level.WARNING);
        }
    }

    @Override
    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        for (String category : CATEGORIES) {
            Level level = this.categoryMap.remove(category);
            if (level == null) continue;
            Logger logger2 = Logger.getLogger(category);
            logger2.setLevel(level);
        }
    }
}

