/*
 * Decompiled with CFR 0.152.
 */
package picocli.shell.jline3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.jline.builtins.Options;
import org.jline.console.ArgDesc;
import org.jline.console.CmdDesc;
import org.jline.console.CommandRegistry;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.SystemCompleter;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.InfoCmp;
import picocli.CommandLine;

public class PicocliCommands
implements CommandRegistry {
    private String picocliCommandsName;
    private final CommandLine cmd;
    private final Set<String> commands;
    private final Map<String, String> aliasCommand = new HashMap<String, String>();

    public PicocliCommands(CommandLine cmd) {
        this.cmd = cmd;
        this.commands = cmd.getCommandSpec().subcommands().keySet();
        for (String c : this.commands) {
            for (String a : cmd.getSubcommands().get(c).getCommandSpec().aliases()) {
                this.aliasCommand.put(a, c);
            }
        }
    }

    @Override
    public boolean hasCommand(String command) {
        return this.commands.contains(command) || this.aliasCommand.containsKey(command);
    }

    @Override
    public SystemCompleter compileCompleters() {
        SystemCompleter out = new SystemCompleter();
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(this.commands);
        all.addAll(this.aliasCommand.keySet());
        out.add(all, (Completer)new PicocliCompleter());
        return out;
    }

    private CommandLine findSubcommandLine(List<String> args, int lastIdx) {
        CommandLine out = this.cmd;
        for (int i = 0; i < lastIdx && (args.get(i).startsWith("-") || (out = this.findSubcommandLine(out, args.get(i))) != null); ++i) {
        }
        return out;
    }

    private CommandLine findSubcommandLine(CommandLine cmdline, String command) {
        for (CommandLine s : cmdline.getSubcommands().values()) {
            if (!s.getCommandName().equals(command) && !Arrays.asList(s.getCommandSpec().aliases()).contains(command)) continue;
            return s;
        }
        return null;
    }

    @Override
    public CmdDesc commandDescription(List<String> args) {
        CommandLine sub = this.findSubcommandLine(args, args.size());
        if (sub == null) {
            return null;
        }
        CommandLine.Model.CommandSpec spec = sub.getCommandSpec();
        CommandLine.Help cmdhelp = new CommandLine.Help(spec);
        ArrayList<AttributedString> main = new ArrayList<AttributedString>();
        HashMap<String, List<AttributedString>> options = new HashMap<String, List<AttributedString>>();
        String synopsis = AttributedString.stripAnsi(spec.usageMessage().sectionMap().get("synopsis").render(cmdhelp).toString());
        main.add(Options.HelpException.highlightSyntax(synopsis.trim(), Options.HelpException.defaultStyle()));
        for (CommandLine.Model.OptionSpec o : spec.options()) {
            String key = Arrays.stream(o.names()).collect(Collectors.joining(" "));
            ArrayList<AttributedString> val = new ArrayList<AttributedString>();
            for (String d : o.description()) {
                val.add(new AttributedString(d));
            }
            if (o.arity().max() > 0) {
                key = key + "=" + o.paramLabel();
            }
            options.put(key, val);
        }
        return new CmdDesc(main, ArgDesc.doArgNames(Arrays.asList("")), options);
    }

    @Override
    public List<String> commandInfo(String command) {
        ArrayList<String> out = new ArrayList<String>();
        CommandLine.Model.CommandSpec spec = this.cmd.getSubcommands().get(command).getCommandSpec();
        CommandLine.Help cmdhelp = new CommandLine.Help(spec);
        String description = AttributedString.stripAnsi(spec.usageMessage().sectionMap().get("description").render(cmdhelp).toString());
        out.addAll(Arrays.asList(description.split("\\r?\\n")));
        return out;
    }

    @Override
    public Object invoke(CommandRegistry.CommandSession session, String command, Object[] args) throws Exception {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(command);
        arguments.addAll(Arrays.stream(args).map(Object::toString).collect(Collectors.toList()));
        this.cmd.execute(arguments.toArray(new String[0]));
        return null;
    }

    public Object execute(CommandRegistry.CommandSession session, String command, String[] args) throws Exception {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(command);
        arguments.addAll(Arrays.asList(args));
        this.cmd.execute(arguments.toArray(new String[0]));
        return null;
    }

    @Override
    public Set<String> commandNames() {
        return this.commands;
    }

    @Override
    public Map<String, String> commandAliases() {
        return this.aliasCommand;
    }

    public CmdDesc commandDescription(String command) {
        return null;
    }

    @Override
    public String name() {
        if (this.picocliCommandsName != null) {
            return this.picocliCommandsName;
        }
        return CommandRegistry.super.name();
    }

    public void name(String newName) {
        this.picocliCommandsName = newName;
    }

    private class PicocliCompleter
    extends ArgumentCompleter
    implements Completer {
        public PicocliCompleter() {
            super(NullCompleter.INSTANCE);
        }

        @Override
        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            assert (commandLine != null);
            assert (candidates != null);
            String word = commandLine.word();
            List<String> words = commandLine.words();
            CommandLine sub = PicocliCommands.this.findSubcommandLine(words, commandLine.wordIndex());
            if (sub == null) {
                return;
            }
            if (word.startsWith("-")) {
                String buffer = word.substring(0, commandLine.wordCursor());
                int eq = buffer.indexOf(61);
                for (CommandLine.Model.OptionSpec option : sub.getCommandSpec().options()) {
                    if (option.arity().max() == 0 && eq < 0) {
                        this.addCandidates(candidates, Arrays.asList(option.names()));
                        continue;
                    }
                    if (eq > 0) {
                        String opt = buffer.substring(0, eq);
                        if (!Arrays.asList(option.names()).contains(opt) || option.completionCandidates() == null) continue;
                        this.addCandidates(candidates, option.completionCandidates(), buffer.substring(0, eq + 1), "", true);
                        continue;
                    }
                    this.addCandidates(candidates, Arrays.asList(option.names()), "", "=", false);
                }
            } else {
                this.addCandidates(candidates, sub.getSubcommands().keySet());
                for (CommandLine s : sub.getSubcommands().values()) {
                    this.addCandidates(candidates, Arrays.asList(s.getCommandSpec().aliases()));
                }
            }
        }

        private void addCandidates(List<Candidate> candidates, Iterable<String> cands) {
            this.addCandidates(candidates, cands, "", "", true);
        }

        private void addCandidates(List<Candidate> candidates, Iterable<String> cands, String preFix, String postFix, boolean complete) {
            for (String s : cands) {
                candidates.add(new Candidate(AttributedString.stripAnsi(preFix + s + postFix), s, null, null, null, null, complete));
            }
        }
    }

    public static class PicocliCommandsFactory
    implements CommandLine.IFactory {
        private CommandLine.IFactory nextFactory;
        private Terminal terminal;

        public PicocliCommandsFactory() {
        }

        public PicocliCommandsFactory(CommandLine.IFactory nextFactory) {
            this.nextFactory = nextFactory;
        }

        @Override
        public <K> K create(Class<K> clazz) throws Exception {
            if (ClearScreen.class == clazz) {
                return (K)new ClearScreen(this.terminal);
            }
            if (this.nextFactory != null) {
                return this.nextFactory.create(clazz);
            }
            return CommandLine.defaultFactory().create(clazz);
        }

        public void setTerminal(Terminal terminal) {
            this.terminal = terminal;
        }
    }

    @CommandLine.Command(name="cls", aliases={"clear"}, mixinStandardHelpOptions=true, description={"Clears the screen"}, version={"1.0"})
    public static class ClearScreen
    implements Callable<Void> {
        private final Terminal terminal;

        ClearScreen(Terminal terminal) {
            this.terminal = terminal;
        }

        @Override
        public Void call() throws IOException {
            if (this.terminal != null) {
                this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
            }
            return null;
        }
    }
}

