/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.basicchunk;

import com.ibm.jbatch.tck.artifacts.basicchunk.BasicItem;
import com.ibm.jbatch.tck.artifacts.basicchunk.BasicProcessorException;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemProcessor;
import jakarta.batch.runtime.context.JobContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;

@Named(value="basicProcessor")
public class BasicProcessor
implements ItemProcessor {
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="throw.processor.exception.for.these.items")
    String injectedThrowProcessorExceptionForTheseItems;
    private int[] throwProcessorExceptionForTheseItems = new int[0];
    @Inject
    @BatchProperty(name="filter.out.these.items")
    String injectedFilterOutTheseItems;
    private int[] filterOutTheseItems = new int[0];
    boolean initialized = false;
    private BasicItem currentItem = null;

    private void initializeProcessor() {
        int i;
        if (this.injectedThrowProcessorExceptionForTheseItems != null) {
            String[] exceptionsStringArray = this.injectedThrowProcessorExceptionForTheseItems.split(",");
            this.throwProcessorExceptionForTheseItems = new int[exceptionsStringArray.length];
            for (i = 0; i < exceptionsStringArray.length; ++i) {
                this.throwProcessorExceptionForTheseItems[i] = Integer.parseInt(exceptionsStringArray[i]);
            }
        }
        if (this.injectedFilterOutTheseItems != null) {
            String[] filterStringArray = this.injectedFilterOutTheseItems.split(",");
            this.filterOutTheseItems = new int[filterStringArray.length];
            for (i = 0; i < filterStringArray.length; ++i) {
                this.filterOutTheseItems[i] = Integer.parseInt(filterStringArray[i]);
            }
        }
        this.initialized = true;
    }

    public BasicItem processItem(Object item) throws Exception {
        if (!this.initialized) {
            this.initializeProcessor();
        }
        this.currentItem = (BasicItem)item;
        if (this.processorExceptionShouldBeThrownForCurrentItem()) {
            this.jobCtx.setExitStatus("BasicProcessorException:Item#" + this.currentItem.getId());
            throw new BasicProcessorException("BasicProcessorException thrown for item " + this.currentItem.getId());
        }
        if (this.currentItemShouldBeFilteredOut()) {
            return null;
        }
        this.currentItem.setProcessed(true);
        return this.currentItem;
    }

    private boolean processorExceptionShouldBeThrownForCurrentItem() {
        for (int i : this.throwProcessorExceptionForTheseItems) {
            if (this.currentItem.getId() != i) continue;
            return true;
        }
        return false;
    }

    private boolean currentItemShouldBeFilteredOut() {
        for (int i : this.filterOutTheseItems) {
            if (this.currentItem.getId() != i) continue;
            return true;
        }
        return false;
    }
}

