/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.interview.ChoiceArrayQuestion;
import com.sun.interview.ChoiceQuestion;
import com.sun.interview.FileListQuestion;
import com.sun.interview.PropertiesQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringListQuestion;
import com.sun.interview.TreeQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.Keywords;
import com.sun.javatest.Parameters;
import com.sun.javatest.Status;
import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.report.ReportFormat;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.report.XMLReportMaker;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class XMLReport
implements ReportFormat {
    static final String REPORT_NAME = "report.xml";
    private static final String ID = "xml";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(XMLReport.class);

    @Override
    public ReportFormat.ReportLink write(ReportSettings sett, File dir) throws IOException {
        File repFile = new File(dir, REPORT_NAME);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(repFile), "UTF-8"));
        try {
            this.write(w, sett);
        }
        catch (SAXException ex) {
            throw new JavaTestError(i18n.getString("report.writing.err"), ex);
        }
        ((Writer)w).close();
        sett.xmlReportFile = repFile;
        return new ReportFormat.ReportLink(i18n.getString("index.xmltype.txt"), this.getBaseDirName(), i18n.getString("index.desc.xml"), repFile);
    }

    @Override
    public String getReportID() {
        return ID;
    }

    @Override
    public String getBaseDirName() {
        return ID;
    }

    @Override
    public String getTypeName() {
        return ID;
    }

    @Override
    public boolean acceptSettings(ReportSettings s) {
        return s.isXmlEnabled();
    }

    @Override
    public List<ReportFormat> getSubReports() {
        return Collections.emptyList();
    }

    public void write(Writer w, ReportSettings sett) throws IOException, SAXException {
        XMLReportMaker maker = new XMLReportMaker(w);
        maker.sDocument();
        maker.sReport();
        maker.sWorkdirectories();
        File jti = null;
        if (sett.getInterview() != null) {
            jti = sett.getInterview().getFile();
        }
        maker.sWorkdirectory(jti == null ? null : jti.getPath());
        this.writeTemplateInfo(maker, sett);
        this.writeInterview(maker, sett);
        this.writeStandardValues(maker, sett);
        this.writeEnvironment(maker, sett);
        maker.eWorkdirectory();
        maker.eWorkdirectories();
        this.writeResults(maker, sett);
        maker.eReport();
        maker.eDocument();
    }

    private void writeResults(XMLReportMaker maker, ReportSettings sett) throws SAXException, JavaTestError, IOException {
        maker.sTestResults();
        File[] initFiles = sett.getInitialFiles();
        TestResultTable.TreeIterator iter = null;
        TestResultTable resultTable = sett.getInterview().getWorkDirectory().getTestResultTable();
        try {
            iter = initFiles == null ? resultTable.getIterator(sett.getTestFilter()) : resultTable.getIterator(initFiles, sett.getTestFilter());
            while (iter.hasNext()) {
                TestResult tr = (TestResult)iter.next();
                this.writeResult(maker, tr);
            }
            maker.eTestResults();
        }
        catch (TestResultTable.Fault f) {
            throw new JavaTestError(i18n.getString("report.testResult.err"), f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResult(XMLReportMaker maker, TestResult testResult) throws SAXException, IOException {
        maker.sTestResult(testResult.getTestName(), testResult.getStatus(), 1);
        try {
            this.writeDescriptionData(maker, testResult);
            this.writeEnvironment(maker, testResult);
            this.writeResultProps(maker, testResult);
            this.writeSections(maker, testResult);
            this.writeAnnotations(maker, testResult);
        }
        catch (TestResult.Fault e) {
            System.err.println(i18n.getString("report.writing.err"));
            e.printStackTrace();
        }
        finally {
            maker.eTestResult();
        }
    }

    private void writeSections(XMLReportMaker maker, TestResult testResult) throws SAXException, IOException, TestResult.Fault {
        maker.sSections();
        for (int i = 0; i < testResult.getSectionCount(); ++i) {
            String st = testResult.getSectionTitles()[i];
            TestResult.Section sec = testResult.getSection(i);
            Status stat = sec.getStatus();
            maker.sSection(st, stat);
            for (int j = 0; j < sec.getOutputCount(); ++j) {
                String oName = sec.getOutputNames()[j];
                maker.sOutput(oName, sec.getOutput(oName));
                maker.eOutput();
            }
            maker.eSection();
        }
        maker.eSections();
    }

    private void writeResultProps(XMLReportMaker maker, TestResult testResult) throws SAXException, TestResult.Fault {
        String time = testResult.getProperty("end");
        maker.sResultProps(time);
        Enumeration<String> en = testResult.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            String val = testResult.getProperty(key);
            if ("end".equals(key)) continue;
            maker.makeProperty(key, val);
        }
        maker.eResultProps();
    }

    private void writeEnvironment(XMLReportMaker maker, TestResult testResult) throws SAXException {
        try {
            Map<String, String> m = testResult.getEnvironment();
            Iterator<String> keysIt = m.keySet().iterator();
            maker.sTestEnvironment();
            while (keysIt.hasNext()) {
                String key = keysIt.next();
                String val = m.get(key);
                maker.makeProperty(key, val);
            }
            maker.eTestEnvironment();
        }
        catch (TestResult.Fault fault) {
            // empty catch block
        }
    }

    private void writeDescriptionData(XMLReportMaker maker, TestResult testResult) throws SAXException, TestResult.Fault {
        maker.sDescriptionData();
        TestDescription td = testResult.getDescription();
        Iterator<String> keysIt = td.getParameterKeys();
        maker.makeProperty("$root", td.getRootDir());
        maker.makeProperty("$file", td.getFile().getPath());
        while (keysIt.hasNext()) {
            String key = keysIt.next();
            if ("keywords".equals(key)) continue;
            String val = td.getParameter(key);
            maker.makeProperty(key, val);
        }
        String[] kws = td.getKeywords();
        if (kws != null && kws.length > 0) {
            maker.sKeyWords();
            maker.makeItems(kws);
            maker.eKeyWords();
        }
        maker.eDescriptionData();
    }

    private void writeAnnotations(XMLReportMaker maker, TestResult testResult) throws SAXException {
        TestResultTable.TreeNode tn = testResult.getParent();
        TestResultTable trt = null;
        WorkDirectory wd = null;
        if (tn == null) {
            return;
        }
        trt = tn.getEnclosingTable();
        if (trt == null) {
            return;
        }
        wd = trt.getWorkDirectory();
        Map<String, String> map = wd.getTestAnnotations(testResult);
        if (map != null) {
            maker.sTAnnotationData();
            for (String key : map.keySet()) {
                maker.makeProperty(key, map.get(key));
            }
            maker.eTAnnotationData();
        }
    }

    private void writeEnvironment(XMLReportMaker maker, ReportSettings sett) throws SAXException {
        String name = null;
        String descr = null;
        if (sett.getInterview().getEnv() != null) {
            name = sett.getInterview().getEnv().getName();
            descr = sett.getInterview().getEnv().getDescription();
        }
        maker.sEnvironment(name, descr);
        TestEnvironment env = sett.getInterview().getEnv();
        if (env != null) {
            for (TestEnvironment.Element envElem : env.elements()) {
                maker.makeProperty(envElem.getKey(), envElem.getValue());
            }
        }
        maker.eEnvironment();
    }

    private void writeStandardValues(XMLReportMaker maker, ReportSettings sett) throws SAXException {
        maker.sStdValues();
        this.writeTestsToRun(maker, sett);
        this.writePriorStatusList(maker, sett);
        this.writeExcludeLists(maker, sett);
        maker.conCur(sett.getInterview().getConcurrency());
        maker.timeOut(sett.getInterview().getTimeoutFactor());
        this.writeKeyWords(maker, sett);
        maker.eStdValues();
    }

    private void writeKeyWords(XMLReportMaker maker, ReportSettings sett) throws SAXException {
        Keywords keywords = sett.getInterview().getKeywords();
        if (keywords != null) {
            maker.sKeyWords(sett.getInterview().getKeywords().toString());
            maker.eKeyWords();
        }
    }

    private void writeExcludeLists(XMLReportMaker maker, ReportSettings sett) throws SAXException {
        ExcludeList excludeList = sett.getInterview().getExcludeList();
        if (excludeList != null) {
            Parameters.ExcludeListParameters exclParams = sett.getInterview().getExcludeListParameters();
            File[] excludeFiles = null;
            if (exclParams instanceof Parameters.MutableExcludeListParameters) {
                excludeFiles = ((Parameters.MutableExcludeListParameters)exclParams).getExcludeFiles();
            }
            if (excludeFiles != null && excludeFiles.length > 0) {
                maker.sExclList();
                maker.makeItems(excludeFiles);
                maker.eExclList();
            }
        }
    }

    private void writePriorStatusList(XMLReportMaker maker, ReportSettings sett) throws SAXException {
        boolean[] b = sett.getInterview().getPriorStatusValues();
        if (b != null) {
            int[] ss = new int[]{0, 1, 2, 3};
            maker.sPriorStatusList();
            for (int i = 0; i < b.length; ++i) {
                if (!b[i]) continue;
                maker.makeItem(Utils.statusIntToString(ss[i]));
            }
            maker.ePriorStatusList();
        }
    }

    private void writeTestsToRun(XMLReportMaker maker, ReportSettings sett) throws SAXException {
        maker.sTests();
        String[] tests = sett.getInterview().getTests();
        if (tests != null && tests.length > 0) {
            for (String test : tests) {
                maker.makeItem(test);
            }
        } else {
            maker.makeEntireTestTree();
        }
        maker.eTests();
    }

    private void writeTemplateInfo(XMLReportMaker maker, ReportSettings sett) throws SAXException {
        String tPath = sett.getInterview().getTemplatePath();
        if (tPath != null) {
            try {
                TemplateUtilities.ConfigInfo ci = TemplateUtilities.getConfigInfo(new File(tPath));
                maker.makeTemplateInfo(tPath, ci.getName(), ci.getDescription());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeInterview(XMLReportMaker maker, ReportSettings sett) throws SAXException {
        Question[] questions;
        maker.sInterview();
        for (Question q : questions = sett.getInterview().getPath()) {
            maker.sQuestion(q.getStringValue(), q.getText(), q.getSummary());
            if (q instanceof TreeQuestion || q instanceof StringListQuestion || q instanceof FileListQuestion) {
                this.writeListQuestion(maker, q);
            } else if (q instanceof ChoiceQuestion || q instanceof YesNoQuestion || q instanceof ChoiceArrayQuestion) {
                this.writeChoiceQuestion(maker, q);
            } else if (q instanceof PropertiesQuestion) {
                this.writePropertiesQuestion(maker, q);
            }
            maker.eQuestion();
        }
        maker.eInterview();
    }

    private void writeListQuestion(XMLReportMaker maker, Question q) throws SAXException {
        maker.sListQuestion();
        if (q instanceof TreeQuestion) {
            TreeQuestion tq = (TreeQuestion)q;
            maker.makeItems(tq.getValue());
        } else if (q instanceof StringListQuestion) {
            StringListQuestion slq = (StringListQuestion)q;
            maker.makeItems(slq.getValue());
        } else if (q instanceof FileListQuestion) {
            FileListQuestion flq = (FileListQuestion)q;
            maker.makeItems(flq.getValue());
        }
        maker.eListQuestion();
    }

    private void writePropertiesQuestion(XMLReportMaker maker, Question q) throws SAXException {
        maker.sPropertiesQuestion();
        PropertiesQuestion pq = (PropertiesQuestion)q;
        String[] grs = pq.getGroups();
        String h1 = pq.getKeyHeaderName();
        String h2 = pq.getValueHeaderName();
        if (grs != null) {
            for (String name : grs) {
                maker.sGroup(name, h1, h2);
                if (name != null) {
                    String[][] table = pq.getGroup(name);
                    this.writeTable(maker, table);
                }
                maker.eGroup(name, h1, h2);
            }
        }
        maker.ePropertiesQuestion();
    }

    private void writeChoiceQuestion(XMLReportMaker maker, Question q) throws SAXException {
        maker.sChoiceQuestion();
        if (q instanceof ChoiceQuestion) {
            ChoiceQuestion cq = (ChoiceQuestion)q;
            maker.makeChoices(cq.getChoices(), cq.getDisplayChoices());
        } else if (q instanceof YesNoQuestion) {
            YesNoQuestion ynq = (YesNoQuestion)q;
            maker.makeChoices(ynq.getChoices(), ynq.getDisplayChoices());
        } else if (q instanceof ChoiceArrayQuestion) {
            ChoiceArrayQuestion caq = (ChoiceArrayQuestion)q;
            maker.makeChoices(caq.getChoices(), caq.getDisplayChoices(), caq.getValue());
        }
        maker.eChoiceQuestion();
    }

    private void writeTable(XMLReportMaker maker, String[] ... table) throws SAXException {
        if (table != null) {
            for (String[] aTable : table) {
                maker.makeRow(aTable[0], aTable[1]);
            }
        }
    }

    static class Utils {
        Utils() {
        }

        static String dateToISO8601(Date date) {
            SimpleDateFormat dfISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            String dateStr = dfISO8601.format(date);
            return dateStr.substring(0, 22) + ":" + dateStr.substring(22);
        }

        static Date jtrToDate(String dateStr) throws ParseException {
            return TestResult.parseDate(dateStr);
        }

        static String statusToString(Status st) {
            if (st.isError()) {
                return "ERROR";
            }
            if (st.isFailed()) {
                return "FAILED";
            }
            if (st.isNotRun()) {
                return "NOT_RUN";
            }
            if (st.isPassed()) {
                return "PASSED";
            }
            return "UNKNOWN";
        }

        static String statusIntToString(int st) {
            if (st == 2) {
                return "ERROR";
            }
            if (st == 1) {
                return "FAILED";
            }
            if (st == 3) {
                return "NOT_RUN";
            }
            if (st == 0) {
                return "PASSED";
            }
            return "UNKNOWN";
        }
    }
}

