/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.http.server.manager;

import java.security.cert.PKIXRevocationChecker;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.http.server.manager.HttpServiceOptions;
import org.eclipse.kura.security.keystore.KeystoreChangedEvent;
import org.eclipse.kura.security.keystore.KeystoreService;
import org.eclipse.kura.system.SystemService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpService
implements ConfigurableComponent,
EventHandler {
    private static final String KURA_JETTY_PID = "kura.default";
    private static final Logger logger = LoggerFactory.getLogger(HttpService.class);
    private HttpServiceOptions options;
    private SystemService systemService;
    private KeystoreService keystoreService;
    private String keystoreServicePid;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private Future<?> restartTask = CompletableFuture.completedFuture(null);

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void setKeystoreService(KeystoreService keystoreService, Map<String, Object> properties) {
        this.keystoreService = keystoreService;
        this.keystoreServicePid = (String)properties.get("kura.service.pid");
    }

    public void activate(Map<String, Object> properties) {
        logger.info("Activating {}", (Object)this.getClass().getSimpleName());
        this.options = new HttpServiceOptions(properties, this.systemService.getKuraHome());
        this.activateHttpService();
        logger.info("Activating... Done.");
    }

    public synchronized void updated(Map<String, Object> properties) {
        logger.info("Updating {}", (Object)this.getClass().getSimpleName());
        HttpServiceOptions updatedOptions = new HttpServiceOptions(properties, this.systemService.getKuraHome());
        if (!this.options.equals(updatedOptions)) {
            logger.debug("Updating, new props");
            this.options = updatedOptions;
            this.cancelRestartTask();
            this.restartHttpService();
        }
        logger.info("Updating... Done.");
    }

    public synchronized void deactivate() {
        logger.info("Deactivating {}", (Object)this.getClass().getSimpleName());
        this.cancelRestartTask();
        this.deactivateHttpService();
        this.shutdownExecutor();
    }

    private Dictionary<String, Object> getJettyConfig() {
        String customizerClass;
        Hashtable<String, Object> jettyConfig = new Hashtable<String, Object>();
        Set<Integer> httpPorts = this.options.getHttpPorts();
        Set<Integer> httpsPorts = this.options.getHttpsPorts();
        Set<Integer> httpsWithClientAuthPorts = this.options.getHttpsClientAuthPorts();
        boolean isHttpEnabled = !httpPorts.isEmpty();
        boolean isHttpsEnabled = !httpsPorts.isEmpty() || !httpsWithClientAuthPorts.isEmpty();
        ((Dictionary)jettyConfig).put("http.enabled", isHttpEnabled);
        if (isHttpEnabled) {
            ((Dictionary)jettyConfig).put("org.eclipse.kura.http.ports", httpPorts);
        }
        if ((customizerClass = System.getProperty("org.eclipse.equinox.http.jetty.customizer.class")) instanceof String) {
            ((Dictionary)jettyConfig).put("customizer.class", customizerClass);
        }
        if (!isHttpsEnabled) {
            return jettyConfig;
        }
        KeystoreService currentKeystoreService = this.keystoreService;
        if (currentKeystoreService == null) {
            logger.warn("HTTPS is enabled but keystore service is not configured properly, disabling HTTPS");
            ((Dictionary)jettyConfig).put("https.enabled", false);
            ((Dictionary)jettyConfig).put("kura.https.client.auth.enabled", false);
            return jettyConfig;
        }
        ((Dictionary)jettyConfig).put("https.enabled", isHttpsEnabled);
        if (!httpsPorts.isEmpty()) {
            ((Dictionary)jettyConfig).put("org.eclipse.kura.https.ports", httpsPorts);
        }
        if (!httpsWithClientAuthPorts.isEmpty()) {
            ((Dictionary)jettyConfig).put("org.eclipse.kura.https.client.auth.ports", httpsWithClientAuthPorts);
        }
        ((Dictionary)jettyConfig).put("https.host", "0.0.0.0");
        ((Dictionary)jettyConfig).put("org.eclipse.kura.keystore.provider", () -> ((KeystoreService)currentKeystoreService).getKeyStore());
        ((Dictionary)jettyConfig).put("org.eclipse.kura.keymanager.provider", a -> {
            try {
                return currentKeystoreService.getKeyManagers(a);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
        try {
            ((Dictionary)jettyConfig).put("org.eclipse.kura.crl.store", currentKeystoreService.getCRLStore());
        }
        catch (KuraException e) {
            logger.warn("failed to obtain CRL store", (Throwable)e);
        }
        ((Dictionary)jettyConfig).put("ssl.keystore", "/tmp/foo");
        ((Dictionary)jettyConfig).put("ssl.password", "foo");
        boolean isRevocationEnabled = this.options.isRevocationEnabled();
        ((Dictionary)jettyConfig).put("org.eclipse.kura.revocation.check.enabled", isRevocationEnabled);
        HttpServiceOptions.RevocationCheckMode revocationCheckMode = this.options.getRevocationCheckMode();
        if (isRevocationEnabled) {
            EnumSet<PKIXRevocationChecker.Option> checkerOptions = revocationCheckMode == HttpServiceOptions.RevocationCheckMode.CRL_ONLY ? EnumSet.of(PKIXRevocationChecker.Option.PREFER_CRLS, PKIXRevocationChecker.Option.NO_FALLBACK) : (revocationCheckMode == HttpServiceOptions.RevocationCheckMode.PREFER_CRL ? EnumSet.of(PKIXRevocationChecker.Option.PREFER_CRLS) : EnumSet.noneOf(PKIXRevocationChecker.Option.class));
            if (this.options.isRevocationSoftFailEnabled()) {
                checkerOptions.add(PKIXRevocationChecker.Option.SOFT_FAIL);
            }
            ((Dictionary)jettyConfig).put("org.eclipse.kura.revocation.checker.options", checkerOptions);
        }
        return jettyConfig;
    }

    private synchronized void restartHttpService() {
        this.deactivateHttpService();
        this.activateHttpService();
    }

    private synchronized void activateHttpService() {
        this.executorService.submit(() -> {
            try {
                logger.info("starting Jetty instance...");
                JettyConfigurator.startServer((String)KURA_JETTY_PID, this.getJettyConfig());
                logger.info("starting Jetty instance...done");
            }
            catch (Exception e) {
                logger.error("Could not start Jetty Web server", (Throwable)e);
            }
        });
    }

    private synchronized void deactivateHttpService() {
        this.executorService.submit(() -> {
            try {
                logger.info("stopping Jetty instance...");
                JettyConfigurator.stopServer((String)KURA_JETTY_PID);
                logger.info("stopping Jetty instance...done");
            }
            catch (Exception e) {
                logger.error("Could not stop Jetty Web server", (Throwable)e);
            }
        });
    }

    private synchronized void shutdownExecutor() {
        try {
            try {
                this.executorService.shutdown();
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Could not stop executor", (Throwable)e);
                this.executorService.shutdownNow();
            }
        }
        finally {
            this.executorService.shutdownNow();
        }
    }

    private synchronized void cancelRestartTask() {
        if (!this.restartTask.isDone()) {
            this.restartTask.cancel(false);
        }
    }

    private synchronized void scheduleDeferredRestart() {
        this.cancelRestartTask();
        try {
            this.restartTask = this.executorService.schedule(this::restartHttpService, 10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.warn("failed to schedule restart task", (Throwable)e);
        }
    }

    public void handleEvent(Event event) {
        if (!(event instanceof KeystoreChangedEvent)) {
            return;
        }
        KeystoreChangedEvent keystoreChangedEvent = (KeystoreChangedEvent)event;
        if (keystoreChangedEvent.getSenderPid().equals(this.keystoreServicePid)) {
            this.scheduleDeferredRestart();
        }
    }
}

