/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.net.NetworkConfiguration;
import org.eclipse.kura.core.net.util.NetworkUtil;
import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.IP6Address;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.NetConfigIP4;
import org.eclipse.kura.net.NetConfigIP6;
import org.eclipse.kura.net.NetInterfaceStatus;
import org.eclipse.kura.net.configuration.NetworkConfigurationConstants;
import org.eclipse.kura.net.dhcp.DhcpServerCfg;
import org.eclipse.kura.net.dhcp.DhcpServerCfgIP4;
import org.eclipse.kura.net.dhcp.DhcpServerConfigIP4;
import org.eclipse.kura.net.firewall.FirewallAutoNatConfig;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.usb.UsbDevice;
import org.eclipse.kura.usb.UsbNetDevice;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpConfigurationInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(IpConfigurationInterpreter.class);
    private static final String NET_INTERFACE = "net.interface.";

    private IpConfigurationInterpreter() {
    }

    public static List<NetConfig> populateConfiguration(Map<String, Object> props, String interfaceName, IPAddress netInterfaceAddress, boolean virtualInterface) throws UnknownHostException {
        NetConfigIP6 netConfigIP6;
        DhcpServerConfigIP4 dhcpServerConfigIP4;
        ArrayList<NetConfig> netConfigs = new ArrayList<NetConfig>();
        if (Objects.isNull(props)) {
            return netConfigs;
        }
        NetConfigIP4 netConfigIP4 = IpConfigurationInterpreter.getIp4NetConfig(props, interfaceName, virtualInterface);
        List<IP4Address> dnsAddreses = IpConfigurationInterpreter.getIp4Dns(props, interfaceName);
        netConfigIP4.setDnsServers(dnsAddreses);
        List<IP4Address> winsIPs = IpConfigurationInterpreter.getIp4WinsServers(props, interfaceName);
        netConfigIP4.setWinsServers(winsIPs);
        List<String> domainNames = IpConfigurationInterpreter.getIp4Domains(props, interfaceName);
        netConfigIP4.setDomains(domainNames);
        netConfigs.add((NetConfig)netConfigIP4);
        String configNatEnabled = NET_INTERFACE + interfaceName + ".config.nat.enabled";
        if (props.containsKey(configNatEnabled)) {
            boolean natEnabled = (Boolean)props.get(configNatEnabled);
            logger.trace("NAT enabled? {}", (Object)natEnabled);
            if (natEnabled) {
                FirewallAutoNatConfig natConfig = new FirewallAutoNatConfig(interfaceName, "unknown", true);
                netConfigs.add((NetConfig)natConfig);
            }
        }
        if (!Objects.isNull(dhcpServerConfigIP4 = IpConfigurationInterpreter.getDhcpServerIp4(props, interfaceName, netInterfaceAddress, netConfigIP4))) {
            netConfigs.add((NetConfig)dhcpServerConfigIP4);
        }
        if (!Objects.isNull(netConfigIP6 = IpConfigurationInterpreter.getIp6NetConfig(props, interfaceName))) {
            netConfigs.add((NetConfig)IpConfigurationInterpreter.getIp6NetConfig(props, interfaceName));
        }
        return netConfigs;
    }

    private static DhcpServerConfigIP4 getDhcpServerIp4(Map<String, Object> props, String interfaceName, IPAddress netInterfaceAddress, NetConfigIP4 netConfigIP4) throws UnknownHostException {
        DhcpServerConfigIP4 dhcpServerConfigIP4 = null;
        String configDhcpServerEnabled = NET_INTERFACE + interfaceName + ".config.dhcpServer4.enabled";
        if (props.containsKey(configDhcpServerEnabled)) {
            boolean dhcpEnabled = IpConfigurationInterpreter.isDhcpClient4Enabled(props, interfaceName);
            IP4Address routerAddress = dhcpEnabled ? (IP4Address)netInterfaceAddress : (IP4Address)netConfigIP4.getAddress();
            short prefix = IpConfigurationInterpreter.getDhcpServer4Prefix(props, interfaceName);
            IP4Address rangeStart = IpConfigurationInterpreter.getDhcpServer4RangeStart(props, interfaceName);
            IP4Address rangeEnd = IpConfigurationInterpreter.getDncpServer4RangeEnd(props, interfaceName);
            int defaultLeaseTime = IpConfigurationInterpreter.getDhcpServer4DefaultLeaseTime(props, interfaceName);
            int maximumLeaseTime = IpConfigurationInterpreter.getDhcpServerMaxLeaseTime(props, interfaceName);
            boolean passDns = IpConfigurationInterpreter.isDhcpServerPassDns(props, interfaceName);
            if (routerAddress != null && rangeStart != null && rangeEnd != null) {
                short prefixInt = prefix;
                int mask = ~((1 << 32 - prefixInt) - 1);
                String subnetMaskString = NetworkUtil.dottedQuad(mask);
                String subnetString = NetworkUtil.calculateNetwork(routerAddress.getHostAddress(), subnetMaskString);
                IP4Address subnet = (IP4Address)IPAddress.parseHostAddress((String)subnetString);
                IP4Address subnetMask = (IP4Address)IPAddress.parseHostAddress((String)subnetMaskString);
                ArrayList<IP4Address> dnServers = new ArrayList<IP4Address>();
                dnServers.add(routerAddress);
                boolean dhcpServerEnabled = (Boolean)props.get(configDhcpServerEnabled);
                DhcpServerCfg dhcpServerCfg = new DhcpServerCfg(interfaceName, dhcpServerEnabled, defaultLeaseTime, maximumLeaseTime, passDns);
                DhcpServerCfgIP4 dhcpServerCfgIP4 = new DhcpServerCfgIP4(subnet, subnetMask, prefix, routerAddress, rangeStart, rangeEnd, dnServers);
                try {
                    dhcpServerConfigIP4 = new DhcpServerConfigIP4(dhcpServerCfg, dhcpServerCfgIP4);
                }
                catch (KuraException kuraException) {
                    logger.warn("This invalid DhcpServerCfgIP4 configuration is ignored - {}, {}", (Object)dhcpServerCfg, (Object)dhcpServerCfgIP4);
                }
            }
        }
        return dhcpServerConfigIP4;
    }

    private static SystemService getSystemService() {
        BundleContext context = FrameworkUtil.getBundle(NetworkConfiguration.class).getBundleContext();
        ServiceReference systemServiceSR = context.getServiceReference(SystemService.class);
        return (SystemService)context.getService(systemServiceSR);
    }

    private static List<String> getIp4Domains(Map<String, Object> props, String interfaceName) {
        String configDomains = NET_INTERFACE + interfaceName + ".config.ip4.domains";
        ArrayList<String> domainNames = new ArrayList<String>();
        if (props.containsKey(configDomains)) {
            String[] domains;
            String domainsAll = (String)props.get(configDomains);
            String[] stringArray = domains = domainsAll.split(",");
            int n = domains.length;
            int n2 = 0;
            while (n2 < n) {
                String domain = stringArray[n2];
                logger.trace("IPv4 Domain: {}", (Object)domain);
                domainNames.add(domain);
                ++n2;
            }
        }
        return domainNames;
    }

    private static List<IP4Address> getIp4WinsServers(Map<String, Object> props, String interfaceName) throws UnknownHostException {
        String configWINSs = NET_INTERFACE + interfaceName + ".config.ip4.winsServers";
        ArrayList<IP4Address> winsIPs = new ArrayList<IP4Address>();
        if (props.containsKey(configWINSs)) {
            String[] winss;
            String winsAll = (String)props.get(configWINSs);
            String[] stringArray = winss = winsAll.split(",");
            int n = winss.length;
            int n2 = 0;
            while (n2 < n) {
                String wins = stringArray[n2];
                logger.trace("WINS: {}", (Object)wins);
                IP4Address winsIp4 = (IP4Address)IPAddress.parseHostAddress((String)wins);
                winsIPs.add(winsIp4);
                ++n2;
            }
        }
        return winsIPs;
    }

    private static List<IP4Address> getIp4Dns(Map<String, Object> props, String interfaceName) throws UnknownHostException {
        String configDNSs = NET_INTERFACE + interfaceName + ".config.ip4.dnsServers";
        ArrayList<IP4Address> dnsIPs = new ArrayList<IP4Address>();
        if (props.containsKey(configDNSs)) {
            String[] dnss;
            String dnsAll = (String)props.get(configDNSs);
            String[] stringArray = dnss = dnsAll.split(",");
            int n = dnss.length;
            int n2 = 0;
            while (n2 < n) {
                String dns = stringArray[n2];
                String trimmedDns = dns.trim();
                if (trimmedDns != null && trimmedDns.length() > 0) {
                    logger.trace("IPv4 DNS: {}", (Object)trimmedDns);
                    IP4Address dnsIp4 = (IP4Address)IPAddress.parseHostAddress((String)trimmedDns);
                    dnsIPs.add(dnsIp4);
                }
                ++n2;
            }
        }
        return dnsIPs;
    }

    public static UsbDevice getUsbDeviceInfo(Map<String, Object> props, String interfaceName) {
        UsbNetDevice usbDevice = null;
        if (Objects.isNull(props)) {
            return usbDevice;
        }
        StringBuilder sbPrefix = new StringBuilder();
        String netIfReadOnlyPrefix = sbPrefix.append(NET_INTERFACE).append(interfaceName).append(".").toString();
        String vendorId = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.vendor.id");
        String vendorName = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.vendor.name");
        String productId = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.product.id");
        String productName = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.product.name");
        String usbBusNumber = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.busNumber");
        String usbDevicePath = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.devicePath");
        if (vendorId != null && productId != null) {
            usbDevice = new UsbNetDevice(vendorId, productId, vendorName, productName, usbBusNumber, usbDevicePath, interfaceName);
            logger.trace("adding usbDevice: {}, port: {}", (Object)usbDevice, (Object)usbDevice.getUsbPort());
        }
        return usbDevice;
    }

    private static NetConfigIP4 getIp4NetConfig(Map<String, Object> props, String interfaceName, boolean virtualInterface) throws UnknownHostException {
        NetInterfaceStatus status4 = IpConfigurationInterpreter.getIp4Status(props, interfaceName, virtualInterface);
        NetConfigIP4 netConfigIP4 = new NetConfigIP4(status4, IpConfigurationInterpreter.getAutoConnectProperty(status4));
        boolean dhcpEnabled = IpConfigurationInterpreter.isDhcpClient4Enabled(props, interfaceName);
        if (dhcpEnabled) {
            netConfigIP4.setDhcp(true);
        } else {
            IP4Address ip4Gateway;
            IP4Address ip4Address = IpConfigurationInterpreter.getIp4StaticAddress(props, interfaceName);
            if (!Objects.isNull(ip4Address)) {
                netConfigIP4.setAddress((IPAddress)ip4Address);
            }
            try {
                Short networkPrefixLength = IpConfigurationInterpreter.getIp4StaticPrefix(props, interfaceName);
                if (!Objects.isNull(networkPrefixLength)) {
                    netConfigIP4.setNetworkPrefixLength(networkPrefixLength.shortValue());
                }
            }
            catch (KuraException e) {
                logger.error("Exception while setting Network Prefix length!", (Throwable)e);
            }
            if (!Objects.isNull(ip4Gateway = IpConfigurationInterpreter.getIp4StaticGateway(props, interfaceName))) {
                netConfigIP4.setGateway((IPAddress)ip4Gateway);
            }
        }
        return netConfigIP4;
    }

    private static NetInterfaceStatus getIp4Status(Map<String, Object> props, String interfaceName, boolean virtualInterface) {
        SystemService service;
        NetInterfaceStatus configStatus4 = NetworkConfigurationConstants.DEFAULT_IPV4_STATUS_VALUE;
        String configStatus4Key = NET_INTERFACE + interfaceName + ".config.ip4.status";
        if (props.containsKey(configStatus4Key)) {
            configStatus4 = NetInterfaceStatus.valueOf((String)((String)props.get(configStatus4Key)));
        } else if (virtualInterface && (service = IpConfigurationInterpreter.getSystemService()) != null) {
            configStatus4 = NetInterfaceStatus.valueOf((String)service.getNetVirtualDevicesConfig());
        }
        logger.trace("Status Ipv4? {}", (Object)configStatus4);
        return configStatus4;
    }

    private static IP4Address getIp4StaticGateway(Map<String, Object> props, String interfaceName) throws UnknownHostException {
        String configIp4Gateway = NET_INTERFACE + interfaceName + ".config.ip4.gateway";
        String gatewayIp4 = (String)props.get(configIp4Gateway);
        IP4Address ip4Gateway = null;
        if (!Objects.isNull(gatewayIp4) && !gatewayIp4.trim().isEmpty()) {
            logger.trace("IPv4 gateway: {}", (Object)gatewayIp4);
            ip4Gateway = (IP4Address)IPAddress.parseHostAddress((String)gatewayIp4);
        }
        return ip4Gateway;
    }

    private static Short getIp4StaticPrefix(Map<String, Object> props, String interfaceName) {
        String configIp4Prefix = NET_INTERFACE + interfaceName + ".config.ip4.prefix";
        Short networkPrefixLength = -1;
        Object ip4PrefixObj = props.get(configIp4Prefix);
        if (!Objects.isNull(ip4PrefixObj)) {
            if (ip4PrefixObj instanceof Short) {
                networkPrefixLength = (Short)ip4PrefixObj;
            } else if (ip4PrefixObj instanceof String && !((String)ip4PrefixObj).isEmpty()) {
                networkPrefixLength = Short.parseShort((String)ip4PrefixObj);
            }
        }
        return networkPrefixLength;
    }

    private static IP4Address getIp4StaticAddress(Map<String, Object> props, String interfaceName) throws UnknownHostException {
        String configIp4 = NET_INTERFACE + interfaceName + ".config.ip4.address";
        String addressIp4 = (String)props.get(configIp4);
        IP4Address ip4Address = null;
        if (!Objects.isNull(addressIp4) && !addressIp4.trim().isEmpty()) {
            logger.trace("IPv4 address: {}", (Object)addressIp4);
            ip4Address = (IP4Address)IPAddress.parseHostAddress((String)addressIp4);
        }
        return ip4Address;
    }

    private static boolean isDhcpServerPassDns(Map<String, Object> props, String interfaceName) {
        boolean passDns = false;
        String configDhcpServerPassDns = NET_INTERFACE + interfaceName + ".config.dhcpServer4.passDns";
        if (props.containsKey(configDhcpServerPassDns)) {
            if (props.get(configDhcpServerPassDns) instanceof Boolean) {
                passDns = (Boolean)props.get(configDhcpServerPassDns);
            } else if (props.get(configDhcpServerPassDns) instanceof String) {
                passDns = Boolean.parseBoolean((String)props.get(configDhcpServerPassDns));
            }
            logger.trace("DHCP Server Pass DNS?: {}", (Object)passDns);
        }
        return passDns;
    }

    private static int getDhcpServerMaxLeaseTime(Map<String, Object> props, String interfaceName) {
        int maximumLeaseTime = -1;
        String configDhcpServerMaxLeaseTime = NET_INTERFACE + interfaceName + ".config.dhcpServer4.maxLeaseTime";
        if (props.containsKey(configDhcpServerMaxLeaseTime)) {
            if (props.get(configDhcpServerMaxLeaseTime) instanceof Integer) {
                maximumLeaseTime = (Integer)props.get(configDhcpServerMaxLeaseTime);
            } else if (props.get(configDhcpServerMaxLeaseTime) instanceof String) {
                maximumLeaseTime = Integer.parseInt((String)props.get(configDhcpServerMaxLeaseTime));
            }
            logger.trace("DHCP Server Maximum Lease Time: {}", (Object)maximumLeaseTime);
        }
        return maximumLeaseTime;
    }

    private static int getDhcpServer4DefaultLeaseTime(Map<String, Object> props, String interfaceName) {
        int defaultLeaseTime = -1;
        String configDhcpServerDefaultLeaseTime = NET_INTERFACE + interfaceName + ".config.dhcpServer4.defaultLeaseTime";
        if (props.containsKey(configDhcpServerDefaultLeaseTime)) {
            if (props.get(configDhcpServerDefaultLeaseTime) instanceof Integer) {
                defaultLeaseTime = (Integer)props.get(configDhcpServerDefaultLeaseTime);
            } else if (props.get(configDhcpServerDefaultLeaseTime) instanceof String) {
                defaultLeaseTime = Integer.parseInt((String)props.get(configDhcpServerDefaultLeaseTime));
            }
            logger.trace("DHCP Server Default Lease Time: {}", (Object)defaultLeaseTime);
        }
        return defaultLeaseTime;
    }

    private static IP4Address getDncpServer4RangeEnd(Map<String, Object> props, String interfaceName) throws UnknownHostException {
        IP4Address rangeEnd = null;
        String configDhcpServerRangeEnd = NET_INTERFACE + interfaceName + ".config.dhcpServer4.rangeEnd";
        if (props.containsKey(configDhcpServerRangeEnd)) {
            String dhcpServerRangeEnd = (String)props.get(configDhcpServerRangeEnd);
            logger.trace("DHCP Server Range End: {}", (Object)dhcpServerRangeEnd);
            if (dhcpServerRangeEnd != null && !dhcpServerRangeEnd.isEmpty()) {
                rangeEnd = (IP4Address)IPAddress.parseHostAddress((String)dhcpServerRangeEnd);
            }
        }
        return rangeEnd;
    }

    private static IP4Address getDhcpServer4RangeStart(Map<String, Object> props, String interfaceName) throws UnknownHostException {
        IP4Address rangeStart = null;
        String configDhcpServerRangeStart = NET_INTERFACE + interfaceName + ".config.dhcpServer4.rangeStart";
        if (props.containsKey(configDhcpServerRangeStart)) {
            String dhcpServerRangeStart = (String)props.get(configDhcpServerRangeStart);
            logger.trace("DHCP Server Range Start: {}", (Object)dhcpServerRangeStart);
            if (dhcpServerRangeStart != null && !dhcpServerRangeStart.isEmpty()) {
                rangeStart = (IP4Address)IPAddress.parseHostAddress((String)dhcpServerRangeStart);
            }
        }
        return rangeStart;
    }

    private static short getDhcpServer4Prefix(Map<String, Object> props, String interfaceName) {
        short prefix = NetworkConfigurationConstants.DEFAULT_IPV4_DHCP_SERVER_PREFIX_VALUE;
        String configDhcpServerPrefix = NET_INTERFACE + interfaceName + ".config.dhcpServer4.prefix";
        if (props.containsKey(configDhcpServerPrefix)) {
            if (props.get(configDhcpServerPrefix) instanceof Short) {
                prefix = (Short)props.get(configDhcpServerPrefix);
            } else if (props.get(configDhcpServerPrefix) instanceof String) {
                prefix = Short.parseShort((String)props.get(configDhcpServerPrefix));
            }
            logger.trace("DHCP Server prefix: {}", (Object)prefix);
        }
        return prefix;
    }

    private static NetConfigIP6 getIp6NetConfig(Map<String, Object> props, String interfaceName) throws UnknownHostException {
        String configStatus6 = NetInterfaceStatus.netIPv6StatusDisabled.name();
        String configStatus6Key = NET_INTERFACE + interfaceName + ".config.ip6.status";
        Object value = props.get(configStatus6Key);
        if (!Objects.isNull(value) && value instanceof String) {
            configStatus6 = (String)value;
        }
        String configDhcp6 = NET_INTERFACE + interfaceName + ".config.dhcpClient6.enabled";
        NetConfigIP6 netConfigIP6 = null;
        boolean dhcp6Enabled = false;
        value = props.get(configDhcp6);
        if (!Objects.isNull(value) && value instanceof Boolean) {
            dhcp6Enabled = (Boolean)value;
        }
        if (!dhcp6Enabled) {
            List<String> ip6DomainNames;
            List<IP6Address> dns6IPs;
            NetInterfaceStatus status6 = NetInterfaceStatus.valueOf((String)configStatus6);
            netConfigIP6 = new NetConfigIP6(status6, IpConfigurationInterpreter.getAutoConnectProperty(status6), dhcp6Enabled);
            IP6Address ip6Address = IpConfigurationInterpreter.getIp6StaticAddress(props, interfaceName);
            if (!Objects.isNull(ip6Address)) {
                netConfigIP6.setAddress((IPAddress)ip6Address);
            }
            if (!(dns6IPs = IpConfigurationInterpreter.getIp6StaticDnsServers(props, interfaceName)).isEmpty()) {
                netConfigIP6.setDnsServers(dns6IPs);
            }
            if (!(ip6DomainNames = IpConfigurationInterpreter.getIp6StaticDomains(props, interfaceName)).isEmpty()) {
                netConfigIP6.setDomains(ip6DomainNames);
            }
        }
        return netConfigIP6;
    }

    private static List<String> getIp6StaticDomains(Map<String, Object> props, String interfaceName) {
        String configDomains6 = NET_INTERFACE + interfaceName + ".config.ip6.domains";
        String domainsAll = (String)props.get(configDomains6);
        ArrayList<String> domainNames = new ArrayList<String>();
        if (!Objects.isNull(domainsAll) && !domainsAll.trim().isEmpty()) {
            String[] domains;
            String[] stringArray = domains = domainsAll.split(",");
            int n = domains.length;
            int n2 = 0;
            while (n2 < n) {
                String domain = stringArray[n2];
                logger.trace("IPv6 Domain: {}", (Object)domain);
                domainNames.add(domain);
                ++n2;
            }
        }
        return domainNames;
    }

    private static List<IP6Address> getIp6StaticDnsServers(Map<String, Object> props, String interfaceName) throws UnknownHostException {
        String configDNSs6 = NET_INTERFACE + interfaceName + ".config.ip6.dnsServers";
        String dnsAll = (String)props.get(configDNSs6);
        ArrayList<IP6Address> dnsIPs = new ArrayList<IP6Address>();
        if (!Objects.isNull(dnsAll) && !dnsAll.trim().isEmpty()) {
            String[] dnss;
            String[] stringArray = dnss = dnsAll.split(",");
            int n = dnss.length;
            int n2 = 0;
            while (n2 < n) {
                String dns = stringArray[n2];
                logger.trace("IPv6 DNS: {}", (Object)dns);
                IP6Address dnsIp6 = (IP6Address)IPAddress.parseHostAddress((String)dns);
                dnsIPs.add(dnsIp6);
                ++n2;
            }
        }
        return dnsIPs;
    }

    private static IP6Address getIp6StaticAddress(Map<String, Object> props, String interfaceName) throws UnknownHostException {
        String configIp6 = NET_INTERFACE + interfaceName + ".config.ip6.address";
        String addressIp6 = (String)props.get(configIp6);
        IP6Address ip6Address = null;
        if (!Objects.isNull(addressIp6) && !addressIp6.trim().isEmpty()) {
            logger.trace("IPv6 address: {}", (Object)addressIp6);
            ip6Address = (IP6Address)IPAddress.parseHostAddress((String)addressIp6);
        }
        return ip6Address;
    }

    private static boolean isDhcpClient4Enabled(Map<String, Object> props, String interfaceName) {
        String configDhcp4 = NET_INTERFACE + interfaceName + ".config.dhcpClient4.enabled";
        boolean dhcpEnabled = false;
        if (props.containsKey(configDhcp4)) {
            dhcpEnabled = (Boolean)props.get(configDhcp4);
            logger.trace("DHCP 4 enabled? {}", (Object)dhcpEnabled);
        }
        return dhcpEnabled;
    }

    private static boolean getAutoConnectProperty(NetInterfaceStatus status) {
        boolean autoconnect = false;
        if (status.equals((Object)NetInterfaceStatus.netIPv4StatusEnabledLAN) || status.equals((Object)NetInterfaceStatus.netIPv4StatusEnabledWAN) || status.equals((Object)NetInterfaceStatus.netIPv4StatusL2Only) || status.equals((Object)NetInterfaceStatus.netIPv6StatusEnabledLAN) || status.equals((Object)NetInterfaceStatus.netIPv6StatusEnabledWAN) || status.equals((Object)NetInterfaceStatus.netIPv6StatusL2Only)) {
            autoconnect = true;
        }
        return autoconnect;
    }
}

