/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.emulator.position;

import java.util.ArrayList;
import org.eclipse.kura.emulator.position.GpsPoint;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class GpsXmlHandler
extends DefaultHandler {
    private static final String LABEL = "org.eclipse.kura.app.demo.kura.training.console.GpsXmlHandler: ";
    private static final String TAG_TRACK_POINT = "trkpt";
    private static final String TAG_ELEVATION = "ele";
    private static final String TAG_TIME = "time";
    private final ArrayList<GpsPoint> gpsPoints = new ArrayList();
    private String latitude = null;
    private String longitude = null;
    private String elevation = null;
    private String time = null;
    private boolean foundTrackPoint = false;
    private boolean foundElevation = false;
    private boolean foundTime = false;

    @Override
    public void startElement(String uri, String localName, String elementName, Attributes attributes) {
        if (TAG_TRACK_POINT.equals(elementName)) {
            this.foundTrackPoint = true;
            if (attributes.getLength() == 2) {
                int i = 0;
                while (i < attributes.getLength()) {
                    if (attributes.getQName(i).compareTo("lat") == 0) {
                        this.latitude = attributes.getValue(i);
                    } else if (attributes.getQName(i).compareTo("lon") == 0) {
                        this.longitude = attributes.getValue(i);
                    } else {
                        System.out.println("org.eclipse.kura.app.demo.kura.training.console.GpsXmlHandler: invalid attribute in trkpt element: " + attributes.getQName(i));
                    }
                    ++i;
                }
            } else {
                System.out.println("org.eclipse.kura.app.demo.kura.training.console.GpsXmlHandler: there must be two attributes (lat and lon) in the trkpt element");
            }
            this.elevation = null;
            this.time = null;
        } else if (TAG_ELEVATION.equals(elementName)) {
            this.foundElevation = true;
        } else if (TAG_TIME.equals(elementName)) {
            this.foundTime = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String elementName) {
        if (TAG_TRACK_POINT.equals(elementName)) {
            this.foundTrackPoint = false;
            if (this.latitude != null && this.longitude != null && this.elevation != null && this.time != null) {
                this.gpsPoints.add(new GpsPoint(Double.parseDouble(this.latitude), Double.parseDouble(this.longitude), Double.parseDouble(this.elevation), this.time));
            } else {
                System.out.println("org.eclipse.kura.app.demo.kura.training.console.GpsXmlHandler: the XML file is malformed");
            }
        } else if (TAG_ELEVATION.equals(elementName)) {
            this.foundElevation = false;
        } else if (TAG_TIME.equals(elementName)) {
            this.foundTime = false;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int length) {
        String tag = new String(buf).substring(offset, offset + length).trim();
        if (!(this.foundTrackPoint || this.foundElevation || this.foundTime)) {
            return;
        }
        if (this.foundElevation) {
            if (this.elevation == null) {
                this.elevation = new String(buf, offset, length);
                return;
            }
            this.elevation = String.valueOf(this.elevation) + new String(buf, offset, length);
            return;
        }
        if (this.foundTime) {
            if (this.time == null) {
                this.time = new String(buf, offset, length);
                return;
            }
            this.time = String.valueOf(this.time) + new String(buf, offset, length);
            return;
        }
        System.out.println("org.eclipse.kura.app.demo.kura.training.console.GpsXmlHandler: found some odd data in services.xml");
        this.logDump(tag.getBytes());
    }

    public GpsPoint[] getGpsPoints() {
        GpsPoint[] data = new GpsPoint[this.gpsPoints.size()];
        int i = 0;
        while (i < this.gpsPoints.size()) {
            data[i] = this.gpsPoints.get(i);
            ++i;
        }
        return data;
    }

    private void logDump(byte[] message) {
        int i = 0;
        while (i < message.length) {
            if (i % 16 == 0) {
                if (i > 0) {
                    System.out.println();
                }
                System.out.print('\t');
            }
            if (message[i] < 16) {
                System.out.print("0x0" + Integer.toHexString(message[i] & 0xFF) + " ");
            } else {
                System.out.print("0x" + Integer.toHexString(message[i] & 0xFF) + " ");
            }
            ++i;
        }
    }
}

