/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import com.google.common.base.Throwables;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class LanguageServerPlugin
extends AbstractUIPlugin {
    private static final ConcurrentMap<HashCode, Integer> EXCEPTIONS_COUNTER = new ConcurrentHashMap<HashCode, Integer>();
    public static final Object FAMILY_UPDATE_MARKERS = new Object();
    public static final Object FAMILY_INITIALIZE_LANGUAGE_SERVER = new Object();
    public static final String PLUGIN_ID = "org.eclipse.lsp4e";
    private static final String TRACE_ID = "org.eclipse.lsp4e/trace";
    public static final boolean DEBUG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.lsp4e/debug"));
    private static volatile @Nullable LanguageServerPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        LanguageServiceAccessor.shutdownAllDispatchers();
        super.stop(context);
    }

    public static LanguageServerPlugin getDefault() {
        Assert.isNotNull((Object)((Object)plugin));
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        LSPImages.initalize(registry);
    }

    public static void logError(Throwable thr) {
        LanguageServerPlugin.logError(thr.getMessage(), thr);
    }

    public static void logError(@Nullable String message, @Nullable Throwable thr) {
        LanguageServerPlugin plugin = LanguageServerPlugin.plugin;
        if (plugin != null) {
            if (!DEBUG && thr instanceof BadLocationException) {
                HashCode key = Hashing.sha256().hashString((CharSequence)Throwables.getStackTraceAsString((Throwable)thr), StandardCharsets.UTF_8);
                if (EXCEPTIONS_COUNTER.getOrDefault(key, 0) > 2) {
                    return;
                }
                EXCEPTIONS_COUNTER.compute(key, (k, v) -> {
                    int n;
                    if (v == null) {
                        n = 1;
                    } else {
                        v = v + 1;
                        n = v;
                    }
                    return n;
                });
            }
            plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, message, thr));
        }
    }

    public static void logInfo(String message) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, message, null));
        }
    }

    public static void logWarning(@Nullable String message) {
        LanguageServerPlugin.logWarning(message, null);
    }

    public static void logWarning(@Nullable String message, @Nullable Throwable thr) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(2, PLUGIN_ID, 0, message, thr));
        }
    }

    public static boolean isLogTraceEnabled() {
        return Boolean.parseBoolean(Platform.getDebugOption((String)TRACE_ID));
    }
}

