/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.listeners;

import java.text.MessageFormat;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.BarChart;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.Messages;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.listeners.ToolTipChartMouseMoveListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ISeries;

public class BarChartMouseMoveListener
extends ToolTipChartMouseMoveListener {
    public BarChartMouseMoveListener(BarChart chart, Control parent) {
        super((Chart)chart, parent);
    }

    @Override
    public void mouseMove(MouseEvent e) {
        super.mouseMove(e);
        ISeries[] allSeries = this.chart.getSeriesSet().getSeries();
        if (allSeries.length == 0) {
            return;
        }
        IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
        String[] categorySeries = ((BarChart)this.chart).getCategorySeries();
        int barIndex = (int)xAxis.getDataCoordinate(e.x);
        if (0 <= barIndex && barIndex < categorySeries.length) {
            String textTip = "";
            for (int i = 0; i < allSeries.length; ++i) {
                textTip = textTip.concat((i > 0 ? "\n" : "") + MessageFormat.format(Messages.BarChartBuilder_ToolTipCoords, allSeries[i].getId(), ((BarChart)this.chart).getBarValue(i, barIndex)));
            }
            this.setTextTip(textTip);
        } else {
            this.tipShell.setVisible(false);
        }
        this.chart.redraw();
    }
}

