/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerListener;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;

public class DockerContainerRefreshManager
implements IDockerContainerListener {
    private static DockerContainerRefreshManager instance;
    private final long DEFAULT_REFRESH_TIME = 15L;
    private Map<IDockerConnection, ContainerRefreshThread> refreshThreadMap = new HashMap<IDockerConnection, ContainerRefreshThread>();

    private DockerContainerRefreshManager() {
    }

    public static DockerContainerRefreshManager getInstance() {
        if (instance == null) {
            instance = new DockerContainerRefreshManager();
        }
        return instance;
    }

    public Set<IDockerConnection> getConnections() {
        return Collections.unmodifiableSet(this.refreshThreadMap.keySet());
    }

    @Override
    public synchronized void listChanged(IDockerConnection connection, List<IDockerContainer> dclist) {
        if (!this.refreshThreadMap.containsKey(connection)) {
            long refreshRateInSeconds = Platform.getPreferencesService().getLong("org.eclipse.linuxtools.docker.ui", "containerRefreshTime", 15L, null);
            ContainerRefreshThread rt = new ContainerRefreshThread(this, connection, TimeUnit.SECONDS.toMillis(refreshRateInSeconds));
            rt.start();
            this.refreshThreadMap.put(connection, rt);
        }
    }

    public synchronized void removeContainerRefreshThread(IDockerConnection connection) {
        if (this.refreshThreadMap.containsKey(connection)) {
            ContainerRefreshThread containerRefreshThread = this.refreshThreadMap.get(connection);
            containerRefreshThread.stopMonitoring();
            this.refreshThreadMap.remove(connection);
        }
    }

    public void setRefreshTime(long seconds) {
        if (seconds >= 5L) {
            long refreshRate = TimeUnit.SECONDS.toMillis(seconds);
            for (ContainerRefreshThread t : this.refreshThreadMap.values()) {
                t.setSleepTime(refreshRate);
            }
        }
    }

    public void killAllThreads() {
        for (ContainerRefreshThread rt : this.refreshThreadMap.values()) {
            rt.kill();
            this.refreshThreadMap.remove(rt.getConnection());
        }
    }

    public void reset() {
        this.refreshThreadMap.clear();
    }

    private class ContainerRefreshThread
    extends Thread {
        private IDockerConnection connection;
        private long sleepTime;
        private boolean kill;
        private boolean monitor;

        public ContainerRefreshThread(DockerContainerRefreshManager dockerContainerRefreshManager, IDockerConnection connection, long sleepTime) {
            this.connection = connection;
            this.sleepTime = sleepTime;
            this.monitor = true;
        }

        public void stopMonitoring() {
            this.monitor = false;
        }

        public IDockerConnection getConnection() {
            return this.connection;
        }

        public synchronized long getSleepTime() {
            return this.sleepTime;
        }

        public synchronized void setSleepTime(long newTime) {
            this.sleepTime = newTime;
            this.interrupt();
        }

        public void kill() {
            this.kill = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.monitor) {
                try {
                    Thread.sleep(this.getSleepTime());
                    DockerContainerRefreshManager dockerContainerRefreshManager = instance;
                    synchronized (dockerContainerRefreshManager) {
                        if (this.monitor) {
                            ((DockerConnection)this.connection).getContainers(true);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (!this.kill) continue;
                    break;
                }
            }
            Activator.log(Status.info((String)("Stopped monitor container changes for connection '" + this.connection.getName() + "'")));
        }
    }
}

