/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintForKind;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class PrintNoSpecificPrintDeclsCheck
extends CifCheck {
    private final EnumSet<NoSpecificPrintDecl> disalloweds;

    public PrintNoSpecificPrintDeclsCheck(NoSpecificPrintDecl ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public PrintNoSpecificPrintDeclsCheck(EnumSet<NoSpecificPrintDecl> disalloweds) {
        this.disalloweds = disalloweds;
    }

    protected void preprocessPrint(Print print, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificPrintDecl.TEXT_PRE) && print.getTxtPre() != null) {
            this.addViolation(print, "a pre/source state text", violations);
        }
        if (this.disalloweds.contains((Object)NoSpecificPrintDecl.TEXT_POST) && print.getTxtPost() != null) {
            this.addViolation(print, "a post/target state text", violations);
        }
        if (this.disalloweds.contains((Object)NoSpecificPrintDecl.TEXT_PRE_POST) && print.getTxtPre() != null && print.getTxtPost() != null) {
            this.addViolation(print, "both a pre/source state text and a post/target state text", violations);
        }
        if (this.disalloweds.contains((Object)NoSpecificPrintDecl.FILTER_PRE) && print.getWhenPre() != null) {
            this.addViolation(print, "a pre/source state filter", violations);
        }
        if (this.disalloweds.contains((Object)NoSpecificPrintDecl.FILTER_POST) && print.getWhenPost() != null) {
            this.addViolation(print, "a post/target state filter", violations);
        }
        if (this.disalloweds.contains((Object)NoSpecificPrintDecl.FILTER_PRE_POST) && print.getWhenPre() != null && print.getWhenPost() != null) {
            this.addViolation(print, "both a pre/source state filter and a post/target state filter", violations);
        }
        if (this.disalloweds.contains((Object)NoSpecificPrintDecl.TEXT_PRE_FILTER_POST) && print.getTxtPre() != null && print.getWhenPost() != null) {
            this.addViolation(print, "both a pre/source state text and a post/target state filter", violations);
        }
        if (this.disalloweds.contains((Object)NoSpecificPrintDecl.TEXT_POST_FILTER_PRE) && print.getTxtPost() != null && print.getWhenPre() != null) {
            this.addViolation(print, "both a post/target state text and a pre/source state filter", violations);
        }
        List<PrintForKind> forKinds = print.getFors().stream().map(f -> f.getKind()).toList();
        if (this.disalloweds.contains((Object)NoSpecificPrintDecl.FOR_EVENT) && (forKinds.contains(PrintForKind.EVENT) || forKinds.contains(PrintForKind.NAME))) {
            this.addViolation(print, "an event transition filter", violations);
        }
        if (this.disalloweds.contains((Object)NoSpecificPrintDecl.FOR_TIME) && forKinds.contains(PrintForKind.TIME)) {
            this.addViolation(print, "a time transition filter", violations);
        }
        if (this.disalloweds.contains((Object)NoSpecificPrintDecl.FOR_INITIAL) && forKinds.contains(PrintForKind.INITIAL)) {
            this.addViolation(print, "an initial virtual transition filter", violations);
        }
        if (this.disalloweds.contains((Object)NoSpecificPrintDecl.FOR_FINAL) && forKinds.contains(PrintForKind.FINAL)) {
            this.addViolation(print, "a final transition filter", violations);
        }
    }

    private void addViolation(Print print, String featureName, CifCheckViolations violations) {
        violations.add((PositionObject)print, "Print declaration has %s", featureName);
    }

    public static enum NoSpecificPrintDecl {
        TEXT_PRE,
        TEXT_POST,
        TEXT_PRE_POST,
        FILTER_PRE,
        FILTER_POST,
        FILTER_PRE_POST,
        TEXT_PRE_FILTER_POST,
        TEXT_POST_FILTER_PRE,
        FOR_EVENT,
        FOR_TIME,
        FOR_INITIAL,
        FOR_FINAL;

    }
}

