/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.machine.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import machine.Position;
import machine.impl.AxisPositionsMapEntryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.action.AbstractExternalJavaAction;

public class DeleteAxis
extends AbstractExternalJavaAction {
    public boolean canExecute(Collection<? extends EObject> selections) {
        return selections != null && selections.size() == 1;
    }

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        for (EObject eObject : selections) {
            if (!(eObject instanceof AxisPositionsMapEntryImpl)) continue;
            DeleteAxis.delete((AxisPositionsMapEntryImpl)eObject);
        }
    }

    private static void delete(AxisPositionsMapEntryImpl axisPos) {
        DeleteAxis.deletePosMaps(axisPos);
        ArrayList<Position> toRemove = new ArrayList<Position>();
        for (Position pos : axisPos.getValue()) {
            if (!axisPos.getValue().contains((Object)pos)) continue;
            toRemove.add(pos);
        }
        for (Position pos : toRemove) {
            EcoreUtil.remove((EObject)pos);
        }
        EcoreUtil.remove((EObject)axisPos);
    }

    private static void deletePosMaps(AxisPositionsMapEntryImpl axisPos) {
        for (Position pos : axisPos.getValue()) {
            Collection posMaps = EcoreUtil.UsageCrossReferencer.find((EObject)pos, (ResourceSet)pos.eResource().getResourceSet());
            for (EStructuralFeature.Setting posMap : posMaps) {
                if (!"value".equals(posMap.getEStructuralFeature().getName()) && !"key".equals(posMap.getEStructuralFeature().getName())) continue;
                EcoreUtil.remove((EObject)posMap.getEObject());
            }
        }
    }
}

