/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.algorithms;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.graph.SingleWeightedGraph;

public final class Dijkstra {
    private Dijkstra() {
    }

    private static <V, E, T> Predicate<V> predHasNoSuccessors(SingleWeightedGraph<V, E, T> graph) {
        return v -> graph.outgoingEdgesOf(v).isEmpty();
    }

    private static <V> Predicate<V> predInCollection(Collection<V> collection) {
        return collection::contains;
    }

    private static <V> Predicate<V> predEqualTo(V target) {
        return v -> v.equals(target);
    }

    public static <V, E> Tuple<Value, List<E>> runDijkstra(SingleWeightedGraph<V, E, Value> graph, V source) {
        return Dijkstra.runDijkstra(graph, source, Dijkstra.predHasNoSuccessors(graph));
    }

    public static <V, E> Tuple<Value, List<E>> runDijkstra(SingleWeightedGraph<V, E, Value> graph, V source, Collection<V> targetSet) {
        return Dijkstra.runDijkstra(graph, source, Dijkstra.predInCollection(targetSet));
    }

    public static <V, E> Tuple<Value, List<E>> runDijkstra(SingleWeightedGraph<V, E, Value> graph, V source, V target) {
        return Dijkstra.runDijkstra(graph, source, Dijkstra.predEqualTo(target));
    }

    public static <V, E> Tuple<Value, List<E>> runDijkstra(SingleWeightedGraph<V, E, Value> graph, V source, Predicate<V> terminationPredicate) {
        HashMap dist = new HashMap(graph.getVertices().size());
        HashMap prev = new HashMap(graph.getVertices().size());
        Comparator comparator = (v1, v2) -> v1.cost.subtract(v2.cost).signum();
        PriorityQueue<CostVertex> q = new PriorityQueue<CostVertex>(graph.getEdges().size(), comparator);
        HashMap vtoCVMap = new HashMap();
        dist.put(source, new Value(0.0));
        for (Object v : graph.getVertices()) {
            if (!v.equals(source)) {
                dist.put(v, Value.POSITIVE_INFINITY);
                prev.put(v, null);
            }
            CostVertex cv = new CostVertex(v, (Value)dist.get(v));
            q.add(cv);
            vtoCVMap.put(v, cv);
        }
        Object target = null;
        while (!q.isEmpty()) {
            CostVertex u = (CostVertex)q.remove();
            vtoCVMap.remove(u.vertex);
            if (terminationPredicate.test(u.vertex)) {
                target = u.vertex;
                break;
            }
            for (Object e : graph.outgoingEdgesOf(u.vertex)) {
                Value alt;
                Object neighbor = graph.getEdgeTarget(e);
                if (!vtoCVMap.containsKey(neighbor) || !(alt = ((Value)dist.get(u.vertex)).add(graph.getWeight(e))).smallerThan((Value)dist.get(neighbor))) continue;
                dist.put(neighbor, alt);
                prev.put(neighbor, u.vertex);
                CostVertex cvNeighbor = (CostVertex)vtoCVMap.get(neighbor);
                q.remove(cvNeighbor);
                CostVertex costNeighbor = (CostVertex)vtoCVMap.get(neighbor);
                costNeighbor.cost = alt;
                q.add(costNeighbor);
            }
        }
        LinkedList path = new LinkedList();
        Object u = target;
        while (prev.containsKey(u)) {
            path.add(0, graph.getEdge(prev.get(u), u));
            u = prev.get(u);
        }
        return Tuple.of((Value)dist.get(target), path);
    }

    private static class CostVertex<V> {
        public final V vertex;
        public Value cost;

        public CostVertex(V v, Value cost) {
            this.vertex = v;
            this.cost = cost;
        }
    }
}

