/**
 */
package org.eclipse.lsat.common.graph.directed.impl;

import org.eclipse.lsat.common.graph.directed.Aspect;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.DirectedGraphPackage;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.graph.directed.Node;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Edge</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.lsat.common.graph.directed.impl.EdgeImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.graph.directed.impl.EdgeImpl#getSourceNode <em>Source Node</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.graph.directed.impl.EdgeImpl#getTargetNode <em>Target Node</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.graph.directed.impl.EdgeImpl#getGraph <em>Graph</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.graph.directed.impl.EdgeImpl#getAspects <em>Aspects</em>}</li>
 * </ul>
 *
 * @generated
 */
public class EdgeImpl extends MinimalEObjectImpl.Container implements Edge {
	/**
     * The default value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
	protected static final String NAME_EDEFAULT = null;

	/**
     * The cached value of the '{@link #getSourceNode() <em>Source Node</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSourceNode()
     * @generated
     * @ordered
     */
	protected Node sourceNode;

	/**
     * The cached value of the '{@link #getTargetNode() <em>Target Node</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getTargetNode()
     * @generated
     * @ordered
     */
	protected Node targetNode;

	/**
     * The cached value of the '{@link #getAspects() <em>Aspects</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getAspects()
     * @generated
     * @ordered
     */
	protected EList<Aspect<?, ?>> aspects;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EdgeImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return DirectedGraphPackage.Literals.EDGE;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String getName() {
        StringBuffer name = new StringBuffer();
        if (null == sourceNode) {
            name.append("null");
        } else if (null == sourceNode.getName()) {
            name.append("<<no_name>>");
        } else {
            name.append(sourceNode.getName());
        }
        name.append(" -> ");
        if (null == targetNode) {
            name.append("null");
        } else if (null == targetNode.getName()) {
            name.append("<<no_name>>");
        } else {
            name.append(targetNode.getName());
        }
        return name.toString();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Node getSourceNode() {
        if (sourceNode != null && sourceNode.eIsProxy())
        {
            InternalEObject oldSourceNode = (InternalEObject)sourceNode;
            sourceNode = (Node)eResolveProxy(oldSourceNode);
            if (sourceNode != oldSourceNode)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, DirectedGraphPackage.EDGE__SOURCE_NODE, oldSourceNode, sourceNode));
            }
        }
        return sourceNode;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Node basicGetSourceNode() {
        return sourceNode;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetSourceNode(Node newSourceNode, NotificationChain msgs) {
        Node oldSourceNode = sourceNode;
        sourceNode = newSourceNode;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DirectedGraphPackage.EDGE__SOURCE_NODE, oldSourceNode, newSourceNode);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setSourceNode(Node newSourceNode) {
        if (newSourceNode != sourceNode)
        {
            NotificationChain msgs = null;
            if (sourceNode != null)
                msgs = ((InternalEObject)sourceNode).eInverseRemove(this, DirectedGraphPackage.NODE__OUTGOING_EDGES, Node.class, msgs);
            if (newSourceNode != null)
                msgs = ((InternalEObject)newSourceNode).eInverseAdd(this, DirectedGraphPackage.NODE__OUTGOING_EDGES, Node.class, msgs);
            msgs = basicSetSourceNode(newSourceNode, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DirectedGraphPackage.EDGE__SOURCE_NODE, newSourceNode, newSourceNode));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Node getTargetNode() {
        if (targetNode != null && targetNode.eIsProxy())
        {
            InternalEObject oldTargetNode = (InternalEObject)targetNode;
            targetNode = (Node)eResolveProxy(oldTargetNode);
            if (targetNode != oldTargetNode)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, DirectedGraphPackage.EDGE__TARGET_NODE, oldTargetNode, targetNode));
            }
        }
        return targetNode;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Node basicGetTargetNode() {
        return targetNode;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetTargetNode(Node newTargetNode, NotificationChain msgs) {
        Node oldTargetNode = targetNode;
        targetNode = newTargetNode;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DirectedGraphPackage.EDGE__TARGET_NODE, oldTargetNode, newTargetNode);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setTargetNode(Node newTargetNode) {
        if (newTargetNode != targetNode)
        {
            NotificationChain msgs = null;
            if (targetNode != null)
                msgs = ((InternalEObject)targetNode).eInverseRemove(this, DirectedGraphPackage.NODE__INCOMING_EDGES, Node.class, msgs);
            if (newTargetNode != null)
                msgs = ((InternalEObject)newTargetNode).eInverseAdd(this, DirectedGraphPackage.NODE__INCOMING_EDGES, Node.class, msgs);
            msgs = basicSetTargetNode(newTargetNode, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DirectedGraphPackage.EDGE__TARGET_NODE, newTargetNode, newTargetNode));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public DirectedGraph<?, ?> getGraph() {
        if (eContainerFeatureID() != DirectedGraphPackage.EDGE__GRAPH) return null;
        return (DirectedGraph<?, ?>)eInternalContainer();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetGraph(DirectedGraph<?, ?> newGraph, NotificationChain msgs) {
        msgs = eBasicSetContainer((InternalEObject)newGraph, DirectedGraphPackage.EDGE__GRAPH, msgs);
        return msgs;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setGraph(DirectedGraph<?, ?> newGraph) {
        if (newGraph != eInternalContainer() || (eContainerFeatureID() != DirectedGraphPackage.EDGE__GRAPH && newGraph != null))
        {
            if (EcoreUtil.isAncestor(this, newGraph))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eInternalContainer() != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newGraph != null)
                msgs = ((InternalEObject)newGraph).eInverseAdd(this, DirectedGraphPackage.DIRECTED_GRAPH__EDGES, DirectedGraph.class, msgs);
            msgs = basicSetGraph(newGraph, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DirectedGraphPackage.EDGE__GRAPH, newGraph, newGraph));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public EList<Aspect<?, ?>> getAspects() {
        if (aspects == null)
        {
            aspects = new EObjectWithInverseResolvingEList.ManyInverse<Aspect<?, ?>>(Aspect.class, this, DirectedGraphPackage.EDGE__ASPECTS, DirectedGraphPackage.ASPECT__EDGES);
        }
        return aspects;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID)
        {
            case DirectedGraphPackage.EDGE__SOURCE_NODE:
                if (sourceNode != null)
                    msgs = ((InternalEObject)sourceNode).eInverseRemove(this, DirectedGraphPackage.NODE__OUTGOING_EDGES, Node.class, msgs);
                return basicSetSourceNode((Node)otherEnd, msgs);
            case DirectedGraphPackage.EDGE__TARGET_NODE:
                if (targetNode != null)
                    msgs = ((InternalEObject)targetNode).eInverseRemove(this, DirectedGraphPackage.NODE__INCOMING_EDGES, Node.class, msgs);
                return basicSetTargetNode((Node)otherEnd, msgs);
            case DirectedGraphPackage.EDGE__GRAPH:
                if (eInternalContainer() != null)
                    msgs = eBasicRemoveFromContainer(msgs);
                return basicSetGraph((DirectedGraph<?, ?>)otherEnd, msgs);
            case DirectedGraphPackage.EDGE__ASPECTS:
                return ((InternalEList<InternalEObject>)(InternalEList<?>)getAspects()).basicAdd(otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID)
        {
            case DirectedGraphPackage.EDGE__SOURCE_NODE:
                return basicSetSourceNode(null, msgs);
            case DirectedGraphPackage.EDGE__TARGET_NODE:
                return basicSetTargetNode(null, msgs);
            case DirectedGraphPackage.EDGE__GRAPH:
                return basicSetGraph(null, msgs);
            case DirectedGraphPackage.EDGE__ASPECTS:
                return ((InternalEList<?>)getAspects()).basicRemove(otherEnd, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (eContainerFeatureID())
        {
            case DirectedGraphPackage.EDGE__GRAPH:
                return eInternalContainer().eInverseRemove(this, DirectedGraphPackage.DIRECTED_GRAPH__EDGES, DirectedGraph.class, msgs);
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID)
        {
            case DirectedGraphPackage.EDGE__NAME:
                return getName();
            case DirectedGraphPackage.EDGE__SOURCE_NODE:
                if (resolve) return getSourceNode();
                return basicGetSourceNode();
            case DirectedGraphPackage.EDGE__TARGET_NODE:
                if (resolve) return getTargetNode();
                return basicGetTargetNode();
            case DirectedGraphPackage.EDGE__GRAPH:
                return getGraph();
            case DirectedGraphPackage.EDGE__ASPECTS:
                return getAspects();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID)
        {
            case DirectedGraphPackage.EDGE__SOURCE_NODE:
                setSourceNode((Node)newValue);
                return;
            case DirectedGraphPackage.EDGE__TARGET_NODE:
                setTargetNode((Node)newValue);
                return;
            case DirectedGraphPackage.EDGE__GRAPH:
                setGraph((DirectedGraph<?, ?>)newValue);
                return;
            case DirectedGraphPackage.EDGE__ASPECTS:
                getAspects().clear();
                getAspects().addAll((Collection<? extends Aspect<?, ?>>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID)
        {
            case DirectedGraphPackage.EDGE__SOURCE_NODE:
                setSourceNode((Node)null);
                return;
            case DirectedGraphPackage.EDGE__TARGET_NODE:
                setTargetNode((Node)null);
                return;
            case DirectedGraphPackage.EDGE__GRAPH:
                setGraph((DirectedGraph<?, ?>)null);
                return;
            case DirectedGraphPackage.EDGE__ASPECTS:
                getAspects().clear();
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID)
        {
            case DirectedGraphPackage.EDGE__NAME:
                return NAME_EDEFAULT == null ? getName() != null : !NAME_EDEFAULT.equals(getName());
            case DirectedGraphPackage.EDGE__SOURCE_NODE:
                return sourceNode != null;
            case DirectedGraphPackage.EDGE__TARGET_NODE:
                return targetNode != null;
            case DirectedGraphPackage.EDGE__GRAPH:
                return getGraph() != null;
            case DirectedGraphPackage.EDGE__ASPECTS:
                return aspects != null && !aspects.isEmpty();
        }
        return super.eIsSet(featureID);
    }

} //EdgeImpl
