/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.setting.teditor.ui.hover

import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider
import expressions.Expression
import expressions.Declaration
import timing.Scalar
import timing.Array
import distributions.TriangularDistribution
import distributions.PertDistribution
import distributions.NormalDistribution
import distributions.EnumeratedDistribution
import setting.PhysicalLocation
import setting.impl.LocationSettingsMapEntryImpl
import setting.impl.MotionArgumentsMapEntryImpl
import setting.impl.MotionSettingsMapEntryImpl

/**
 * Provides labels for a EObjects.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#labelProvider
 */
class SettingHoverProvider extends DefaultEObjectHoverProvider {

    override String getFirstLine(EObject o) {
        val parent = o.eContainer
        val def = switch(parent){
            LocationSettingsMapEntryImpl: parent.key.name
            MotionSettingsMapEntryImpl: parent.key.name
            MotionArgumentsMapEntryImpl: parent.key
            default: super.getFirstLine(o)
        }
        val value = toString(o)
        if (value !== null) {
            return def + " = " + value;
        }
        return def;
    }

    override hasHover(EObject o) {
        toString(o) !== null || super.hasHover(o);
    }

    private def String toString(EObject o) {
        switch (o) {
        	Declaration: o.expression?.toString
        	PhysicalLocation: o.^default?.toString
        	Scalar: o.valueExp.toString
        	Array: o.valuesExp.map[toString].join('[' + ',' + ']')
        	TriangularDistribution: o.^default?.toString
        	PertDistribution: '''{min=«o.min», max=«o.max», mode=«o.mode», gamma=«o.gamma», default=«o.^default»}''' 
        	NormalDistribution: '''{mean=«o.mean», sd=«o.sd», default=«o.^default»}''' 
        	EnumeratedDistribution: o.valuesExp.map[toString].join('[' + ',' + ']')
        	Expression: o.evaluate?.toString
        	EObject: null
        }
    }
    
    
}
