/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.jaxrs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.messages.Tuple;
import org.eclipse.lsp4jakarta.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4jakarta.commons.codeaction.JakartaCodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.RemoveParamsProposal;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.jaxrs.Constants;

public class RemoveMethodEntityParamsWithExclusionQuickFix
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(RemoveMethodEntityParamsWithExclusionQuickFix.class.getName());
    public static final String ENTITY_PARAM_NAME_TO_KEEP_ID_KEY = "entity.param.to.keep.identifier";

    @Override
    public String getParticipantId() {
        return RemoveMethodEntityParamsWithExclusionQuickFix.class.getName();
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<ExtendedCodeAction> codeActions = new ArrayList<ExtendedCodeAction>();
        ASTNode node = context.getCoveredNode();
        MethodDeclaration parentNode = (MethodDeclaration)node.getParent();
        IMethodBinding parentMethod = parentNode.resolveBinding();
        if (parentMethod != null) {
            Tuple.Two<List<SingleVariableDeclaration>, SingleVariableDeclaration> entityParams = this.getEntityParams(context, null);
            for (SingleVariableDeclaration entityParam : (List)entityParams.getFirst()) {
                ExtendedCodeAction codeAction = this.createCodeAction(context, diagnostic, entityParam);
                codeActions.add(codeAction);
            }
        }
        return codeActions;
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        ASTNode node = context.getCoveredNode();
        MethodDeclaration parentNode = (MethodDeclaration)node.getParent();
        IMethodBinding parentMethod = parentNode.resolveBinding();
        CodeActionResolveData data = (CodeActionResolveData)toResolve.getData();
        String entityParamToKeepId = (String)data.getExtendedDataEntry(ENTITY_PARAM_NAME_TO_KEEP_ID_KEY);
        Tuple.Two<List<SingleVariableDeclaration>, SingleVariableDeclaration> dataTuple = this.getEntityParams(context, entityParamToKeepId);
        List entityParams = (List)dataTuple.getFirst();
        SingleVariableDeclaration entityParamToKeep = (SingleVariableDeclaration)dataTuple.getSecond();
        String label = this.getLabel(entityParamToKeepId);
        RemoveParamsProposal proposal = new RemoveParamsProposal(label, context.getCompilationUnit(), context.getASTRoot(), (IBinding)parentMethod, 0, entityParams, entityParamToKeep);
        try {
            toResolve.setEdit(context.convertToWorkspaceEdit(proposal));
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Unable to resolve code action edit to remove entity parameters", e);
        }
        return toResolve;
    }

    private ExtendedCodeAction createCodeAction(JavaCodeActionContext context, Diagnostic diagnostic, SingleVariableDeclaration enityParamToKeep) {
        String paramId = this.getIdentifier(enityParamToKeep);
        String label = this.getLabel(paramId);
        JakartaCodeActionId id = JakartaCodeActionId.RemoveAllEntityParametersExcept;
        ExtendedCodeAction codeAction = new ExtendedCodeAction(label);
        codeAction.setRelevance(0);
        codeAction.setKind("quickfix");
        HashMap<String, Object> extendedData = new HashMap<String, Object>();
        extendedData.put(ENTITY_PARAM_NAME_TO_KEEP_ID_KEY, paramId);
        codeAction.setDiagnostics(Arrays.asList(diagnostic));
        codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), extendedData, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported(), id));
        return codeAction;
    }

    private Tuple.Two<List<SingleVariableDeclaration>, SingleVariableDeclaration> getEntityParams(JavaCodeActionContext context, String searchParmId) {
        ASTNode node = context.getCoveredNode();
        MethodDeclaration parentNode = (MethodDeclaration)node.getParent();
        ArrayList<SingleVariableDeclaration> entityParams = new ArrayList<SingleVariableDeclaration>();
        List params = parentNode.parameters();
        SingleVariableDeclaration foundId = null;
        for (SingleVariableDeclaration param : params) {
            if (!this.isEntityParam(param)) continue;
            if (foundId == null && searchParmId != null && this.getIdentifier(param).equals(searchParmId)) {
                foundId = param;
            }
            entityParams.add(param);
        }
        return Tuple.two(entityParams, foundId);
    }

    private boolean isEntityParam(SingleVariableDeclaration param) {
        ArrayList<String> nonEntityParamAnnotations = new ArrayList<String>(Arrays.asList(Constants.SET_OF_NON_ENTITY_PARAM_ANNOTATIONS));
        boolean isEntityParam = true;
        List modifiers = param.modifiers();
        for (Object o : modifiers) {
            Annotation annotation;
            ITypeBinding binding;
            IExtendedModifier modifier = (IExtendedModifier)o;
            if (!modifier.isAnnotation() || !nonEntityParamAnnotations.contains((binding = (annotation = (Annotation)modifier).resolveTypeBinding()).getQualifiedName())) continue;
            isEntityParam = false;
            break;
        }
        return isEntityParam;
    }

    private String getLabel(String identifier) {
        return Messages.getMessage("RemoveAllEntityParametersExcept", identifier);
    }

    private String getIdentifier(SingleVariableDeclaration entityParam) {
        return entityParam.getName().getIdentifier();
    }
}

