/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.config.java;

import java.io.InputStream;
import java.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.lsp4mp.commons.MicroProfileInlayHintTypeSettings;
import org.eclipse.lsp4mp.commons.MicroProfileJavaInlayHintParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaInlayHintSettings;
import org.eclipse.lsp4mp.commons.runtime.ExecutionMode;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class MicroProfileConfigJavaInlayHintsTest
extends BasePropertiesManagerTest {
    @BeforeClass
    public static void setupTests() throws Exception {
        BasePropertiesManagerTest.loadJavaProjects(new String[]{"maven/" + BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart});
    }

    @Test
    @Ignore(value="Fix flacky Java inlay hint test")
    public void defaultValuesAndConverters() throws Exception {
        IJavaProject javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart);
        IJDTUtils utils = JDT_UTILS;
        IFile propertiesSourceFile = javaProject.getProject().getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config.properties"));
        MicroProfileConfigJavaInlayHintsTest.saveFile("META-INF/microprofile-config.properties", MicroProfileConfigJavaInlayHintsTest.convertStreamToString(propertiesSourceFile.getContents()), javaProject);
        MicroProfileJavaInlayHintParams inlayHintsParams = new MicroProfileJavaInlayHintParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        inlayHintsParams.setUri(javaFile.getLocation().toFile().toURI().toString());
        inlayHintsParams.setSettings(MicroProfileConfigJavaInlayHintsTest.createInlayHintSettings(true, true));
        MicroProfileForJavaAssert.assertInlayHints(inlayHintsParams, utils, MicroProfileForJavaAssert.ih(MicroProfileForJavaAssert.p(17, 11), "BuiltInConverter "), MicroProfileForJavaAssert.ih(MicroProfileForJavaAssert.p(20, 11), "BuiltInConverter "), MicroProfileForJavaAssert.ih(MicroProfileForJavaAssert.p(23, 21), "BuiltInConverter "), MicroProfileForJavaAssert.ih(MicroProfileForJavaAssert.p(25, 50), ", defaultValue=\"PT15M\""), MicroProfileForJavaAssert.ih(MicroProfileForJavaAssert.p(26, 13), "StaticMethodConverter "));
        inlayHintsParams.setSettings(MicroProfileConfigJavaInlayHintsTest.createInlayHintSettings(true, false));
        MicroProfileForJavaAssert.assertInlayHints(inlayHintsParams, utils, MicroProfileForJavaAssert.ih(MicroProfileForJavaAssert.p(17, 11), "BuiltInConverter "), MicroProfileForJavaAssert.ih(MicroProfileForJavaAssert.p(20, 11), "BuiltInConverter "), MicroProfileForJavaAssert.ih(MicroProfileForJavaAssert.p(23, 21), "BuiltInConverter "), MicroProfileForJavaAssert.ih(MicroProfileForJavaAssert.p(26, 13), "StaticMethodConverter "));
        inlayHintsParams.setSettings(MicroProfileConfigJavaInlayHintsTest.createInlayHintSettings(false, true));
        MicroProfileForJavaAssert.assertInlayHints(inlayHintsParams, utils, MicroProfileForJavaAssert.ih(MicroProfileForJavaAssert.p(25, 50), ", defaultValue=\"PT15M\""));
    }

    private static MicroProfileJavaInlayHintSettings createInlayHintSettings(boolean showConverters, boolean showDefaultValues) {
        MicroProfileJavaInlayHintSettings inlayHintSettings = new MicroProfileJavaInlayHintSettings(ExecutionMode.SAFE);
        MicroProfileInlayHintTypeSettings converterSettings = new MicroProfileInlayHintTypeSettings();
        converterSettings.setEnabled(showConverters);
        inlayHintSettings.setConverters(converterSettings);
        MicroProfileInlayHintTypeSettings defaultValuesSettings = new MicroProfileInlayHintTypeSettings();
        defaultValuesSettings.setEnabled(showDefaultValues);
        inlayHintSettings.setDefaultValues(defaultValuesSettings);
        return inlayHintSettings;
    }

    private static String convertStreamToString(InputStream is) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner s = new Scanner(is);){
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

