/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.i18n;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class CoreMessages {
    private static final String BUNDLE_NAME = "org.eclipse.birt.core.i18n.Messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.eclipse.birt.core.i18n.Messages");
    private static Map<Locale, ResourceBundle> localeToBundle = new HashMap<Locale, ResourceBundle>();

    private CoreMessages() {
    }

    public static ResourceBundle getReportResourceBundle() {
        return RESOURCE_BUNDLE;
    }

    public static ResourceBundle getReportResourceBundle(Locale locale) {
        ResourceBundle bundle = CoreMessages.getReportResourceBundle();
        if (locale != null && (bundle = localeToBundle.get(locale)) == null) {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
            localeToBundle.put(locale, bundle);
        }
        return bundle == null ? RESOURCE_BUNDLE : bundle;
    }

    public static String getString(String key) {
        return CoreMessages.getString(key, Locale.getDefault());
    }

    public static String getString(String key, Locale locale) {
        try {
            String result = CoreMessages.getReportResourceBundle(locale).getString(key);
            return result;
        }
        catch (Exception exception) {
            assert (false);
            return key;
        }
    }

    public static String getFormattedString(String key, Object ... arguments) {
        return CoreMessages.getFormattedString(key, arguments, Locale.getDefault());
    }

    public static String getFormattedString(String key, Object[] arguments, Locale locale) {
        return MessageFormat.format(CoreMessages.getString(key, locale), arguments);
    }
}

