/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.Collections;
import java.util.List;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="comparison_report")
@Icon(value="/META-INF/icons/compare.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/comparingdata.html")
public class ComparisonReport
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(advice=Argument.Advice.SECONDARY_SNAPSHOT)
    public ISnapshot baseline;
    @Argument(flag="none")
    public String report = "org.eclipse.mat.api:suspects2";

    public IResult execute(IProgressListener listener) throws Exception {
        SnapshotQuery queryc = SnapshotQuery.parse("default_report " + this.report, this.snapshot);
        List<String> params = Collections.singletonList("baseline=" + this.baseline.getSnapshotInfo().getPath());
        queryc.setArgument("params", params);
        IResult ret = queryc.execute(listener);
        return ret;
    }
}

