/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.report.ITestResult;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.internal.AbstractPart;
import org.eclipse.mat.report.internal.DataFile;
import org.eclipse.mat.report.internal.PartsFactory;
import org.eclipse.mat.report.internal.ResultRenderer;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.SimpleMonitor;

public class SectionPart
extends AbstractPart {
    String command;

    SectionPart(String id, AbstractPart parent, DataFile artefact, SectionSpec spec, String command) {
        super(id, parent, artefact, spec);
        this.status = spec.getStatus();
        if (spec.getName() == null) {
            spec.setName("");
            this.params().put("html.show_heading", Boolean.FALSE.toString());
        }
        this.command = command;
    }

    @Override
    void init(PartsFactory factory) {
        for (Spec child : ((SectionSpec)this.spec).getChildren()) {
            this.children.add(factory.create(this, child));
        }
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public AbstractPart execute(IQueryContext context, ResultRenderer renderer, IProgressListener listener) throws SnapshotException, IOException {
        renderer.beginSection(this);
        int[] perc = new int[this.children.size()];
        Arrays.fill(perc, 100);
        SimpleMonitor sm = new SimpleMonitor(this.spec.getName(), listener, perc);
        int ii = 0;
        while (ii < this.children.size()) {
            IProgressListener mon = sm.nextMonitor();
            AbstractPart part = ((AbstractPart)this.children.get(ii)).execute(context, renderer, mon);
            this.status = ITestResult.Status.max(this.status, part.status);
            this.children.set(ii, part);
            mon.done();
            ++ii;
        }
        renderer.endSection(this);
        return this;
    }
}

