/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.ACTInterpreterException;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMInterpreter;
import org.eclipse.m2m.atl.engine.vm.ASMXMLReader;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.NetworkDebugger;
import org.eclipse.m2m.atl.engine.vm.PluginClassLoader;
import org.eclipse.m2m.atl.engine.vm.SimpleDebugger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ACTInterpreter {
    public ACTInterpreter(PluginClassLoader pcl, ModelLoader ml, ASMModelElement root, Map params, Map models) throws Exception {
        ACT act = new ACT();
        this.load(root, act);
        ATLLogger.info((String)("Executing ATL Composite Transformation: " + act.name));
        HashMap parameters = new HashMap();
        parameters.put("ACT_LOCATION", params.get("ACT_LOCATION"));
        for (Plugin plugin : act.plugins) {
            pcl.addLocation(ACTInterpreter.expand(plugin.href, parameters));
        }
        try {
            ml.addInjector("ebnf", pcl.loadClass("org.eclipse.gmt.tcs.injector.TCSInjector"));
            ml.addInjector("ebnf2", pcl.loadClass("org.eclipse.gmt.tcs.injector.TCSInjector"));
        }
        catch (Exception e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        for (File_ file : act.file_s) {
            String filehref = (String)params.get(file.name);
            if (filehref == null) {
                throw new ACTInterpreterException("ERROR: Location of file " + file.name + " not specified on command line.");
            }
            if (file instanceof InFile && !new File(filehref).exists()) {
                throw new ACTInterpreterException("ERROR: Location of input file " + file.name + ": \"" + filehref + "\" does not denote a valid file.");
            }
            parameters.put(file.name, filehref);
        }
        for (Model model : act.models) {
            if (!(model instanceof InModel)) continue;
            ATLLogger.info((String)("Loading model " + model.name + "..."));
            ASMModel m = (ASMModel)models.get(model.name);
            if (m != null) continue;
            String mhref = (String)params.get(model.name);
            if (mhref == null) {
                throw new ACTInterpreterException("ERROR: Location of input model " + model.name + " not specified on command line.");
            }
            ASMModel mm = (ASMModel)models.get(model.metaModel);
            if (mm == null) {
                throw new ACTInterpreterException("ERROR: Metamodel " + model.metaModel + " is not already loaded.");
            }
            m = ml.loadModel(model.name, mm, mhref);
            models.put(model.name, m);
        }
        for (Operation op : act.operations) {
            HashMap<String, String> asmParams;
            ASM lib;
            ASMModel mm;
            ASMModel m;
            ASMExecEnv env;
            Debugger debugger;
            ASMModule asmModule;
            ASM asm;
            if (op instanceof Import) {
                System.out.println("Importing...");
                Import im = (Import)op;
                ASMModel mm2 = (ASMModel)models.get(im.metaModel);
                if (mm2 == null) {
                    throw new ACTInterpreterException("ERROR: Metamodel " + im.metaModel + " is not already loaded.");
                }
                String href = ACTInterpreter.expand(im.href, parameters);
                ASMModel m2 = ml.loadModel(im.storeTo, mm2, String.valueOf(im.kind) + ":" + im.subKind + ":" + href);
                models.put(im.storeTo, m2);
                continue;
            }
            if (op instanceof Query) {
                ATLLogger.info((String)"Querying...");
                Query q = (Query)op;
                asm = new ASMXMLReader().read(new BufferedInputStream(new FileInputStream(ACTInterpreter.expand(q.asm, parameters))));
                asmModule = new ASMModule(asm);
                debugger = null;
                if ("network".equals(q.debug)) {
                    debugger = new NetworkDebugger(6060, true);
                } else {
                    boolean step = false;
                    if ("step".equals(q.debug)) {
                        step = true;
                    }
                    debugger = new SimpleDebugger(step, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), true);
                }
                env = new ASMExecEnv(asmModule, debugger);
                env.addModel((ASMModel)models.get("MOF"));
                env.addModel((ASMModel)models.get("ATL"));
                for (Object l : q.models) {
                    if (l instanceof InoutModel || l instanceof InModel) {
                        m = (ASMModel)models.get(((Model)l).model);
                        if (m == null) {
                            throw new ACTInterpreterException("ERROR: model " + ((Model)l).model + " not loaded yet.");
                        }
                        env.addModel(((Model)l).name, m);
                        continue;
                    }
                    if (l instanceof OutModel) {
                        m = (ASMModel)models.get(((Model)l).model);
                        if (m == null) {
                            mm = (ASMModel)models.get(((Model)l).metaModel);
                            if (mm == null) {
                                throw new ACTInterpreterException("ERROR: model " + ((Model)l).metaModel + " not loaded yet.");
                            }
                            m = ml.newModel(((Model)l).model, (String)params.get(((Model)l).name), mm);
                        }
                        env.addModel(((Model)l).name, m);
                        models.put(((Model)l).model, m);
                        continue;
                    }
                    ATLLogger.warning((String)(l + " not dealt with yet."));
                }
                env.registerOperations(asm);
                for (Object l : q.librarys) {
                    ATLLogger.info((String)("Loading library " + ((Library)l).name + " from " + ((Library)l).href + "."));
                    lib = new ASMXMLReader().read(new BufferedInputStream(new FileInputStream(ACTInterpreter.expand(((Library)l).href, parameters))));
                    env.registerOperations(lib);
                }
                asmParams = new HashMap<String, String>();
                for (WithParam l : q.withParams) {
                    asmParams.put(l.name, ACTInterpreter.expand(l.value, params));
                }
                ASMInterpreter ai = new ASMInterpreter(asm, asmModule, env, asmParams);
                Object value = ai.getReturnValue();
                if (q.writeTo != null) {
                    String fileName = ACTInterpreter.expand(q.writeTo, parameters);
                    if (value instanceof ASMString) {
                        value = ((ASMString)value).getSymbol();
                    }
                    PrintStream out = null;
                    out = q.charset == null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(fileName)), true) : new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(fileName)), true, q.charset);
                    out.print(value.toString());
                    out.close();
                    continue;
                }
                System.out.println(value.toString());
                continue;
            }
            if (!(op instanceof Transform)) continue;
            ATLLogger.info((String)"Transforming...");
            Transform tr = (Transform)op;
            asm = new ASMXMLReader().read(new BufferedInputStream(new FileInputStream(ACTInterpreter.expand(tr.asm, parameters))));
            asmModule = new ASMModule(asm);
            debugger = null;
            if ("network".equals(tr.debug)) {
                debugger = new NetworkDebugger(6060, true);
            } else {
                boolean step = false;
                if ("step".equals(tr.debug)) {
                    step = true;
                }
                debugger = new SimpleDebugger(step, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), true);
            }
            env = new ASMExecEnv(asmModule, debugger);
            env.addModel((ASMModel)models.get("MOF"));
            env.addModel((ASMModel)models.get("ATL"));
            for (Object l : tr.models) {
                if (l instanceof InoutModel || l instanceof InModel) {
                    m = (ASMModel)models.get(((Model)l).model);
                    if (m == null) {
                        throw new ACTInterpreterException("ERROR: model " + ((Model)l).model + " not loaded yet.");
                    }
                    env.addModel(((Model)l).name, m);
                    continue;
                }
                if (l instanceof OutModel) {
                    m = (ASMModel)models.get(((Model)l).model);
                    if (m == null) {
                        mm = (ASMModel)models.get(((Model)l).metaModel);
                        if (mm == null) {
                            throw new ACTInterpreterException("ERROR: model " + ((Model)l).metaModel + " not loaded yet.");
                        }
                        m = ml.newModel(((Model)l).model, (String)params.get(((Model)l).name), mm);
                    }
                    env.addModel(((Model)l).name, m);
                    models.put(((Model)l).model, m);
                    continue;
                }
                ATLLogger.warning((String)(l + " not dealt with yet."));
            }
            env.registerOperations(asm);
            for (Object l : tr.librarys) {
                ATLLogger.info((String)("Loading library " + ((Library)l).name + " from " + ((Library)l).href + "."));
                lib = new ASMXMLReader().read(new BufferedInputStream(new FileInputStream(ACTInterpreter.expand(((Library)l).href, parameters))));
                env.registerOperations(lib);
            }
            asmParams = new HashMap();
            for (WithParam l : tr.withParams) {
                asmParams.put(l.name, ACTInterpreter.expand(l.value, params));
            }
            new ASMInterpreter(asm, asmModule, env, asmParams);
        }
        for (Model model : act.models) {
            if (!(model instanceof OutModel)) continue;
            ATLLogger.info((String)("Saving model " + model.name + "..."));
            String mhref = (String)params.get(model.name);
            if (mhref == null) {
                throw new ACTInterpreterException("ERROR: Location of output model " + model.name + " not specified on command line.");
            }
            ASMModel m = (ASMModel)models.get(model.name);
            if (m == null) {
                throw new ACTInterpreterException("ERROR: Model " + model.name + " is not already loaded.");
            }
            ml.save(m, mhref);
        }
    }

    private static void showUsage() {
        System.out.println("Usage : org.eclipse.m2m.atl.engine.vm.ACTInterpreter ACT=<act-file> XML=<xml-meta-model> ...");
        System.out.println();
    }

    public static void realMain(String[] args, PluginClassLoader pcl) throws Exception {
        String modelLoaderName;
        System.out.println("ATL 0.2 Composite Transformation Interpreter");
        System.out.println();
        long start = new Date().getTime();
        Map params = ACTInterpreter.parseCommandLine(args);
        String plugins = (String)params.get("plugins");
        if (plugins != null) {
            String[] ss = plugins.split(",");
            for (String plg : Arrays.asList(ss)) {
                ATLLogger.info((String)("Loading plugin: " + plg));
                pcl.addLocation(plg);
            }
        }
        if ((modelLoaderName = (String)params.get("ModelLoader")) == null) {
            modelLoaderName = "MDR";
        }
        ModelLoader ml = null;
        ml = modelLoaderName.equals("MDR") ? (ModelLoader)pcl.loadClass("org.eclipse.m2m.atl.drivers.mdr4atl.MDRModelLoader").newInstance() : (ModelLoader)pcl.loadClass("org.eclipse.m2m.atl.drivers.emf4atl.EMFModelLoader").newInstance();
        String act = (String)params.get("ACT");
        params.put("ACT_LOCATION", new File(act).getParent());
        String xml = (String)params.get("XML");
        if (act == null || xml == null) {
            ACTInterpreter.showUsage();
            System.exit(1);
        }
        HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
        ASMModel mof = ml.getMOF();
        models.put("MOF", mof);
        ASMModel xmlMM = ml.loadModel("XML", mof, xml);
        models.put("XML", xmlMM);
        System.out.println("Loading ACT: " + act);
        ASMModel actMM = ml.loadModel("ACT", xmlMM, "xml:" + act);
        models.put("ACT", actMM);
        ASMModelElement actRoot = (ASMModelElement)actMM.getElementsByType("Root").iterator().next();
        new ACTInterpreter(pcl, ml, actRoot, params, models);
        long end = new Date().getTime();
        ATLLogger.info((String)("Execution took " + (double)(end - start) / 1000.0 + "s."));
    }

    private static String expand(String s, Map parameters) throws ACTInterpreterException {
        StringBuffer ret = new StringBuffer();
        String varName = "";
        int state = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '$') {
                        state = 1;
                        break;
                    }
                    ret.append(c);
                    break;
                }
                case 1: {
                    if (c == '(') {
                        varName = "";
                        state = 2;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 2: {
                    if (c == ')') {
                        String value = (String)parameters.get(varName);
                        if (value == null) {
                            throw new ACTInterpreterException("ERROR: Variable not initialized: " + varName);
                        }
                        ret.append(value);
                        state = 0;
                        break;
                    }
                    varName = String.valueOf(varName) + c;
                }
            }
            ++i;
        }
        return ret.toString();
    }

    private void load(ASMModelElement source, Object target) throws Exception {
        Iterator i = ((ASMSequence)source.get(null, "children")).iterator();
        while (i.hasNext()) {
            ASMModelElement ame = (ASMModelElement)i.next();
            String typeName = ((ASMString)ame.getType().get(null, "name")).getSymbol();
            String name = ((ASMString)ame.get(null, "name")).getSymbol();
            if (typeName.equals("Attribute")) {
                String value = ((ASMString)ame.get(null, "value")).getSymbol();
                name = ACTInterpreter.convName(name, false);
                Field f = target.getClass().getField(name);
                f.set(target, value);
                continue;
            }
            if (!typeName.equals("Element")) continue;
            String cname = ACTInterpreter.convName(name, true);
            Class<?> c = Class.forName("org.eclipse.m2m.atl.engine.vm.ACTInterpreter$" + cname);
            Object value = c.getDeclaredConstructors()[0].newInstance(this);
            this.load(ame, value);
            ACTInterpreter.setValue(target, value, value.getClass());
        }
    }

    private static void setValue(Object target, Object value, Class valueType) throws Exception {
        block5: {
            String name = valueType.getName();
            name = name.replace('$', '.');
            name = name.substring(name.lastIndexOf(".") + 1);
            name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
            try {
                Field f = target.getClass().getField(name);
                f.set(target, value);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    Field f = target.getClass().getField(String.valueOf(name) + "s");
                    ((List)f.get(target)).add(value);
                }
                catch (NoSuchFieldException noSuchFieldException2) {
                    Class s = valueType.getSuperclass();
                    if (s == null) {
                        ATLLogger.warning((String)("Not found: " + name));
                        break block5;
                    }
                    ACTInterpreter.setValue(target, value, s);
                }
            }
        }
    }

    private static String convName(String name, boolean isClass) {
        StringBuffer ret = new StringBuffer();
        int state = isClass ? 0 : 1;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            block0 : switch (state) {
                case 0: {
                    ret.append(("" + c).toUpperCase());
                    state = 1;
                    break;
                }
                case 1: {
                    switch (c) {
                        case '-': {
                            state = 0;
                            break block0;
                        }
                    }
                    ret.append(c);
                }
            }
            ++i;
        }
        return ret.toString();
    }

    private static Map parseCommandLine(String[] args) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].matches("^[^=]*=.*$")) {
                String[] p = args[i].split("=");
                String s = "";
                int j = 1;
                while (j < p.length) {
                    s = String.valueOf(s) + (j != 1 ? "=" : "") + p[j];
                    ++j;
                }
                if (parameters.containsKey(p[0])) {
                    parameters.put(p[0], parameters.get(p[0]) + "," + s);
                } else {
                    parameters.put(p[0], s);
                }
            }
            ++i;
        }
        return parameters;
    }

    private class ACT {
        public String name;
        public List plugins = new ArrayList();
        public List file_s = new ArrayList();
        public List models = new ArrayList();
        public List params = new ArrayList();
        public List operations = new ArrayList();

        private ACT() {
        }
    }

    private abstract class File_ {
        public String name;
    }

    private class Import
    extends Operation {
        public String kind;
        public String subKind;
        public String metaModel;
        public String href;
        public String storeTo;
    }

    private class InFile
    extends File_ {
    }

    private class InModel
    extends Model {
    }

    private class InoutModel
    extends Model {
    }

    private class Library {
        public String name;
        public String href;
    }

    private abstract class Model {
        public String name;
        public String model;
        public String metaModel;

        private Model() {
        }
    }

    private abstract class Operation {
        private Operation() {
        }
    }

    private class OutModel
    extends Model {
    }

    private class Plugin {
        public String href;
    }

    private class Query
    extends Operation {
        public String asm;
        public String debug;
        public String writeTo;
        public String charset;
        public List models = new ArrayList();
        public List librarys = new ArrayList();
        public List withParams = new ArrayList();
    }

    private class Transform
    extends Operation {
        public String asm;
        public String debug;
        public List models = new ArrayList();
        public List librarys = new ArrayList();
        public List withParams = new ArrayList();
    }

    private class WithParam {
        public String name;
        public String type;
        public String value;
    }
}

