/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.codegen.qvti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.Pivot2CGVisitor;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.generator.GenModelException;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.LibraryProperty;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.codegen.qvti.QVTiAnalyzer;
import org.eclipse.qvtd.codegen.qvti.QVTiGlobalContext;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcorePropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcoreRealizedVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunction;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunctionCallExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunctionParameter;
import org.eclipse.qvtd.codegen.qvticgmodel.CGGuardVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMapping;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingCall;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingCallBinding;
import org.eclipse.qvtd.codegen.qvticgmodel.CGPredicate;
import org.eclipse.qvtd.codegen.qvticgmodel.CGPropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGRealizedVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTransformation;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTypedModel;
import org.eclipse.qvtd.codegen.qvticgmodel.QVTiCGModelFactory;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.Unit;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.EnforcementOperation;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.util.QVTimperativeVisitor;

public final class QVTiPivot2CGVisitor
extends Pivot2CGVisitor
implements QVTimperativeVisitor<CGNamedElement> {
    @NonNull
    protected final QVTiAnalyzer analyzer;
    @NonNull
    protected final QVTiGlobalContext globalContext;

    public QVTiPivot2CGVisitor(@NonNull QVTiAnalyzer analyzer, @NonNull QVTiGlobalContext globalContext) {
        super((CodeGenAnalyzer)analyzer);
        this.analyzer = analyzer;
        this.globalContext = globalContext;
    }

    protected void createMappingCalls(@NonNull Mapping pMapping, @NonNull CGMapping cgMapping) {
        for (MappingCall pMappingCall : pMapping.getMappingCall()) {
            CGMappingCall cgMappingCall = (CGMappingCall)this.doVisit(CGMappingCall.class, (Element)pMappingCall);
            cgMapping.getMappingCalls().add(cgMappingCall);
        }
    }

    protected void doBottoms(@NonNull Mapping pMapping, @NonNull CGMapping cgMapping) {
        ArrayList<BottomPattern> pBottomPatterns = new ArrayList<BottomPattern>();
        BottomPattern pBottomPattern = pMapping.getBottomPattern();
        if (pBottomPattern != null) {
            pBottomPatterns.add(pBottomPattern);
        }
        for (Domain pDomain : pMapping.getDomain()) {
            if (!(pDomain instanceof CoreDomain) || (pBottomPattern = ((CoreDomain)pDomain).getBottomPattern()) == null) continue;
            pBottomPatterns.add(pBottomPattern);
        }
        ArrayList pRealizedVariables = new ArrayList();
        for (BottomPattern pBottomPattern2 : pBottomPatterns) {
            pRealizedVariables.addAll(pBottomPattern2.getRealizedVariable());
        }
        Collections.sort(pRealizedVariables, new Comparator<NamedElement>(){

            @Override
            public int compare(NamedElement o1, NamedElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        List<CGRealizedVariable> cgRealizedVariables = cgMapping.getRealizedVariables();
        for (RealizedVariable pRealizedVariable : pRealizedVariables) {
            CGRealizedVariable cgVariable = this.getRealizedVariable(pRealizedVariable);
            cgRealizedVariables.add(cgVariable);
        }
        List<CGPropertyAssignment> cgAssignments = cgMapping.getAssignments();
        for (BottomPattern pBottomPattern3 : pBottomPatterns) {
            for (Assignment pAssignment : pBottomPattern3.getAssignment()) {
                cgAssignments.add((CGPropertyAssignment)this.doVisit(CGPropertyAssignment.class, (Element)pAssignment));
            }
        }
    }

    protected void doGuards(@NonNull Mapping pMapping, @NonNull CGMapping cgMapping) {
        ArrayList<GuardPattern> guardPatterns = new ArrayList<GuardPattern>();
        GuardPattern pGuardPattern = pMapping.getGuardPattern();
        if (pGuardPattern != null) {
            guardPatterns.add(pGuardPattern);
        }
        for (Domain pDomain : pMapping.getDomain()) {
            Object guardPattern;
            if (!(pDomain instanceof CoreDomain) || (guardPattern = ((CoreDomain)pDomain).getGuardPattern()) == null) continue;
            guardPatterns.add((GuardPattern)guardPattern);
        }
        ArrayList pGuardVariables = new ArrayList();
        for (GuardPattern pGuardPattern2 : guardPatterns) {
            pGuardVariables.addAll(pGuardPattern2.getVariable());
        }
        Collections.sort(pGuardVariables, new Comparator<NamedElement>(){

            @Override
            public int compare(NamedElement o1, NamedElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<CGGuardVariable> cgGuardVariables = new ArrayList<CGGuardVariable>();
        for (Variable pGuardVariable : pGuardVariables) {
            CGGuardVariable cgParameter = this.getGuardVariable(pGuardVariable);
            cgGuardVariables.add(cgParameter);
        }
        Collections.sort(cgGuardVariables, new Comparator<CGGuardVariable>(){

            @Override
            public int compare(CGGuardVariable o1, CGGuardVariable o2) {
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        cgMapping.getGuardVariables().addAll(cgGuardVariables);
        List<CGPredicate> cgGuardExpressions = cgMapping.getPredicates();
        for (GuardPattern pGuardPattern3 : guardPatterns) {
            for (Predicate pPredicate : pGuardPattern3.getPredicate()) {
                cgGuardExpressions.add((CGPredicate)this.doVisit(CGPredicate.class, (Element)pPredicate));
            }
        }
    }

    @NonNull
    public CGFunctionParameter getFunctionParameter(@NonNull FunctionParameter aParameter) {
        CGFunctionParameter cgFunctionParameter = (CGFunctionParameter)this.getVariablesStack().getParameter((Variable)aParameter);
        if (cgFunctionParameter == null) {
            cgFunctionParameter = QVTiCGModelFactory.eINSTANCE.createCGFunctionParameter();
            ((CodeGenAnalyzer)this.context).setNames((CGValuedElement)cgFunctionParameter, (Object)aParameter);
            this.setPivot((CGTypedElement)cgFunctionParameter, (TypedElement)aParameter);
            cgFunctionParameter.setTypeId(((CodeGenAnalyzer)this.context).getTypeId(aParameter.getTypeId()));
            this.addParameter((Variable)aParameter, cgFunctionParameter);
        }
        return cgFunctionParameter;
    }

    @NonNull
    public CGGuardVariable getGuardVariable(@NonNull Variable pParameter) {
        CGGuardVariable cgGuardVariable = (CGGuardVariable)this.getVariablesStack().getParameter(pParameter);
        if (cgGuardVariable == null) {
            cgGuardVariable = QVTiCGModelFactory.eINSTANCE.createCGGuardVariable();
            ((CodeGenAnalyzer)this.context).setNames((CGValuedElement)cgGuardVariable, (Object)pParameter);
            this.setPivot((CGTypedElement)cgGuardVariable, (TypedElement)pParameter);
            cgGuardVariable.setTypeId(((CodeGenAnalyzer)this.context).getTypeId(pParameter.getTypeId()));
            cgGuardVariable.setTypedModel(this.getTypedModel(pParameter));
            this.addParameter(pParameter, cgGuardVariable);
        }
        return cgGuardVariable;
    }

    @NonNull
    public CGRealizedVariable getRealizedVariable(@NonNull RealizedVariable pRealizedVariable) {
        Pivot2CGVisitor.Variables variablesStack = this.getVariablesStack();
        CGRealizedVariable cgVariable = (CGRealizedVariable)variablesStack.getVariable((VariableDeclaration)pRealizedVariable);
        if (cgVariable == null) {
            Type pivotType = (Type)DomainUtil.nonNullModel((Object)pRealizedVariable.getType());
            EClassifier eClassifier = (EClassifier)pivotType.getETarget();
            if (eClassifier != null) {
                CGEcoreRealizedVariable cgEcoreRealizedVariable = QVTiCGModelFactory.eINSTANCE.createCGEcoreRealizedVariable();
                cgEcoreRealizedVariable.setEClassifier(eClassifier);
                cgVariable = cgEcoreRealizedVariable;
            }
            if (cgVariable == null) {
                cgVariable = QVTiCGModelFactory.eINSTANCE.createCGRealizedVariable();
            }
            this.setPivot((CGTypedElement)cgVariable, (TypedElement)pRealizedVariable);
            cgVariable.setTypedModel(this.getTypedModel((Variable)pRealizedVariable));
            variablesStack.putVariable((VariableDeclaration)pRealizedVariable, (CGVariable)cgVariable);
        }
        return cgVariable;
    }

    @NonNull
    protected CGTypedModel getTypedModel(@NonNull Variable pVariable) {
        Area pArea = (Area)DomainUtil.nonNullState((Object)QVTcoreBaseUtil.getContainingArea((EObject)pVariable));
        TypedModel pTypedModel = null;
        if (pArea instanceof Domain) {
            pTypedModel = (TypedModel)DomainUtil.nonNullState((Object)((Domain)pArea).getTypedModel());
        } else {
            Transformation pTransformation = ((Mapping)pArea).getTransformation();
            pTypedModel = (TypedModel)DomainUtil.nonNullState((Object)pTransformation.getModelParameter(null));
        }
        return (CGTypedModel)DomainUtil.nonNullState((Object)this.analyzer.getTypedModel(pTypedModel));
    }

    @Nullable
    public CGNamedElement visitAssignment(@NonNull Assignment object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitBaseModel(@NonNull BaseModel object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitBottomPattern(@NonNull BottomPattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitCoreDomain(@NonNull CoreDomain object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitCorePattern(@NonNull CorePattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitDomain(@NonNull Domain object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitEnforcementOperation(@NonNull EnforcementOperation object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitFunction(@NonNull Function pFunction) {
        ExpressionInOCL expressionInOCL;
        CGFunction cgFunction = QVTiCGModelFactory.eINSTANCE.createCGFunction();
        this.setPivot((CGTypedElement)cgFunction, (TypedElement)pFunction);
        cgFunction.setRequired(pFunction.isRequired());
        for (Parameter pParameter : pFunction.getOwnedParameter()) {
            cgFunction.getParameters().add((CGParameter)this.doVisit(CGParameter.class, (Element)pParameter));
        }
        OpaqueExpression specification = pFunction.getBodyExpression();
        if (specification != null && (expressionInOCL = PivotUtil.getExpressionInOCL((NamedElement)pFunction, (OpaqueExpression)specification)) != null) {
            Variable contextVariable = expressionInOCL.getContextVariable();
            if (contextVariable != null) {
                this.getSelfParameter(contextVariable);
            }
            for (Variable parameterVariable : expressionInOCL.getParameterVariable()) {
                this.getParameter(parameterVariable);
            }
            cgFunction.setBody((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)expressionInOCL.getBodyExpression()));
        }
        this.analyzer.addFunction(pFunction, cgFunction);
        return cgFunction;
    }

    @Nullable
    public CGNamedElement visitFunctionParameter(@NonNull FunctionParameter pFunctionParameter) {
        return this.getFunctionParameter(pFunctionParameter);
    }

    @Nullable
    public CGNamedElement visitGuardPattern(@NonNull GuardPattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitImperativeModel(@NonNull ImperativeModel object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitMapping(@NonNull Mapping pMapping) {
        CGMapping cgMapping = QVTiCGModelFactory.eINSTANCE.createCGMapping();
        this.setPivot((CGNamedElement)cgMapping, (NamedElement)pMapping);
        this.analyzer.addMapping(pMapping, cgMapping);
        this.doGuards(pMapping, cgMapping);
        this.doBottoms(pMapping, cgMapping);
        this.createMappingCalls(pMapping, cgMapping);
        return cgMapping;
    }

    @Nullable
    public CGNamedElement visitMappingCall(@NonNull MappingCall pMappingCall) {
        CGMappingCall cgMappingCall = QVTiCGModelFactory.eINSTANCE.createCGMappingCall();
        this.setPivot((CGTypedElement)cgMappingCall, (TypedElement)pMappingCall);
        ArrayList<CGMappingCallBinding> cgMappingCallBindings = new ArrayList<CGMappingCallBinding>();
        for (MappingCallBinding pMappingCallBinding : pMappingCall.getBinding()) {
            CGMappingCallBinding cgMappingCallBinding = (CGMappingCallBinding)this.doVisit(CGMappingCallBinding.class, (Element)pMappingCallBinding);
            cgMappingCallBindings.add(cgMappingCallBinding);
        }
        Collections.sort(cgMappingCallBindings, new Comparator<CGMappingCallBinding>(){

            @Override
            public int compare(CGMappingCallBinding o1, CGMappingCallBinding o2) {
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        cgMappingCall.getMappingCallBindings().addAll(cgMappingCallBindings);
        return cgMappingCall;
    }

    @Nullable
    public CGNamedElement visitMappingCallBinding(@NonNull MappingCallBinding pMappingCallBinding) {
        CGMappingCallBinding cgMappingCallBinding = QVTiCGModelFactory.eINSTANCE.createCGMappingCallBinding();
        cgMappingCallBinding.setName(pMappingCallBinding.getBoundVariable().getName());
        cgMappingCallBinding.setLoop(pMappingCallBinding.isIsLoop());
        cgMappingCallBinding.setValueOrValues((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)pMappingCallBinding.getValue()));
        cgMappingCallBinding.setTypeId(this.analyzer.getTypeId(pMappingCallBinding.getBoundVariable().getTypeId()));
        return cgMappingCallBinding;
    }

    @NonNull
    public CGValuedElement visitOperationCallExp(@NonNull OperationCallExp element) {
        Operation pOperation = element.getReferredOperation();
        if (pOperation instanceof Function) {
            CGFunctionCallExp cgFunctionCallExp = QVTiCGModelFactory.eINSTANCE.createCGFunctionCallExp();
            cgFunctionCallExp.setReferredOperation(pOperation);
            this.setPivot((CGTypedElement)cgFunctionCallExp, (TypedElement)element);
            cgFunctionCallExp.setRequired(pOperation.isRequired());
            for (OCLExpression pArgument : element.getArgument()) {
                CGValuedElement cgArgument = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)pArgument);
                cgFunctionCallExp.getArguments().add(cgArgument);
            }
            return cgFunctionCallExp;
        }
        return super.visitOperationCallExp(element);
    }

    @Nullable
    public CGNamedElement visitPattern(@NonNull Pattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitPredicate(@NonNull Predicate pPredicate) {
        CGPredicate cgPredicate = QVTiCGModelFactory.eINSTANCE.createCGPredicate();
        cgPredicate.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        cgPredicate.setConditionExpression((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)pPredicate.getConditionExpression()));
        return cgPredicate;
    }

    @Nullable
    public CGNamedElement visitPropertyAssignment(@NonNull PropertyAssignment pPropertyAssignment) {
        EStructuralFeature eStructuralFeature;
        Property pivotProperty = (Property)DomainUtil.nonNullModel((Object)pPropertyAssignment.getTargetProperty());
        LibraryProperty libraryProperty = this.metaModelManager.getImplementation(pivotProperty);
        CGPropertyAssignment cgPropertyAssignment = null;
        if (this.isEcoreProperty(libraryProperty) && (eStructuralFeature = (EStructuralFeature)pivotProperty.getETarget()) != null) {
            try {
                this.genModelHelper.getGetAccessor(eStructuralFeature);
                CGEcorePropertyAssignment cgEcorePropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGEcorePropertyAssignment();
                cgEcorePropertyAssignment.setEStructuralFeature(eStructuralFeature);
                cgPropertyAssignment = cgEcorePropertyAssignment;
            }
            catch (GenModelException genModelException) {
                // empty catch block
            }
        }
        if (cgPropertyAssignment == null) {
            cgPropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGPropertyAssignment();
        }
        cgPropertyAssignment.setSlotValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)pPropertyAssignment.getSlotExpression()));
        cgPropertyAssignment.setReferredProperty(pPropertyAssignment.getTargetProperty());
        cgPropertyAssignment.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.OCL_VOID));
        cgPropertyAssignment.setInitValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)pPropertyAssignment.getValue()));
        return cgPropertyAssignment;
    }

    @Nullable
    public CGNamedElement visitRealizedVariable(@NonNull RealizedVariable object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitRule(@NonNull Rule object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitVariableAssignment(@NonNull VariableAssignment object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitTransformation(@NonNull Transformation element) {
        CGTransformation cgTransformation = QVTiCGModelFactory.eINSTANCE.createCGTransformation();
        this.setPivot((CGNamedElement)cgTransformation, (NamedElement)element);
        List<CGTypedModel> cgTypedModels = cgTransformation.getTypedModels();
        for (TypedModel pTypedModel : element.getModelParameter()) {
            CGTypedModel cgTypedModel = (CGTypedModel)this.doVisit(CGTypedModel.class, (Element)pTypedModel);
            cgTypedModel.setModelIndex(cgTypedModels.size());
            cgTypedModels.add(cgTypedModel);
        }
        for (Rule pivotRule : element.getRule()) {
            CGMapping cgMapping = (CGMapping)this.doVisit(CGMapping.class, (Element)pivotRule);
            cgTransformation.getMappings().add(cgMapping);
        }
        for (Operation pivotOperation : element.getOwnedOperation()) {
            CGOperation cgOperation = (CGOperation)this.doVisit(CGOperation.class, (Element)pivotOperation);
            cgTransformation.getOperations().add(cgOperation);
        }
        return cgTransformation;
    }

    @Nullable
    public CGNamedElement visitTypedModel(@NonNull TypedModel pTypedModel) {
        CGTypedModel cgTypedModel = QVTiCGModelFactory.eINSTANCE.createCGTypedModel();
        this.setPivot(cgTypedModel, (NamedElement)pTypedModel);
        this.analyzer.addTypedModel(pTypedModel, cgTypedModel);
        return cgTypedModel;
    }

    @Nullable
    public CGNamedElement visitUnit(@NonNull Unit object) {
        return this.visiting((Visitable)object);
    }
}

