/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.all.tests;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.qvtd.text.utilities.TextModelResourceFactoryImpl;
import org.eclipse.qvtd.xtext.qvtbase.tests.XtextTestCase;

public class TextModelTests
extends XtextTestCase {
    protected void doTextTest(String testPath) throws IOException {
        ProjectManager projectManager = this.getTestProjectManager();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        projectManager.initializeResourceSet((ResourceSet)resourceSet);
        TestProject testProject = this.getTestProject();
        String inPath = String.valueOf(this.getTestBundleName()) + "/models/" + testPath + ".textmodel";
        URI inURI = URI.createPlatformResourceURI((String)inPath, (boolean)true);
        TestFile outFile = testProject.getOutputFile(String.valueOf(testPath) + ".out.textmodel");
        TestFile xmlFile = testProject.getOutputFile(String.valueOf(testPath) + ".xml");
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("textmodel", new TextModelResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        Resource textResource = resourceSet.getResource(inURI, true);
        textResource.toString();
        URI xmlURI = xmlFile.getURI();
        URI textOutURI = outFile.getURI();
        textResource.setURI(textOutURI);
        textResource.save(null);
        Resource xmlResource = resourceSet.createResource(xmlURI);
        xmlResource.getContents().addAll((Collection)textResource.getContents());
        xmlResource.save(null);
        String inFileString = this.readFile(new InputStreamReader(resourceSet.getURIConverter().createInputStream(inURI)));
        String outFileString = this.readFile(new FileReader(outFile.getFile()));
        TextModelTests.assertEquals((String)inFileString, (String)outFileString);
    }

    protected String readFile(@NonNull Reader reader) throws IOException {
        String line;
        StringBuilder s = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((line = bufferedReader.readLine()) != null) {
            s.append(line);
            s.append("\n");
        }
        bufferedReader.close();
        return s.toString();
    }

    public void testText_BadIndents() throws Exception {
        String testPath = "badindents";
        this.doTextTest(testPath);
    }

    public void testText_BadTree() throws Exception {
        String testPath = "badtree";
        this.doTextTest(testPath);
    }

    public void testText_List() throws Exception {
        String testPath = "list";
        this.doTextTest(testPath);
    }

    public void testText_SimpleIndents() throws Exception {
        String testPath = "simpleindents";
        this.doTextTest(testPath);
    }

    public void testText_Tree() throws Exception {
        String testPath = "tree";
        this.doTextTest(testPath);
    }
}

