/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.EdgeMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.RegionMerger;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class NodeMerger {
    protected final @NonNull RegionMerger regionMerger;
    protected final @NonNull List<@NonNull Node> oldNodes = new ArrayList<Node>();
    private @NonNull Role nodeRole;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Node.Utility nodeUtility;
    private @NonNull Map<@NonNull NodeMerger, @NonNull List<@NonNull EdgeMerger>> sourceNodeMerger2edgeMergers = new HashMap<NodeMerger, List<EdgeMerger>>();
    private @NonNull Map<@NonNull NodeMerger, @NonNull List<@NonNull EdgeMerger>> targetNodeMerger2edgeMergers = new HashMap<NodeMerger, List<EdgeMerger>>();
    private @Nullable Node newNode = null;

    public NodeMerger(@NonNull RegionMerger regionMerger, @NonNull Node oldNode) {
        this.regionMerger = regionMerger;
        this.oldNodes.add(oldNode);
        this.nodeRole = QVTscheduleUtil.getNodeRole((Node)oldNode);
        this.nodeUtility = oldNode.getUtility();
        regionMerger.mapOldNode(oldNode, this);
    }

    public void addIncomingEdgeMerger(@NonNull EdgeMerger edgeMerger, @NonNull NodeMerger sourceNodeMerger) {
        List<@NonNull EdgeMerger> edgeMergers = this.getIncomingEdgeMergers(sourceNodeMerger);
        assert (!edgeMergers.contains(edgeMerger));
        edgeMergers.add(edgeMerger);
    }

    public void addOutgoingEdgeMerger(@NonNull EdgeMerger edgeMerger, @NonNull NodeMerger targetNodeMerger) {
        List<@NonNull EdgeMerger> edgeMergers = this.getOutgoingEdgeMergers(targetNodeMerger);
        assert (!edgeMergers.contains(edgeMerger));
        edgeMergers.add(edgeMerger);
    }

    public void addOldNode(@NonNull Node oldNode) {
        assert (!this.oldNodes.contains(oldNode));
        this.oldNodes.add(oldNode);
        this.nodeRole = QVTscheduleUtil.mergeToMoreKnownPhase((Role)this.nodeRole, (Role)QVTscheduleUtil.getNodeRole((Node)oldNode));
        this.nodeUtility = QVTscheduleUtil.mergeToStrongerUtility((Node.Utility)this.nodeUtility, (Node.Utility)oldNode.getUtility());
        this.regionMerger.mapOldNode(oldNode, this);
    }

    public @Nullable Node createNewNode(@NonNull MappingRegion newRegion) {
        Node newNode2 = this.newNode;
        assert (newNode2 == null);
        Iterator<Node> iterator = this.oldNodes.iterator();
        if (iterator.hasNext()) {
            @NonNull Node oldNode = iterator.next();
            newNode2 = this.newNode = oldNode.createNode(this.nodeRole, (Region)newRegion);
            if (oldNode.isHead()) {
                newNode2.setHead();
                newRegion.getHeadNodes().add((Object)newNode2);
            }
            newNode2.setUtility(this.nodeUtility);
        }
        if (newNode2 == null) {
            return null;
        }
        for (@NonNull Node oldNode : this.oldNodes) {
            for (TypedElement typedElement : oldNode.getTypedElements()) {
                newNode2.addTypedElement(typedElement);
            }
        }
        return newNode2;
    }

    public void destroy() {
        int i;
        for (List<EdgeMerger> incomingEdgeMergers : this.sourceNodeMerger2edgeMergers.values()) {
            i = incomingEdgeMergers.size();
            while (--i >= 0) {
                incomingEdgeMergers.get(i).destroy();
            }
        }
        for (List<EdgeMerger> outgoingEdgeMergers : this.targetNodeMerger2edgeMergers.values()) {
            i = outgoingEdgeMergers.size();
            while (--i >= 0) {
                outgoingEdgeMergers.get(i).destroy();
            }
        }
        for (Node oldNode : this.oldNodes) {
            this.regionMerger.unmapOldNode(oldNode, this);
        }
    }

    public void gatherFoldableEdges(@NonNull List<@NonNull EdgeMerger> foldableEdgeMergers) {
        for (List<EdgeMerger> outgoingEdgeMergers : this.targetNodeMerger2edgeMergers.values()) {
            for (EdgeMerger edgeMerger : outgoingEdgeMergers) {
                if (!edgeMerger.isFoldable()) continue;
                foldableEdgeMergers.add(edgeMerger);
            }
        }
    }

    public @NonNull List<@NonNull EdgeMerger> getIncomingEdgeMergers(@NonNull NodeMerger sourceNodeMerger) {
        List<@NonNull EdgeMerger> edgeMergers = this.sourceNodeMerger2edgeMergers.get(sourceNodeMerger);
        if (edgeMergers == null) {
            edgeMergers = new ArrayList<EdgeMerger>();
            this.sourceNodeMerger2edgeMergers.put(sourceNodeMerger, edgeMergers);
        }
        return edgeMergers;
    }

    public @NonNull Node getNewNode() {
        return (Node)ClassUtil.nonNullState((Object)this.newNode);
    }

    public @NonNull Iterable<@NonNull Node> getOldNodes() {
        return this.oldNodes;
    }

    public @NonNull List<@NonNull EdgeMerger> getOutgoingEdgeMergers(@NonNull NodeMerger targetNodeMerger) {
        List<@NonNull EdgeMerger> edgeMergers = this.targetNodeMerger2edgeMergers.get(targetNodeMerger);
        if (edgeMergers == null) {
            edgeMergers = new ArrayList<EdgeMerger>();
            this.targetNodeMerger2edgeMergers.put(targetNodeMerger, edgeMergers);
        }
        return edgeMergers;
    }

    public boolean isNew() {
        return this.nodeRole.isNew();
    }

    public void removeIncomingEdgeMerger(@NonNull EdgeMerger edgeMerger, @NonNull NodeMerger sourceNodeMerger) {
        List<@NonNull EdgeMerger> edgeMergers = this.getIncomingEdgeMergers(sourceNodeMerger);
        boolean wasRemoved = edgeMergers.remove(edgeMerger);
        assert (wasRemoved);
    }

    public void removeOutgoingEdgeMerger(@NonNull EdgeMerger edgeMerger, @NonNull NodeMerger targetNodeMerger) {
        List<@NonNull EdgeMerger> edgeMergers = this.getOutgoingEdgeMergers(targetNodeMerger);
        boolean wasRemoved = edgeMergers.remove(edgeMerger);
        assert (wasRemoved);
    }

    public @NonNull String toString() {
        return String.valueOf(this.newNode != null ? this.newNode : this.oldNodes.get(0));
    }
}

