/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.EdgeMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.RegionMerger;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class NodeMerger {
    protected final @NonNull RegionMerger regionMerger;
    protected final @NonNull List<@NonNull Node> originalNodes = new ArrayList<Node>();
    private @NonNull Role nodeRole;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Node.Utility nodeUtility;
    private @NonNull Map<@NonNull NodeMerger, @NonNull List<@NonNull EdgeMerger>> sourceNodeMerger2edgeMergers = new HashMap<NodeMerger, List<EdgeMerger>>();
    private @NonNull Map<@NonNull NodeMerger, @NonNull List<@NonNull EdgeMerger>> targetNodeMerger2edgeMergers = new HashMap<NodeMerger, List<EdgeMerger>>();
    private @Nullable Node mergedNode = null;

    public NodeMerger(@NonNull RegionMerger regionMerger, @NonNull Node originalNode) {
        this.regionMerger = regionMerger;
        this.originalNodes.add(originalNode);
        this.nodeRole = QVTscheduleUtil.getNodeRole((Node)originalNode);
        this.nodeUtility = originalNode.getUtility();
        regionMerger.mapOriginalNode(originalNode, this);
    }

    public void addIncomingEdgeMerger(@NonNull EdgeMerger edgeMerger, @NonNull NodeMerger sourceNodeMerger) {
        List<@NonNull EdgeMerger> edgeMergers = this.getIncomingEdgeMergers(sourceNodeMerger);
        assert (!edgeMergers.contains(edgeMerger));
        edgeMergers.add(edgeMerger);
    }

    public void addOutgoingEdgeMerger(@NonNull EdgeMerger edgeMerger, @NonNull NodeMerger targetNodeMerger) {
        List<@NonNull EdgeMerger> edgeMergers = this.getOutgoingEdgeMergers(targetNodeMerger);
        assert (!edgeMergers.contains(edgeMerger));
        edgeMergers.add(edgeMerger);
    }

    public void addOriginalNode(@NonNull Node originalNode) {
        assert (!this.originalNodes.contains(originalNode));
        this.originalNodes.add(originalNode);
        this.nodeRole = QVTscheduleUtil.mergeToMoreKnownPhase((Role)this.nodeRole, (Role)QVTscheduleUtil.getNodeRole((Node)originalNode));
        this.nodeUtility = QVTscheduleUtil.mergeToStrongerUtility((Node.Utility)this.nodeUtility, (Node.Utility)originalNode.getUtility());
        this.regionMerger.mapOriginalNode(originalNode, this);
    }

    public @Nullable Node createMergedNode(@NonNull MappingRegion mergedRegion) {
        Node mergedNode2 = this.mergedNode;
        assert (mergedNode2 == null);
        Iterator<Node> iterator = this.originalNodes.iterator();
        if (iterator.hasNext()) {
            @NonNull Node originalNode = iterator.next();
            mergedNode2 = this.mergedNode = originalNode.createNode(this.nodeRole, (Region)mergedRegion);
            if (originalNode.isHead()) {
                mergedNode2.setHead();
                mergedRegion.getHeadNodes().add((Object)mergedNode2);
            }
            mergedNode2.setUtility(this.nodeUtility);
        }
        if (mergedNode2 == null) {
            return null;
        }
        return mergedNode2;
    }

    public void destroy() {
        int i;
        for (List<EdgeMerger> incomingEdgeMergers : this.sourceNodeMerger2edgeMergers.values()) {
            i = incomingEdgeMergers.size();
            while (--i >= 0) {
                incomingEdgeMergers.get(i).destroy();
            }
        }
        for (List<EdgeMerger> outgoingEdgeMergers : this.targetNodeMerger2edgeMergers.values()) {
            i = outgoingEdgeMergers.size();
            while (--i >= 0) {
                outgoingEdgeMergers.get(i).destroy();
            }
        }
        for (Node originalNode : this.originalNodes) {
            this.regionMerger.unmapOriginalNode(originalNode, this);
        }
    }

    public void gatherFoldableEdges(@NonNull List<@NonNull EdgeMerger> foldableEdgeMergers) {
        for (List<EdgeMerger> outgoingEdgeMergers : this.targetNodeMerger2edgeMergers.values()) {
            for (EdgeMerger edgeMerger : outgoingEdgeMergers) {
                if (!edgeMerger.isFoldable()) continue;
                foldableEdgeMergers.add(edgeMerger);
            }
        }
    }

    public @NonNull Iterable<@NonNull Edge> getArgumentEdges() {
        return this.getPrimaryNode().getArgumentEdges();
    }

    public @NonNull List<@NonNull EdgeMerger> getIncomingEdgeMergers(@NonNull NodeMerger sourceNodeMerger) {
        List<@NonNull EdgeMerger> edgeMergers = this.sourceNodeMerger2edgeMergers.get(sourceNodeMerger);
        if (edgeMergers == null) {
            edgeMergers = new ArrayList<EdgeMerger>();
            this.sourceNodeMerger2edgeMergers.put(sourceNodeMerger, edgeMergers);
        }
        return edgeMergers;
    }

    public @NonNull Node getMergedNode() {
        return (Node)ClassUtil.nonNullState((Object)this.mergedNode);
    }

    public @NonNull String getName() {
        return QVTscheduleUtil.getName((Nameable)this.getPrimaryNode());
    }

    public @Nullable NavigableEdge getNavigableEdge(@NonNull Property property) {
        return this.getPrimaryNode().getNavigableEdge(property);
    }

    public @Nullable Node getNavigableTarget(@NonNull Property property) {
        return this.getPrimaryNode().getNavigableTarget(property);
    }

    public @NonNull Role getNodeRole() {
        return QVTscheduleUtil.getNodeRole((Node)this.getPrimaryNode());
    }

    public @NonNull Iterable<@NonNull Node> getOriginalNodes() {
        return this.originalNodes;
    }

    public @NonNull List<@NonNull EdgeMerger> getOutgoingEdgeMergers(@NonNull NodeMerger targetNodeMerger) {
        List<@NonNull EdgeMerger> edgeMergers = this.targetNodeMerger2edgeMergers.get(targetNodeMerger);
        if (edgeMergers == null) {
            edgeMergers = new ArrayList<EdgeMerger>();
            this.targetNodeMerger2edgeMergers.put(targetNodeMerger, edgeMergers);
        }
        return edgeMergers;
    }

    private @NonNull Node getPrimaryNode() {
        return this.originalNodes.get(0);
    }

    public boolean isConstant() {
        return this.getPrimaryNode().isConstant();
    }

    public boolean isIterator() {
        return this.getPrimaryNode().isIterator();
    }

    public boolean isLoaded() {
        return this.getPrimaryNode().isLoaded();
    }

    public boolean isNew() {
        return this.nodeRole.isNew();
    }

    public boolean isNullLiteral() {
        return this.getPrimaryNode().isNullLiteral();
    }

    public boolean isOld() {
        return this.getPrimaryNode().isOld();
    }

    public boolean isRequired() {
        return this.getPrimaryNode().isRequired();
    }

    public boolean isUnconditional() {
        return this.getPrimaryNode().isUnconditional();
    }

    public void removeIncomingEdgeMerger(@NonNull EdgeMerger edgeMerger, @NonNull NodeMerger sourceNodeMerger) {
        List<@NonNull EdgeMerger> edgeMergers = this.getIncomingEdgeMergers(sourceNodeMerger);
        boolean wasRemoved = edgeMergers.remove(edgeMerger);
        assert (wasRemoved);
    }

    public void removeOutgoingEdgeMerger(@NonNull EdgeMerger edgeMerger, @NonNull NodeMerger targetNodeMerger) {
        List<@NonNull EdgeMerger> edgeMergers = this.getOutgoingEdgeMergers(targetNodeMerger);
        boolean wasRemoved = edgeMergers.remove(edgeMerger);
        assert (wasRemoved);
    }

    public @NonNull String toString() {
        return String.valueOf(this.mergedNode != null ? this.mergedNode : this.originalNodes.get(0));
    }
}

