/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.cs2as.compiler.tests;

import example1.source.SourcePackage;
import example1.target.TargetPackage;
import example2.classes.ClassesPackage;
import example2.classes.lookup.EnvironmentPackage;
import example2.classescs.ClassescsPackage;
import example2.classescstraces.ClassescstracesPackage;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.dynamic.JavaClasspath;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystemHelper;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.AbstractCompilerOptions;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.cs2as.compiler.CS2ASJavaCompilerParameters;
import org.eclipse.qvtd.cs2as.compiler.internal.CS2ASJavaCompilerImpl;
import org.eclipse.qvtd.cs2as.compiler.internal.CS2ASJavaCompilerParametersImpl;
import org.eclipse.qvtd.cs2as.compiler.internal.OCL2QVTiCompilerChain;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbase;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;
import org.eclipse.qvtd.pivot.qvtschedule.impl.RuleRegionImpl;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.xtext.qvtbase.tests.AbstractTestQVT;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.QVTbaseTestFileSystemHelper;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.junit.After;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class OCL2QVTiTestCases
extends LoadTestCase {
    private static boolean NO_MERGES = true;

    protected @NonNull CompilerOptions createCompilerOptions() {
        return new AbstractCompilerOptions(){};
    }

    protected @NonNull OCLInternal createOCL() {
        return QVTimperative.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    private @NonNull CS2ASJavaCompilerParameters createParameters(@NonNull String lookupSolverClassName, @NonNull String lookupResultClassName) throws IOException {
        CS2ASJavaCompilerParametersImpl cgParams = new CS2ASJavaCompilerParametersImpl(lookupSolverClassName, lookupResultClassName, this.getTestProject().getOutputFile("test-src").getFileString());
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            JavaClasspath classpath = CompilerUtil.createDefaultQVTiClasspath();
            classpath.addClass(((Object)((Object)this)).getClass());
            cgParams.setClasspath(classpath);
        }
        cgParams.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        return cgParams;
    }

    private @NonNull MyQVT createQVT(@NonNull String modelTestName, @NonNull URI txURI, @NonNull String modelSamples) throws Exception {
        ProjectManager testProjectManager = this.getTestProjectManager();
        URI intermediateFileNamePrefixURI = this.getTestURI(modelTestName);
        URI srcFileURI = this.getTestFileURI("test-src/");
        URI binFileURI = this.getTestFileURI("test-bin/");
        return new MyQVT(testProjectManager, this.getTestProject(), this.getTestBundleURI(), txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI, modelTestName, modelSamples);
    }

    protected @NonNull TestFileSystemHelper getTestFileSystemHelper() {
        QVTbaseTestFileSystemHelper testFileSystemHelper = new QVTbaseTestFileSystemHelper();
        testFileSystemHelper.addRequiredBundle("org.eclipse.qvtd.cs2as.compiler.tests");
        return testFileSystemHelper;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        QVTm2QVTs.DEBUG_GRAPHS.setState(true);
        XtextCompilerUtil.doQVTimperativeSetup();
        XtextCompilerUtil.doQVTcoreSetup();
        TestUtil.doCompleteOCLSetup();
    }

    @After
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testOCL2QVTi_Source2Target_CG() throws Exception {
        MyQVT myQVT = this.createQVT("Source2Target", this.getModelsURI("Source2Target/Source2Target.ocl"), "samples");
        try {
            myQVT.loadGenModels(new URI[]{this.getModelsURI("Source2Target/SourceMM1.genmodel"), this.getModelsURI("Source2Target/TargetMM1.genmodel")});
            myQVT.loadEcoreFile(this.getModelsURI("Source2Target/EnvExample1.ecore"), example1.target.lookup.EnvironmentPackage.eINSTANCE);
            ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("Source2Target.ocl", new String[0]);
            myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 23 : 19);
            CS2ASJavaCompilerParameters cgParams = this.createParameters("example1.target.lookup.util.TargetLookupSolver", "example1.target.lookup.util.TargetLookupResult");
            java.lang.Class txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, qvtiTransf, cgParams);
            myQVT.executeModelsTX_CG(txClass, "model1");
            myQVT.executeModelsTX_CG(txClass, "model2");
            myQVT.executeModelsTX_CG(txClass, "model3");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example1/sourceMM/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example1/targetMM/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_Source2Target_Interpreted() throws Exception {
        testCaseAppender.uninstall();
        MyQVT myQVT = this.createQVT("Source2Target", this.getModelsURI("Source2Target/Source2Target.ocl"), "samples");
        try {
            myQVT.loadGenModels(new URI[]{this.getModelsURI("Source2Target/SourceMM1.genmodel"), this.getModelsURI("Source2Target/TargetMM1.genmodel")});
            ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("Source2Target.ocl", new String[0]);
            URI txURI = qvtiTransf.eResource().getURI();
            myQVT.dispose();
            myQVT = this.createQVT("Source2Target", this.getModelsURI("Source2Target/Source2Target.ocl"), "samples");
            myQVT.loadEcoreFile(this.getModelsURI("Source2Target/SourceMM1.ecore"), SourcePackage.eINSTANCE);
            myQVT.loadEcoreFile(this.getModelsURI("Source2Target/TargetMM1.ecore"), TargetPackage.eINSTANCE);
            ImperativeTransformation tx = this.getTransformation(myQVT.getMetamodelManager().getASResourceSet(), txURI);
            myQVT.executeModelsTX_Interpreted(tx, "model1");
            myQVT.executeModelsTX_Interpreted(tx, "model2");
            myQVT.executeModelsTX_Interpreted(tx, "model3");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example1/sourceMM/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example1/targetMM/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_Source2Target_OCL2QVTm() throws Exception {
        MyQVT myQVT = this.createQVT("Source2Target", this.getModelsURI("Source2Target/Source2Target.ocl"), "samples");
        URI oclDocURI = this.getModelsURI("Source2Target/Source2Target.ocl");
        URI qvtmFileURI = this.getTestURI("Source2Target.qvtm.qvtcas");
        OCL2QVTiCompilerChain mtc = new OCL2QVTiCompilerChain((QVTimperative)myQVT, this.createCompilerOptions(), oclDocURI, this.getTestURIWithExtension(oclDocURI, "tmp"), new URI[0]);
        mtc.ocl2qvtmCompilerStep.ocl2qvtm(oclDocURI.appendFileExtension("oclas"));
        OCL2QVTiTestCases.assertValidQVTiModel(qvtmFileURI);
        myQVT.dispose();
    }

    @Test
    public void testOCL2QVTi_SimpleClasses_CG() throws Exception {
        MyQVT myQVT = this.createQVT("SimpleClasses", this.getModelsURI("SimpleClasses/classescs2as.ocl"), "samples");
        try {
            myQVT.loadGenModels(new URI[]{this.getModelsURI("SimpleClasses/ClassesCS.genmodel"), this.getModelsURI("SimpleClasses/Classes.genmodel")});
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/EnvExample2.ecore"), EnvironmentPackage.eINSTANCE);
            ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("classescs2as.ocl", new String[0]);
            myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 9 : 3);
            CS2ASJavaCompilerParameters cgParams = this.createParameters("example2.classes.lookup.util.ClassesLookupSolver", "example2.classes.lookup.util.ClassesLookupResult");
            java.lang.Class txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, qvtiTransf, cgParams);
            myQVT.executeModelsTX_CG(txClass, "model1");
            myQVT.executeModelsTX_CG(txClass, "model2");
            myQVT.executeModelsTX_CG(txClass, "model3");
            myQVT.executeModelsTX_CG(txClass, "model4");
            myQVT.executeModelsTX_CG(txClass, "model5");
            myQVT.executeModelsTX_CG(txClass, "model6");
            myQVT.executeModelsTX_CG(txClass, "model7");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classes/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs2as/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_SimpleClasses_Interpreted() throws Exception {
        testCaseAppender.uninstall();
        MyQVT myQVT = this.createQVT("SimpleClasses", this.getModelsURI("SimpleClasses/classescs2as.ocl"), "samples");
        myQVT.loadGenModels(new URI[]{this.getModelsURI("SimpleClasses/ClassesCS.genmodel"), this.getModelsURI("SimpleClasses/Classes.genmodel")});
        ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("classescs2as.ocl", new String[0]);
        URI txURI = qvtiTransf.eResource().getURI();
        myQVT.dispose();
        try {
            myQVT = this.createQVT("SimpleClasses", this.getModelsURI("SimpleClasses/classescs2as.ocl"), "samples");
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/Classes.ecore"), ClassesPackage.eINSTANCE);
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/ClassesCS.ecore"), ClassescsPackage.eINSTANCE);
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/classescs2as.ecore"), ClassescstracesPackage.eINSTANCE);
            ImperativeTransformation tx = this.getTransformation(myQVT.getMetamodelManager().getASResourceSet(), txURI);
            myQVT.executeModelsTX_Interpreted(tx, "model1");
            myQVT.executeModelsTX_Interpreted(tx, "model2");
            myQVT.executeModelsTX_Interpreted(tx, "model3");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classes/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs2as/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_StructuredClasses_CG() throws Exception {
        MyQVT myQVT = this.createQVT("StructuredClasses", this.getModelsURI("StructuredClasses/classescs2asV2.ocl"), "samples");
        try {
            myQVT.loadGenModels(new URI[]{this.getModelsURI("SimpleClasses/ClassesCS.genmodel"), this.getModelsURI("SimpleClasses/Classes.genmodel")});
            ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("classescs2asV2.ocl", new String[0]);
            myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 30 : 15);
            CS2ASJavaCompilerParameters cgParams = this.createParameters("example2.classes.lookup.util.ClassesLookupSolver", "example2.classes.lookup.util.ClassesLookupResult");
            java.lang.Class txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, qvtiTransf, cgParams);
            myQVT.dispose();
            myQVT = this.createQVT("StructuredClasses", this.getModelsURI("StructuredClasses/classescs2asV2.ocl"), "samples");
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/Classes.ecore"), ClassesPackage.eINSTANCE);
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/ClassesCS.ecore"), ClassescsPackage.eINSTANCE);
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/classescs2as.ecore"), ClassescstracesPackage.eINSTANCE);
            myQVT.executeModelsTX_CG(txClass, "model1V2");
            myQVT.executeModelsTX_CG(txClass, "model2V2");
            myQVT.executeModelsTX_CG(txClass, "model3V2");
            myQVT.executeModelsTX_CG(txClass, "model4V2");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classes/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs2as/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_StructuredClasses_Interpreted() throws Exception {
        testCaseAppender.uninstall();
        MyQVT myQVT = this.createQVT("StructuredClasses", this.getModelsURI("StructuredClasses/classescs2asV2.ocl"), "samples");
        try {
            myQVT.loadGenModels(new URI[]{this.getModelsURI("SimpleClasses/ClassesCS.genmodel"), this.getModelsURI("SimpleClasses/Classes.genmodel")});
            ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("classescs2asV2.ocl", new String[0]);
            URI txURI = qvtiTransf.eResource().getURI();
            myQVT.dispose();
            myQVT = this.createQVT("StructuredClasses", this.getModelsURI("StructuredClasses/classescs2asV2.ocl"), "samples");
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/Classes.ecore"), ClassesPackage.eINSTANCE);
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/ClassesCS.ecore"), ClassescsPackage.eINSTANCE);
            myQVT.loadEcoreFile(this.getModelsURI("SimpleClasses/classescs2as.ecore"), ClassescstracesPackage.eINSTANCE);
            ImperativeTransformation tx = this.getTransformation(myQVT.getMetamodelManager().getASResourceSet(), txURI);
            myQVT.executeModelsTX_Interpreted(tx, "model1V2");
            myQVT.executeModelsTX_Interpreted(tx, "model2V2");
            myQVT.executeModelsTX_Interpreted(tx, "model3V2");
            myQVT.executeModelsTX_Interpreted(tx, "model4V2");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classes/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example2/classescs2as/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_SimpleClasses_OCL2QVTm_MiddleFolded() throws Exception {
        MyQVT myQVT = this.createQVT("SimpleClasses", this.getModelsURI("SimpleClasses/classescs2as.ocl"), "samples");
        URI oclDocURI = this.getModelsURI("SimpleClasses/classescs2as.ocl");
        URI qvtmFileURI = this.getTestURI("classescs2as.qvtm.qvtcas");
        OCL2QVTiCompilerChain mtc = new OCL2QVTiCompilerChain((QVTimperative)myQVT, this.createCompilerOptions(), oclDocURI, this.getTestURIWithExtension(oclDocURI, "tmp"), new URI[0]);
        mtc.ocl2qvtmCompilerStep.ocl2qvtm(oclDocURI.appendFileExtension("oclas"));
        OCL2QVTiTestCases.assertValidQVTiModel(qvtmFileURI);
        myQVT.dispose();
    }

    @Test
    public void testOCL2QVTi_KiamaRewrite_CG() throws Exception {
        MyQVT myQVT = this.createQVT("KiamaRewrite", this.getModelsURI("KiamaRewrite/KiamaRewrite.ocl"), "samples");
        try {
            myQVT.loadGenModels(new URI[]{this.getModelsURI("KiamaRewrite/KiamaAS.genmodel"), this.getModelsURI("KiamaRewrite/KiamaCS.genmodel")});
            ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("KiamaRewrite.ocl", new String[0]);
            myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 11 : 6);
            CS2ASJavaCompilerParameters cgParams = this.createParameters("", "");
            java.lang.Class txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, qvtiTransf, cgParams);
            myQVT.executeModelsTX_CG(txClass, "model1");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example3/kiamaas/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example3/kiamacs/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_KiamaRewrite_Interpreted() throws Exception {
        MyQVT myQVT = this.createQVT("KiamaRewrite", this.getModelsURI("KiamaRewrite/KiamaRewrite.ocl"), "samples");
        myQVT.loadGenModels(new URI[]{this.getModelsURI("KiamaRewrite/KiamaAS.genmodel"), this.getModelsURI("KiamaRewrite/KiamaCS.genmodel")});
        ImperativeTransformation tx = myQVT.executeOCL2QVTi_CompilerChain("KiamaRewrite.ocl", new String[0]);
        myQVT.executeModelsTX_Interpreted(tx, "model1");
        myQVT.dispose();
    }

    @Test
    public void testOCL2QVTi_SimplerKiama_CG() throws Exception {
        MyQVT myQVT = this.createQVT("SimplerKiama", this.getModelsURI("SimplerKiama/SimplerKiama.ocl"), "samples");
        try {
            myQVT.loadGenModels(new URI[]{this.getModelsURI("SimplerKiama/SimplerKiamaAS.genmodel"), this.getModelsURI("SimplerKiama/SimplerKiamaCS.genmodel")});
            ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("SimplerKiama.ocl", new String[0]);
            myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 9 : 7);
            CS2ASJavaCompilerParameters cgParams = this.createParameters("", "");
            java.lang.Class txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, qvtiTransf, cgParams);
            myQVT.executeModelsTX_CG(txClass, "model1");
            myQVT.executeModelsTX_CG(txClass, "model2");
            myQVT.executeModelsTX_CG(txClass, "model3");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example4/simplerkiamacs/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example4/simplerkiamaas/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_SimplerKiama_Interpreted() throws Exception {
        MyQVT myQVT = this.createQVT("SimplerKiama", this.getModelsURI("SimplerKiama/SimplerKiama.ocl"), "samples");
        myQVT.loadGenModels(new URI[]{this.getModelsURI("SimplerKiama/SimplerKiamaAS.genmodel"), this.getModelsURI("SimplerKiama/SimplerKiamaCS.genmodel")});
        ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("SimplerKiama.ocl", new String[0]);
        URI txURI = qvtiTransf.eResource().getURI();
        myQVT.dispose();
        myQVT = this.createQVT("SimplerKiama", this.getModelsURI("SimplerKiama/SimplerKiama.ocl"), "samples");
        ImperativeTransformation tx = this.getTransformation(myQVT.getMetamodelManager().getASResourceSet(), txURI);
        myQVT.executeModelsTX_Interpreted(tx, "model1");
        myQVT.executeModelsTX_Interpreted(tx, "model2");
        myQVT.executeModelsTX_Interpreted(tx, "model3");
        myQVT.dispose();
    }

    @Test
    public void testOCL2QVTi_BaseAndDerived_CG() throws Exception {
        MyQVT myQVT = this.createQVT("BaseAndDerived", this.getModelsURI("BaseAndDerived/Source2TargetBase.ocl"), "samples");
        try {
            myQVT.loadGenModels(new URI[]{this.getModelsURI("BaseAndDerived/SourceBaseMM.genmodel"), this.getModelsURI("BaseAndDerived/TargetBaseMM.genmodel")});
            ImperativeTransformation qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("Source2TargetBase.ocl", new String[0]);
            myQVT.assertRegionCount(RuleRegionImpl.class, NO_MERGES ? 9 : 5);
            CS2ASJavaCompilerParameters cgParams = this.createParameters("", "");
            java.lang.Class txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, qvtiTransf, cgParams);
            myQVT.executeModelsTX_CG(txClass, "model1");
            myQVT.dispose();
            myQVT = this.createQVT("BaseAndDerived", this.getModelsURI("BaseAndDerived/Source2TargetDerived.ocl"), "samples");
            myQVT.loadGenModels(new URI[]{this.getModelsURI("BaseAndDerived/SourceBaseMM.genmodel"), this.getModelsURI("BaseAndDerived/TargetBaseMM.genmodel"), this.getModelsURI("BaseAndDerived/SourceDerivedMM.genmodel"), this.getModelsURI("BaseAndDerived/TargetDerivedMM.genmodel")});
            qvtiTransf = myQVT.executeOCL2QVTi_CompilerChain("Source2TargetDerived.ocl", "Source2TargetBase.ocl");
            txClass = new CS2ASJavaCompilerImpl().compileTransformation((QVTimperative)myQVT, qvtiTransf, cgParams);
            myQVT.executeModelsTX_CG(txClass, "model2");
        }
        finally {
            myQVT.dispose();
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example5/sourceBaseMM/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example5/sourceDerivedMM/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example5/targetBaseMM/1.0");
            EPackage.Registry.INSTANCE.remove((Object)"http://cs2as/tests/example5/targetDerivedMM/1.0");
        }
    }

    @Test
    public void testOCL2QVTi_BaseAndDerived_Interpreted() throws Exception {
        MyQVT myQVT = this.createQVT("BaseAndDerived", this.getModelsURI("BaseAndDerived/Source2TargetBase.ocl"), "samples");
        myQVT.loadGenModels(new URI[]{this.getModelsURI("BaseAndDerived/SourceBaseMM.genmodel"), this.getModelsURI("BaseAndDerived/TargetBaseMM.genmodel")});
        ImperativeTransformation tx = myQVT.executeOCL2QVTi_CompilerChain("Source2TargetBase.ocl", new String[0]);
        myQVT.executeModelsTX_Interpreted(tx, "model1");
        myQVT.dispose();
        myQVT = this.createQVT("BaseAndDerived", this.getModelsURI("BaseAndDerived/Source2TargetBase.ocl"), "samples");
        myQVT.loadGenModels(new URI[]{this.getModelsURI("BaseAndDerived/SourceBaseMM.genmodel"), this.getModelsURI("BaseAndDerived/TargetBaseMM.genmodel"), this.getModelsURI("BaseAndDerived/SourceDerivedMM.genmodel"), this.getModelsURI("BaseAndDerived/TargetDerivedMM.genmodel")});
        tx = myQVT.executeOCL2QVTi_CompilerChain("Source2TargetDerived.ocl", "Source2TargetBase.ocl");
        myQVT.executeModelsTX_Interpreted(tx, "model2");
        myQVT.dispose();
    }

    protected static void assertValidModel(URI asURI, ResourceSet rSet) {
        Resource resource = rSet.getResource(asURI, true);
        EcoreUtil.resolveAll((Resource)resource);
        String rUriString = resource.getURI().toString();
        OCL2QVTiTestCases.assertNoUnresolvedProxies((String)("Validating a resource: " + rUriString), (Resource)resource);
        OCL2QVTiTestCases.assertNoResourceErrors((String)("Loading a resource" + rUriString), (Resource)resource);
    }

    protected static void assertValidQVTiModel(@NonNull URI asURI) {
    }

    protected @NonNull ImperativeTransformation getTransformation(ResourceSet rSet, URI qvtiURI) {
        Resource resource = rSet.getResource(qvtiURI, true);
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof ImperativeModel)) continue;
            for (Package pPackage : ((ImperativeModel)eObject).getOwnedPackages()) {
                for (Class pClass : pPackage.getOwnedClasses()) {
                    if (!(pClass instanceof ImperativeTransformation)) continue;
                    return (ImperativeTransformation)pClass;
                }
            }
        }
        throw new IllegalStateException("No transformation");
    }

    protected static @NonNull XtextResource pivot2cs(@NonNull OCL ocl, @NonNull ResourceSet resourceSet, @NonNull ASResource asResource, @NonNull URI outputURI) throws IOException {
        XtextResource xtextResource = (XtextResource)ClassUtil.nonNullState((Object)((XtextResource)resourceSet.createResource(outputURI, "org.eclipse.qvtd.xtext.qvtimperative")));
        ocl.as2cs(asResource, (CSResource)xtextResource);
        OCL2QVTiTestCases.assertNoResourceErrors((String)"Conversion failed", (Resource)xtextResource);
        OCL2QVTiTestCases.assertNoDiagnosticErrors((String)"Concrete Syntax validation failed", (XtextResource)xtextResource);
        try {
            xtextResource.save(DefaultCompilerOptions.defaultSavingOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
            URI xmiURI = outputURI.appendFileExtension(".xmi");
            Resource xmiResource = resourceSet.createResource(xmiURI);
            xmiResource.getContents().addAll((Collection)ClassUtil.nullFree((EList)xtextResource.getContents()));
            xmiResource.save(DefaultCompilerOptions.defaultSavingOptions);
            OCL2QVTiTestCases.fail((String)e.toString());
        }
        return xtextResource;
    }

    protected XtextResource doSerialize(@NonNull URI inputURI, @NonNull URI serializedURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        OCL ocl = QVTbase.newInstance((ProjectManager)this.getTestProjectManager());
        try {
            ASResource asResource = OCL2QVTiTestCases.loadQVTiAS(ocl, inputURI);
            OCL2QVTiTestCases.assertNoResourceErrors((String)"Normalisation failed", (Resource)asResource);
            OCL2QVTiTestCases.assertNoUnresolvedProxies((String)"Normalisation invalid", (Resource)asResource);
            OCL2QVTiTestCases.assertNoValidationErrors((String)"Normalisation invalid", (Resource)asResource);
            XtextResource xtextResource = OCL2QVTiTestCases.pivot2cs(ocl, (ResourceSet)resourceSet, asResource, serializedURI);
            resourceSet.getResources().clear();
            XtextResource xtextResource2 = xtextResource;
            return xtextResource2;
        }
        finally {
            ocl.dispose();
            ocl = null;
        }
    }

    protected static @NonNull ASResource loadQVTiAS(@NonNull OCL ocl, @NonNull URI inputURI) {
        Resource asResource = ocl.getMetamodelManager().getASResourceSet().getResource(inputURI, true);
        assert (asResource != null);
        OCL2QVTiTestCases.assertNoResourceErrors((String)"Load failed", (Resource)asResource);
        return (ASResource)asResource;
    }

    protected class MyQVT
    extends AbstractTestQVT {
        protected final @NonNull String modelTestName;
        protected final @NonNull String modelSamples;

        public MyQVT(@NonNull ProjectManager projectManager, @NonNull TestProject testProject, @NonNull URI testBundleURI, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull URI srcFileURI, @NonNull URI binFileURI, @NonNull String modelTestName, String modelSamples) throws IOException {
            super(projectManager, testProject, testBundleURI, txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI);
            this.modelTestName = modelTestName;
            this.modelSamples = modelSamples;
        }

        protected @NonNull AbstractCompilerChain createCompilerChain(@NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull CompilerOptions options) {
            try {
                return new OCL2QVTiCompilerChain((QVTimperative)this, (CompilerOptions)this.createCompilerOptions(), txURI, OCL2QVTiTestCases.this.getTestURIWithExtension(txURI, null), new URI[0]);
            }
            catch (CompilerChainException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }

        protected @NonNull DefaultCompilerOptions createCompilerOptions() {
            DefaultCompilerOptions options = super.createCompilerOptions();
            options.setOption("default", OCL2QVTiCompilerChain.SAVE_OPTIONS_KEY, (Object)DefaultCompilerOptions.defaultSavingOptions);
            options.setOption("default", OCL2QVTiCompilerChain.DEBUG_KEY, (Object)true);
            options.setOption("QVTs", CompilerChain.SCHEDULER_NO_EARLY_MERGE, (Object)NO_MERGES);
            options.setOption("QVTs", CompilerChain.SCHEDULER_NO_LATE_CONSUMER_MERGE, (Object)NO_MERGES);
            return options;
        }

        protected @NonNull ResourceSet createTestResourceSet() {
            return super.createTestResourceSet();
        }

        protected void executeModelsTX_CG(@NonNull java.lang.Class<? extends Transformer> txClass, @NonNull String modelName) throws Exception {
            String inputURIstring = String.valueOf(this.modelTestName) + "/" + this.modelSamples + "/" + modelName + "_input.xmi";
            String outURIstring = String.valueOf(modelName) + "_output_CG.xmi";
            String refURIstring = String.valueOf(this.modelTestName) + "/" + this.modelSamples + "/" + modelName + "_output_ref.xmi";
            this.createGeneratedExecutor(txClass);
            this.addInputURI("leftCS", OCL2QVTiTestCases.this.getModelsURI(inputURIstring));
            OCL2QVTiTestCases.assertTrue((boolean)this.executeTransformation());
            this.addOutputURI("rightAS", OCL2QVTiTestCases.this.getTestURI(outURIstring));
            this.saveModels(null);
            this.checkOutput(OCL2QVTiTestCases.this.getTestURI(outURIstring), OCL2QVTiTestCases.this.getModelsURI(refURIstring), null);
        }

        protected void executeModelsTX_Interpreted(@NonNull ImperativeTransformation tx, @NonNull String modelName) throws Exception {
            String inputURIstring = String.valueOf(this.modelTestName) + "/" + this.modelSamples + "/" + modelName + "_input.xmi";
            String outURIstring = String.valueOf(modelName) + "_output_Interpreted.xmi";
            String refURIstring = String.valueOf(this.modelTestName) + "/" + this.modelSamples + "/" + modelName + "_output_ref.xmi";
            this.createInterpretedExecutor(tx);
            this.addInputURI("leftCS", OCL2QVTiTestCases.this.getModelsURI(inputURIstring));
            OCL2QVTiTestCases.assertTrue((boolean)this.executeTransformation());
            this.addOutputURI("rightAS", OCL2QVTiTestCases.this.getTestURI(outURIstring));
            this.saveModels(null);
            this.checkOutput(OCL2QVTiTestCases.this.getTestURI(outURIstring), OCL2QVTiTestCases.this.getModelsURI(refURIstring), null);
        }

        protected @NonNull ImperativeTransformation executeOCL2QVTi_CompilerChain(@NonNull String mainOclDoc, String ... extendedOclDocs) throws Exception {
            URI mainOclDocURI = OCL2QVTiTestCases.this.getModelsURI(String.valueOf(this.modelTestName) + "/" + mainOclDoc);
            @NonNull URI[] oclDocURIs = new URI[extendedOclDocs.length];
            int i = 0;
            while (i < extendedOclDocs.length) {
                oclDocURIs[i] = OCL2QVTiTestCases.this.getModelsURI(String.valueOf(this.modelTestName) + "/" + extendedOclDocs[i]);
                ++i;
            }
            OCL2QVTiCompilerChain compiler = new OCL2QVTiCompilerChain((QVTimperative)this, (CompilerOptions)this.createCompilerOptions(), mainOclDocURI, OCL2QVTiTestCases.this.getTestURIWithExtension(mainOclDocURI, null), oclDocURIs){

                protected // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull AbstractCompilerChain.QVTm2QVTsCompilerStep createQVTm2QVTsCompilerStep() {
                    return new AbstractCompilerChain.QVTm2QVTsCompilerStep((CompilerChain)this){

                        public @NonNull ScheduleManager execute(@NonNull Resource pResource, @NonNull TypedModelsConfiguration typedModelsConfiguration) throws IOException {
                            ScheduleManager scheduleManager = super.execute(pResource, typedModelsConfiguration);
                            MyQVT.this.instrumentPartition(scheduleManager);
                            return scheduleManager;
                        }
                    };
                }
            };
            ImperativeTransformation qvtiTransf = compiler.compile("rightAS");
            URI txURI = qvtiTransf.eResource().getURI();
            if (txURI != null) {
                URI inputURI = txURI;
                URI serializedURI = OCL2QVTiTestCases.this.getTestURIWithExtension(inputURI, "serialized.qvti");
                this.doSerialize(inputURI, serializedURI);
            }
            return qvtiTransf;
        }

        protected @NonNull String getBasePrefix() {
            return "org.eclipse.qvtd.cs2as.compiler.tests";
        }

        protected @NonNull ProjectManager getTestProjectManager(@NonNull String pathFromCurrentWorkingDirectoryToFileSystem) throws Exception {
            return OCL2QVTiTestCases.this.getTestProjectManager(pathFromCurrentWorkingDirectoryToFileSystem);
        }
    }
}

