/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.runtime.blackbox;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.ProjectDependencyTracker;

public class ProjectClassLoader
extends URLClassLoader {
    private static Map<IJavaProject, ProjectClassLoader> loadersMap = new HashMap<IJavaProject, ProjectClassLoader>();

    ProjectClassLoader(IProject project) throws JavaModelException, MalformedURLException {
        this(JavaCore.create((IProject)project));
    }

    ProjectClassLoader(IJavaProject javaProject) throws JavaModelException, MalformedURLException {
        super(new URL[]{ProjectClassLoader.getProjectOutputURL(javaProject)}, ProjectClassLoader.getParentLoader(javaProject));
        loadersMap.put(javaProject, this);
    }

    static synchronized boolean isProjectClassLoaderExisting(IJavaProject javaProject) {
        return loadersMap.containsKey(javaProject);
    }

    static synchronized ProjectClassLoader getProjectClassLoader(IProject project) throws JavaModelException, MalformedURLException {
        return ProjectClassLoader.getProjectClassLoader(JavaCore.create((IProject)project));
    }

    static synchronized ProjectClassLoader getProjectClassLoader(IJavaProject javaProject) throws JavaModelException, MalformedURLException {
        ProjectClassLoader loader = loadersMap.get(javaProject);
        if (loader == null) {
            loader = new ProjectClassLoader(javaProject);
        }
        return loader;
    }

    static synchronized void resetProjectClassLoader(IJavaProject javaProject) {
        ProjectClassLoader loader = loadersMap.get(javaProject);
        if (loader != null) {
            try {
                Method closeMethod = loader.getClass().getMethod("close", new Class[0]);
                closeMethod.invoke((Object)loader, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof IOException) {
                    QvtPlugin.error((Throwable)e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            loadersMap.remove(javaProject);
        }
    }

    private static URL getProjectOutputURL(IJavaProject javaProject) throws JavaModelException, MalformedURLException {
        IPath projectRelativeOutputPath = javaProject.getOutputLocation().removeFirstSegments(1);
        IPath outputPath = javaProject.getProject().getLocation().append(projectRelativeOutputPath);
        return outputPath.addTrailingSeparator().toFile().toURI().toURL();
    }

    private static List<ClassLoader> getReferencedProjectLoaders(IJavaProject javaProject) {
        Set referencedProjects = ProjectDependencyTracker.getAllReferencedProjects((IProject)javaProject.getProject(), (boolean)false);
        ArrayList<ClassLoader> referencedLoaders = new ArrayList<ClassLoader>(referencedProjects.size());
        for (IProject referencedProject : referencedProjects) {
            try {
                referencedLoaders.add(ProjectClassLoader.getProjectClassLoader(referencedProject));
            }
            catch (JavaModelException e) {
                QvtPlugin.error((Throwable)e);
            }
            catch (MalformedURLException e) {
                QvtPlugin.error((Throwable)e);
            }
        }
        return referencedLoaders;
    }

    private static ClassLoader getParentLoader(IJavaProject javaProject) {
        List<ClassLoader> referencedLoaders = ProjectClassLoader.getReferencedProjectLoaders(javaProject);
        return referencedLoaders.isEmpty() ? ProjectClassLoader.class.getClassLoader() : new CompositeClassLoader(referencedLoaders);
    }

    private static class CompositeClassLoader
    extends ClassLoader {
        private List<? extends ClassLoader> composedLoaders;

        public CompositeClassLoader(List<? extends ClassLoader> composedLoaders) {
            this.composedLoaders = composedLoaders;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            for (ClassLoader classLoader : this.composedLoaders) {
                try {
                    Class<?> c = classLoader.loadClass(name);
                    return c;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException(name);
        }
    }
}

