/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.TransformationRunner;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.WorkspaceMetamodelProvider;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationRunnerFactory {
    public String transformationURI;
    public List<String> modelParamURI;
    public String traceFileURI;
    public boolean isSaveTrace;
    public boolean isIncrementalUpdate;
    public EPackage.Registry packageRegistry;
    private ResourceSet mmapingsRs;

    public TransformationRunner createRunner() throws DiagnosticException {
        BasicDiagnostic diagnostic = QvtPlugin.createDiagnostic((String)"Transformation runner problems");
        URI uri = null;
        try {
            uri = this.toURI(this.transformationURI, "transformation");
        }
        catch (DiagnosticException e) {
            diagnostic.add(e.getDiagnostic());
        }
        ArrayList<URI> paramURIs = new ArrayList<URI>();
        if (this.modelParamURI != null) {
            for (String paramURIStr : this.modelParamURI) {
                try {
                    paramURIs.add(this.toURI(paramURIStr, "model parameter"));
                }
                catch (DiagnosticException e) {
                    diagnostic.add(e.getDiagnostic());
                }
            }
        } else {
            diagnostic.add(QvtPlugin.createErrorDiagnostic((String)"No model parameters passed to transformation", null));
        }
        if (diagnostic.getSeverity() == 4) {
            throw new DiagnosticException((Diagnostic)diagnostic);
        }
        TransformationRunner runner = this.createRunner(uri, this.packageRegistry, paramURIs);
        runner.setIncrementalUpdate(this.isIncrementalUpdate);
        runner.setSaveTrace(this.isSaveTrace);
        if (this.traceFileURI != null) {
            try {
                runner.setTraceFile(this.toURI(this.traceFileURI, "trace file"));
            }
            catch (DiagnosticException e) {
                diagnostic.add(e.getDiagnostic());
            }
        }
        return runner;
    }

    protected TransformationRunner createRunner(URI transformationURI, EPackage.Registry packageRegistry, List<URI> modelParamURIs) {
        return new TransformationRunner(transformationURI, packageRegistry, modelParamURIs);
    }

    public void addMetamodelMapping(String nsURI, String uriLocation) {
        if (this.mmapingsRs == null) {
            this.mmapingsRs = new ResourceSetImpl();
            this.packageRegistry = this.mmapingsRs.getPackageRegistry();
        }
        try {
            EPackage metamodel = WorkspaceMetamodelProvider.loadResourceMetamodel((String)uriLocation, (ResourceSet)this.mmapingsRs);
            this.packageRegistry.put((Object)nsURI, (Object)metamodel);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed metamodel mapping location", e);
        }
    }

    private URI toURI(String uriStr, String uriType) throws DiagnosticException {
        IllegalArgumentException exc = null;
        if (uriStr != null) {
            try {
                return URI.createURI((String)uriStr, (boolean)true);
            }
            catch (IllegalArgumentException e) {
                exc = e;
            }
        }
        String message = NLS.bind((String)"Invalid {0} URI : ''{1}''", (Object)uriType, (Object)uriStr);
        throw new DiagnosticException(QvtPlugin.createErrorDiagnostic((String)message, (Throwable)exc));
    }
}

