/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.policy;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.compare.ide.EMFCompareIDEPlugin;
import org.eclipse.emf.compare.ide.policy.ILoadOnDemandPolicy;
import org.eclipse.emf.compare.ide.utils.AbstractRegistryEventListener;

public class LoadOnDemandPolicyRegistryListener
extends AbstractRegistryEventListener {
    static final String TAG_POLICY = "policy";
    static final String ATT_CLASS = "class";
    private final ILoadOnDemandPolicy.Registry registry;

    public LoadOnDemandPolicyRegistryListener(ILoadOnDemandPolicy.Registry registry, String pluginID, String extensionPointID) {
        super(pluginID, extensionPointID);
        this.registry = registry;
    }

    protected boolean readElement(IConfigurationElement element, AbstractRegistryEventListener.Action action) {
        if (element.getName().equals(TAG_POLICY)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                switch (action) {
                    case ADD: {
                        try {
                            ILoadOnDemandPolicy policy = (ILoadOnDemandPolicy)element.createExecutableExtension(ATT_CLASS);
                            ILoadOnDemandPolicy previous = this.registry.addPolicy(policy);
                            if (previous == null) break;
                            EMFCompareIDEPlugin.getDefault().log(2, "The factory '" + policy.getClass().getName() + "' is registered twice.");
                        }
                        catch (CoreException e) {
                            this.logError(element, e.getMessage());
                        }
                        break;
                    }
                    case REMOVE: {
                        this.registry.removePolicy(element.getAttribute(ATT_CLASS));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported case " + (Object)((Object)action));
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected void logError(IConfigurationElement element, String string) {
        EMFCompareIDEPlugin.getDefault().log(4, string);
    }
}

