/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDiffEngine
implements IDiffEngine {
    protected static final Object UNMATCHED_VALUE = new Object();
    private IDiffProcessor diffProcessor;

    public DefaultDiffEngine(IDiffProcessor processor) {
        this.diffProcessor = processor;
    }

    protected <E> Predicate<E> containedIn(final Comparison comparison, final Iterable<E> iterable) {
        return new Predicate<E>(){

            public boolean apply(E input) {
                return DefaultDiffEngine.this.contains(comparison, iterable, input);
            }
        };
    }

    protected <E> boolean contains(Comparison comparison, Iterable<E> iterable, E element) {
        for (E candidate : iterable) {
            if (!comparison.getEqualityHelper().matchingValues(candidate, element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void diff(Comparison comparison, Monitor monitor) {
        for (Match rootMatch : comparison.getMatches()) {
            this.checkResourceAttachment(rootMatch, monitor);
            this.checkForDifferences(rootMatch, monitor);
        }
    }

    protected void checkForDifferences(Match match, Monitor monitor) {
        FeatureFilter featureFilter = this.createFeatureFilter();
        Iterator<EReference> references = featureFilter.getReferencesToCheck(match);
        while (references.hasNext()) {
            EReference reference = references.next();
            boolean considerOrdering = featureFilter.checkForOrderingChanges((EStructuralFeature)reference);
            this.computeDifferences(match, reference, considerOrdering);
        }
        Iterator<EAttribute> attributes = featureFilter.getAttributesToCheck(match);
        while (attributes.hasNext()) {
            EAttribute attribute = attributes.next();
            boolean considerOrdering = featureFilter.checkForOrderingChanges((EStructuralFeature)attribute);
            this.computeDifferences(match, attribute, considerOrdering);
        }
        for (Match submatch : match.getSubmatches()) {
            this.checkForDifferences(submatch, monitor);
        }
    }

    protected void checkResourceAttachment(Match match, Monitor monitor) {
        Comparison comparison = match.getComparison();
        if (comparison.getMatchedResources().isEmpty()) {
            return;
        }
        if (match.getLeft() == null && match.getRight() == null) {
            String uri = match.getOrigin().eResource().getURI().toString();
            this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.DELETE, DifferenceSource.LEFT);
            this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.DELETE, DifferenceSource.RIGHT);
        } else if (match.getLeft() == null || match.getRight() == null) {
            if (comparison.isThreeWay() && match.getLeft() == null) {
                String uri = match.getOrigin().eResource().getURI().toString();
                this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.DELETE, DifferenceSource.LEFT);
            } else if (comparison.isThreeWay()) {
                if (match.getOrigin() != null) {
                    String uri = match.getOrigin().eResource().getURI().toString();
                    this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.DELETE, DifferenceSource.RIGHT);
                } else {
                    String uri = match.getLeft().eResource().getURI().toString();
                    this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.ADD, DifferenceSource.LEFT);
                }
            } else if (match.getLeft() == null) {
                String uri = match.getRight().eResource().getURI().toString();
                this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.DELETE, DifferenceSource.LEFT);
            } else {
                String uri = match.getLeft().eResource().getURI().toString();
                this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.ADD, DifferenceSource.LEFT);
            }
        }
    }

    protected void computeContainmentDifferencesThreeWay(Match match, EReference reference, boolean checkOrdering) {
        Match candidateMatch;
        Comparison comparison = match.getComparison();
        List<Object> leftValues = ReferenceUtil.getAsList(match.getLeft(), (EStructuralFeature)reference);
        List<Object> rightValues = ReferenceUtil.getAsList(match.getRight(), (EStructuralFeature)reference);
        List<Object> originValues = ReferenceUtil.getAsList(match.getOrigin(), (EStructuralFeature)reference);
        List<Object> lcsOriginLeft = DiffUtil.longestCommonSubsequence(comparison, originValues, leftValues);
        List<Object> lcsOriginRight = DiffUtil.longestCommonSubsequence(comparison, originValues, rightValues);
        Iterable changedLeft = Iterables.filter(leftValues, (Predicate)Predicates.not(this.containedIn(comparison, lcsOriginLeft)));
        Iterable changedRight = Iterables.filter(rightValues, (Predicate)Predicates.not(this.containedIn(comparison, lcsOriginRight)));
        for (Object t : changedLeft) {
            candidateMatch = comparison.getMatch((EObject)t);
            if (this.contains(comparison, originValues, t)) {
                if (!checkOrdering) continue;
                this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            if (candidateMatch != null && candidateMatch.getOrigin() != null) {
                this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.ADD, DifferenceSource.LEFT);
        }
        for (Object t : changedRight) {
            candidateMatch = comparison.getMatch((EObject)t);
            if (this.contains(comparison, originValues, t)) {
                if (!checkOrdering) continue;
                this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.MOVE, DifferenceSource.RIGHT);
                continue;
            }
            if (candidateMatch != null && candidateMatch.getOrigin() != null) {
                this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.MOVE, DifferenceSource.RIGHT);
                continue;
            }
            this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.ADD, DifferenceSource.RIGHT);
        }
        for (Object object : originValues) {
            candidateMatch = comparison.getMatch((EObject)object);
            if (candidateMatch == null) continue;
            if (candidateMatch.getLeft() == null) {
                this.featureChange(match, (EStructuralFeature)reference, object, DifferenceKind.DELETE, DifferenceSource.LEFT);
            }
            if (candidateMatch.getRight() != null) continue;
            this.featureChange(match, (EStructuralFeature)reference, object, DifferenceKind.DELETE, DifferenceSource.RIGHT);
        }
    }

    protected void computeContainmentDifferencesTwoWay(Match match, EReference reference, boolean checkOrdering) {
        Match candidateMatch;
        Comparison comparison = match.getComparison();
        List<Object> leftValues = ReferenceUtil.getAsList(match.getLeft(), (EStructuralFeature)reference);
        List<Object> rightValues = ReferenceUtil.getAsList(match.getRight(), (EStructuralFeature)reference);
        List<Object> lcs = DiffUtil.longestCommonSubsequence(comparison, rightValues, leftValues);
        Iterable changed = Iterables.filter(leftValues, (Predicate)Predicates.not(this.containedIn(comparison, lcs)));
        for (Object t : changed) {
            candidateMatch = comparison.getMatch((EObject)t);
            if (this.contains(comparison, rightValues, t)) {
                if (!checkOrdering) continue;
                this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            if (candidateMatch != null && candidateMatch.getRight() != null) {
                this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            this.featureChange(match, (EStructuralFeature)reference, t, DifferenceKind.ADD, DifferenceSource.LEFT);
        }
        for (Object object : rightValues) {
            candidateMatch = comparison.getMatch((EObject)object);
            if (candidateMatch == null || candidateMatch.getLeft() != null) continue;
            this.featureChange(match, (EStructuralFeature)reference, object, DifferenceKind.DELETE, DifferenceSource.LEFT);
        }
    }

    protected void computeDifferences(Match match, EAttribute attribute, boolean checkOrdering) {
        Comparison comparison = match.getComparison();
        boolean shortcut = false;
        if (comparison.isThreeWay()) {
            shortcut = match.getOrigin() == null;
        } else {
            boolean bl = shortcut = match.getLeft() == null || match.getRight() == null;
        }
        if (shortcut) {
            return;
        }
        if (attribute.isMany()) {
            if (comparison.isThreeWay()) {
                this.computeMultiValuedFeatureDifferencesThreeWay(match, (EStructuralFeature)attribute, checkOrdering);
            } else {
                this.computeMultiValuedFeatureDifferencesTwoWay(match, (EStructuralFeature)attribute, checkOrdering);
            }
        } else {
            this.computeSingleValuedAttributeDifferences(match, attribute);
        }
    }

    protected void computeDifferences(Match match, EReference reference, boolean checkOrdering) {
        Comparison comparison = match.getComparison();
        if (reference.isContainment()) {
            if (comparison.isThreeWay()) {
                this.computeContainmentDifferencesThreeWay(match, reference, checkOrdering);
            } else {
                this.computeContainmentDifferencesTwoWay(match, reference, checkOrdering);
            }
        } else if (reference.isMany()) {
            if (comparison.isThreeWay()) {
                this.computeMultiValuedFeatureDifferencesThreeWay(match, (EStructuralFeature)reference, checkOrdering);
            } else {
                this.computeMultiValuedFeatureDifferencesTwoWay(match, (EStructuralFeature)reference, checkOrdering);
            }
        } else if (comparison.isThreeWay()) {
            this.computeSingleValuedReferenceDifferencesThreeWay(match, reference);
        } else {
            this.computeSingleValuedReferenceDifferencesTwoWay(match, reference);
        }
    }

    protected void computeMultiValuedFeatureDifferencesThreeWay(Match match, EStructuralFeature feature, boolean checkOrdering) {
        Comparison comparison = match.getComparison();
        List<Object> leftValues = ReferenceUtil.getAsList(match.getLeft(), feature);
        List<Object> rightValues = ReferenceUtil.getAsList(match.getRight(), feature);
        List<Object> originValues = ReferenceUtil.getAsList(match.getOrigin(), feature);
        List<Object> lcsOriginLeft = DiffUtil.longestCommonSubsequence(comparison, originValues, leftValues);
        List<Object> lcsOriginRight = DiffUtil.longestCommonSubsequence(comparison, originValues, rightValues);
        Iterable changedLeft = Iterables.filter(leftValues, (Predicate)Predicates.not(this.containedIn(comparison, lcsOriginLeft)));
        Iterable changedRight = Iterables.filter(rightValues, (Predicate)Predicates.not(this.containedIn(comparison, lcsOriginRight)));
        for (Object t : changedLeft) {
            if (this.contains(comparison, originValues, t)) {
                if (!checkOrdering) continue;
                this.featureChange(match, feature, t, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            this.featureChange(match, feature, t, DifferenceKind.ADD, DifferenceSource.LEFT);
        }
        for (Object t : changedRight) {
            if (this.contains(comparison, originValues, t)) {
                if (!checkOrdering) continue;
                this.featureChange(match, feature, t, DifferenceKind.MOVE, DifferenceSource.RIGHT);
                continue;
            }
            this.featureChange(match, feature, t, DifferenceKind.ADD, DifferenceSource.RIGHT);
        }
        for (Object object : originValues) {
            if (!this.contains(comparison, leftValues, object) && (feature instanceof EReference || match.getLeft() != null)) {
                this.featureChange(match, feature, object, DifferenceKind.DELETE, DifferenceSource.LEFT);
            }
            if (this.contains(comparison, rightValues, object) || !(feature instanceof EReference) && match.getRight() == null) continue;
            this.featureChange(match, feature, object, DifferenceKind.DELETE, DifferenceSource.RIGHT);
        }
    }

    protected void computeMultiValuedFeatureDifferencesTwoWay(Match match, EStructuralFeature feature, boolean checkOrdering) {
        Comparison comparison = match.getComparison();
        List<Object> leftValues = ReferenceUtil.getAsList(match.getLeft(), feature);
        List<Object> rightValues = ReferenceUtil.getAsList(match.getRight(), feature);
        List<Object> lcs = DiffUtil.longestCommonSubsequence(comparison, rightValues, leftValues);
        Iterable changed = Iterables.filter(leftValues, (Predicate)Predicates.not(this.containedIn(comparison, lcs)));
        for (Object t : changed) {
            if (this.contains(comparison, rightValues, t)) {
                if (!checkOrdering) continue;
                this.featureChange(match, feature, t, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            this.featureChange(match, feature, t, DifferenceKind.ADD, DifferenceSource.LEFT);
        }
        for (Object object : rightValues) {
            if (this.contains(comparison, leftValues, object) || !(feature instanceof EReference) && match.getLeft() == null) continue;
            this.featureChange(match, feature, object, DifferenceKind.DELETE, DifferenceSource.LEFT);
        }
    }

    protected void computeSingleValuedAttributeDifferences(Match match, EAttribute attribute) {
        IEqualityHelper helper;
        Comparison comparison = match.getComparison();
        Object leftValue = UNMATCHED_VALUE;
        if (match.getLeft() != null) {
            leftValue = ReferenceUtil.safeEGet(match.getLeft(), (EStructuralFeature)attribute);
        }
        Object rightValue = UNMATCHED_VALUE;
        if (match.getRight() != null) {
            rightValue = ReferenceUtil.safeEGet(match.getRight(), (EStructuralFeature)attribute);
        }
        if ((helper = comparison.getEqualityHelper()).matchingValues(leftValue, rightValue)) {
            if (leftValue != UNMATCHED_VALUE && comparison.isThreeWay()) {
                Object originValue = match.getOrigin() == null ? null : ReferenceUtil.safeEGet(match.getOrigin(), (EStructuralFeature)attribute);
                boolean matchingLO = helper.matchingValues(leftValue, originValue);
                if (!matchingLO && this.isNullOrEmptyString(originValue)) {
                    this.getDiffProcessor().attributeChange(match, attribute, leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                    this.getDiffProcessor().attributeChange(match, attribute, rightValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                } else if (!matchingLO) {
                    this.getDiffProcessor().attributeChange(match, attribute, originValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                    this.getDiffProcessor().attributeChange(match, attribute, originValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            }
        } else if (match.getOrigin() != null) {
            Object originValue = ReferenceUtil.safeEGet(match.getOrigin(), (EStructuralFeature)attribute);
            if (helper.matchingValues(leftValue, originValue)) {
                Object changedValue = rightValue;
                if (this.isNullOrEmptyString(rightValue)) {
                    changedValue = originValue;
                }
                if (rightValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, changedValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            } else if (helper.matchingValues(rightValue, originValue)) {
                Object changedValue = leftValue;
                if (this.isNullOrEmptyString(leftValue)) {
                    changedValue = originValue;
                }
                if (leftValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, changedValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                }
            } else {
                Object leftChange = leftValue;
                if (this.isNullOrEmptyString(leftValue)) {
                    leftChange = originValue;
                }
                Object rightChange = rightValue;
                if (this.isNullOrEmptyString(rightValue)) {
                    rightChange = originValue;
                }
                if (leftValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, leftChange, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                }
                if (rightValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, rightChange, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            }
        } else {
            if (leftValue != UNMATCHED_VALUE) {
                if (this.isNullOrEmptyString(leftValue)) {
                    this.getDiffProcessor().attributeChange(match, attribute, rightValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                } else {
                    this.getDiffProcessor().attributeChange(match, attribute, leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                }
            }
            if (comparison.isThreeWay() && rightValue != UNMATCHED_VALUE) {
                if (this.isNullOrEmptyString(rightValue)) {
                    this.getDiffProcessor().attributeChange(match, attribute, leftValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                } else {
                    this.getDiffProcessor().attributeChange(match, attribute, rightValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            }
        }
    }

    private boolean isNullOrEmptyString(Object object) {
        return object == null || object instanceof String && ((String)object).length() == 0;
    }

    private boolean isNullOrUnmatched(Object object) {
        return object == null || object == UNMATCHED_VALUE;
    }

    protected void computeSingleValuedReferenceDifferencesThreeWay(Match match, EReference reference) {
        Comparison comparison = match.getComparison();
        Object leftValue = UNMATCHED_VALUE;
        if (match.getLeft() != null) {
            leftValue = ReferenceUtil.safeEGet(match.getLeft(), (EStructuralFeature)reference);
        }
        Object rightValue = UNMATCHED_VALUE;
        if (match.getRight() != null) {
            rightValue = ReferenceUtil.safeEGet(match.getRight(), (EStructuralFeature)reference);
        }
        Object originValue = UNMATCHED_VALUE;
        if (match.getOrigin() != null) {
            originValue = ReferenceUtil.safeEGet(match.getOrigin(), (EStructuralFeature)reference);
        }
        boolean distinctValueLO = !comparison.getEqualityHelper().matchingValues(leftValue, originValue);
        boolean bl = distinctValueLO = distinctValueLO && (!this.isNullOrUnmatched(leftValue) || !this.isNullOrUnmatched(originValue));
        if (distinctValueLO) {
            if (leftValue == null || leftValue == UNMATCHED_VALUE) {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)originValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            } else {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            }
        }
        boolean distinctValueRO = !comparison.getEqualityHelper().matchingValues(rightValue, originValue);
        boolean bl2 = distinctValueRO = distinctValueRO && (!this.isNullOrUnmatched(rightValue) || !this.isNullOrUnmatched(originValue));
        if (distinctValueRO) {
            if (rightValue == null || rightValue == UNMATCHED_VALUE) {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)originValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
            } else {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)rightValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
            }
        }
    }

    protected void computeSingleValuedReferenceDifferencesTwoWay(Match match, EReference reference) {
        Comparison comparison = match.getComparison();
        Object leftValue = UNMATCHED_VALUE;
        if (match.getLeft() != null) {
            leftValue = ReferenceUtil.safeEGet(match.getLeft(), (EStructuralFeature)reference);
        }
        Object rightValue = UNMATCHED_VALUE;
        if (match.getRight() != null) {
            rightValue = ReferenceUtil.safeEGet(match.getRight(), (EStructuralFeature)reference);
        }
        boolean distinctValue = !comparison.getEqualityHelper().matchingValues(leftValue, rightValue);
        boolean bl = distinctValue = distinctValue && (!this.isNullOrUnmatched(leftValue) || !this.isNullOrUnmatched(rightValue));
        if (distinctValue) {
            if (leftValue == null || leftValue == UNMATCHED_VALUE) {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)rightValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            } else {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            }
        }
    }

    protected FeatureFilter createFeatureFilter() {
        return new FeatureFilter();
    }

    protected void featureChange(Match match, EStructuralFeature feature, Object value, DifferenceKind kind, DifferenceSource source) {
        if (feature instanceof EAttribute) {
            this.getDiffProcessor().attributeChange(match, (EAttribute)feature, value, kind, source);
        } else if (value instanceof EObject) {
            this.getDiffProcessor().referenceChange(match, (EReference)feature, (EObject)value, kind, source);
        }
    }

    protected final IDiffProcessor getDiffProcessor() {
        return this.diffProcessor;
    }
}

