/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ReflectiveWeightProvider
implements WeightProvider {
    private Map<EStructuralFeature, Integer> weights = Maps.newHashMap();
    private Set<EStructuralFeature> toBeIgnored = Sets.newLinkedHashSet();

    public int getWeight(EStructuralFeature feature) {
        if (this.irrelevant(feature) || this.toBeIgnored.contains(feature)) {
            return 0;
        }
        Integer found = this.weights.get(feature);
        if (found == null) {
            found = "name".equals(feature.getName()) ? Integer.valueOf(4) : Integer.valueOf(1);
        }
        return found;
    }

    protected boolean irrelevant(EStructuralFeature feat) {
        boolean irrelevantFeature;
        boolean bl = irrelevantFeature = feat.isDerived() || feat.isTransient();
        if (!irrelevantFeature && feat instanceof EReference) {
            EReference ref = (EReference)feat;
            irrelevantFeature = ref.isContainment() || ref.isContainer();
        }
        return irrelevantFeature;
    }
}

