/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.InsertionPoint;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.MatchedObject;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.MergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor.BasicStructuralFeatureAccessorImpl;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleStructuralFeatureAccessorImpl
extends BasicStructuralFeatureAccessorImpl {
    public SingleStructuralFeatureAccessorImpl(Diff diff, MergeViewer.MergeViewerSide side) {
        super(diff, side);
    }

    @Override
    public ImmutableList<? extends IMergeViewerItem> getItems() {
        ImmutableList ret;
        Object thisSideValue = this.getValue(this.getSide());
        if (thisSideValue == null && this.getSide() == MergeViewer.MergeViewerSide.ANCESTOR) {
            return ImmutableList.of();
        }
        Object leftValue = this.getValue(MergeViewer.MergeViewerSide.LEFT);
        Object rightValue = this.getValue(MergeViewer.MergeViewerSide.RIGHT);
        Object ancestorValue = this.getValue(MergeViewer.MergeViewerSide.ANCESTOR);
        Diff diff = (Diff)Iterables.getFirst(this.getDifferences(), null);
        if (thisSideValue == null) {
            InsertionPoint insertionPoint = new InsertionPoint(diff, leftValue, rightValue, ancestorValue);
            ret = ImmutableList.of((Object)insertionPoint);
        } else {
            MatchedObject matchedObject = new MatchedObject(diff, leftValue, rightValue, ancestorValue);
            ret = ImmutableList.of((Object)matchedObject);
        }
        return ret;
    }

    private Object getValue(MergeViewer.MergeViewerSide side) {
        Object value = null;
        EObject eObject = this.getEObject(side);
        if (eObject != null) {
            value = ReferenceUtil.safeEGet((EObject)eObject, (EStructuralFeature)this.getStructuralFeature());
        }
        return value;
    }
}

