/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDifferenceGroupImpl
implements IDifferenceGroup {
    protected final Iterable<? extends Diff> candidates;
    protected final Predicate<? super Diff> filter;
    protected final String name;
    protected final Image image;
    protected final Comparison comparison;
    private static final Predicate<Diff> unresolved = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return DifferenceState.UNRESOLVED == input.getState();
        }
    };

    public BasicDifferenceGroupImpl(Comparison comparison, Iterable<? extends Diff> unfiltered, Predicate<? super Diff> filter) {
        this(comparison, unfiltered, filter, "Group", null);
    }

    public BasicDifferenceGroupImpl(Comparison comparison, Iterable<? extends Diff> unfiltered, Predicate<? super Diff> filter, String name) {
        this(comparison, unfiltered, filter, name, null);
    }

    public BasicDifferenceGroupImpl(Comparison comparison, Iterable<? extends Diff> unfiltered, Predicate<? super Diff> filter, String name, Image image) {
        this.comparison = comparison;
        this.candidates = unfiltered;
        this.filter = filter;
        this.name = name;
        this.image = image;
    }

    @Override
    public Iterable<? extends Diff> getDifferences() {
        return Iterables.filter(this.candidates, this.filter);
    }

    @Override
    public Comparison getComparison() {
        return this.comparison;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IStyledString.IComposedStyledString getStyledName() {
        ComposedStyledString ret = new ComposedStyledString(this.getName());
        int unresolvedDiffs = Iterables.size((Iterable)Iterables.filter(this.getDifferences(), unresolved));
        ret.append(" [" + unresolvedDiffs + " unresolved difference", IStyledString.Style.DECORATIONS_STYLER);
        if (unresolvedDiffs > 1) {
            ret.append("s", IStyledString.Style.DECORATIONS_STYLER);
        }
        ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return ret;
    }

    @Override
    public Image getImage() {
        return this.image;
    }
}

