/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.factory.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.factory.IAccessorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorFactoryRegistryImpl
implements IAccessorFactory.Registry {
    private final Map<String, IAccessorFactory> map = new ConcurrentHashMap<String, IAccessorFactory>();

    @Override
    public IAccessorFactory getHighestRankingFactory(Object target) {
        Iterator factories = this.getFactories(target).iterator();
        IAccessorFactory ret = null;
        if (factories.hasNext()) {
            IAccessorFactory highestRanking = (IAccessorFactory)factories.next();
            while (factories.hasNext()) {
                IAccessorFactory factory = (IAccessorFactory)factories.next();
                if (factory.getRanking() <= highestRanking.getRanking()) continue;
                highestRanking = factory;
            }
            ret = highestRanking;
        }
        return ret;
    }

    public List<IAccessorFactory> getFactories(Object target) {
        Iterable factories = Iterables.filter(this.map.values(), AccessorFactoryRegistryImpl.isFactoryFor(target));
        ArrayList ret = Lists.newArrayList();
        for (IAccessorFactory factory : factories) {
            ret.add(factory);
        }
        return ret;
    }

    static final Predicate<IAccessorFactory> isFactoryFor(final Object target) {
        return new Predicate<IAccessorFactory>(){

            public boolean apply(IAccessorFactory d) {
                return d.isFactoryFor(target);
            }
        };
    }

    @Override
    public IAccessorFactory add(IAccessorFactory factory) {
        Preconditions.checkNotNull((Object)factory);
        return this.map.put(factory.getClass().getName(), factory);
    }

    @Override
    public IAccessorFactory remove(String className) {
        return this.map.remove(className);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

