/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareColorImpl
implements RemovalListener<RGB, Color>,
ICompareColor {
    private static final int MIN_RGB_COMPONENT = 0;
    private static final int MAX_RGB_COMPONENT = 255;
    private static final int MAX_CACHE_SIZE = 16;
    private static final int MED_RGB_COMPONENT = 128;
    private static final double INTERPOLATION_SCALE_1 = 0.6;
    private static final double INTERPOLATION_SCALE_2 = 0.97;
    private static final double DARKER_BORDER_SCALE_FACTOR = -0.5;
    public static final String INCOMING_CHANGE_COLOR_THEME_KEY = "org.eclipse.emf.compare.incomingChangeColor";
    public static final String CONFLICTING_CHANGE_COLOR_THEME_KEY = "org.eclipse.emf.compare.conflictingChangeColor";
    public static final String OUTGOING_CHANGE_COLOR_THEME_KEY = "org.eclipse.emf.compare.outgoingChangeColor";
    public static final String REQUIRED_DIFF_COLOR_THEME_KEY = "org.eclipse.emf.compare.requiredChangeColor";
    public static final String UNMERGEABLE_DIFF_COLOR_THEME_KEY = "org.eclipse.emf.compare.unmergeableChangeColor";
    private final LoadingCache<RGB, Color> fColors;
    private final Display fDisplay;
    private final ColorRegistry fColorRegistry;
    private final boolean fLeftIsLocal;
    private RGB incomingSelected;
    private RGB incoming;
    private RGB incomingFill;
    private RGB conflictSelected;
    private RGB conflict;
    private RGB conflictFill;
    private RGB outgoingSelected;
    private RGB outgoing;
    private RGB outgoingFill;
    private RGB requiredColor;
    private RGB requiredBorderColor;
    private RGB unmergeableColor;
    private RGB unmergeableBorderColor;

    public CompareColorImpl(Display fDisplay, boolean leftIsLocal, ColorRegistry colorRegistry) {
        this.fDisplay = fDisplay;
        this.fLeftIsLocal = leftIsLocal;
        this.fColors = CacheBuilder.newBuilder().maximumSize(16L).removalListener((RemovalListener)this).build((CacheLoader)new CacheLoader<RGB, Color>(){

            public Color load(RGB rgb) throws Exception {
                return new Color((Device)CompareColorImpl.this.fDisplay, rgb);
            }
        });
        this.fColorRegistry = colorRegistry;
        this.updateColors();
    }

    public final void onRemoval(RemovalNotification<RGB, Color> notification) {
        Color color = (Color)notification.getValue();
        if (!color.isDisposed()) {
            color.dispose();
        }
    }

    private Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        return (Color)this.fColors.getUnchecked((Object)rgb);
    }

    @Override
    public Color getFillColor(Diff diff, boolean isThreeWay, boolean isIgnoreAncestor, boolean selected) {
        return this.getColor(this.getFillRGB(diff, isThreeWay, isIgnoreAncestor, selected));
    }

    private RGB getFillRGB(Diff diff, boolean isThreeWay, boolean isIgnoreAncestor, boolean selected) {
        RGB selectedFill = this.getBackground();
        if (isThreeWay && !isIgnoreAncestor) {
            boolean requiredConflictForWayOfMerge = false;
            if (diff.getConflict() == null && !requiredConflictForWayOfMerge) {
                switch (diff.getSource()) {
                    case RIGHT: {
                        if (this.fLeftIsLocal) {
                            return selected ? selectedFill : this.incomingFill;
                        }
                        return selected ? selectedFill : this.outgoingFill;
                    }
                    case LEFT: {
                        if (this.fLeftIsLocal) {
                            return selected ? selectedFill : this.outgoingFill;
                        }
                        return selected ? selectedFill : this.incomingFill;
                    }
                }
            } else {
                return selected ? selectedFill : this.conflictFill;
            }
            return selected ? selectedFill : this.conflictFill;
        }
        return selected ? selectedFill : this.outgoingFill;
    }

    @Override
    public Color getStrokeColor(Diff diff, boolean isThreeWay, boolean isIgnoreAncestor, boolean selected) {
        return this.getColor(this.getStrokeRGB(diff, isThreeWay, isIgnoreAncestor, selected));
    }

    private RGB getStrokeRGB(Diff diff, boolean isThreeWay, boolean isIgnoreAncestor, boolean selected) {
        if (isThreeWay && !isIgnoreAncestor) {
            boolean requiredConflictForWayOfMerge = false;
            if (diff != null && diff.getConflict() == null && !requiredConflictForWayOfMerge) {
                switch (diff.getSource()) {
                    case RIGHT: {
                        if (this.fLeftIsLocal) {
                            return selected ? this.incomingSelected : this.incoming;
                        }
                        return selected ? this.outgoingSelected : this.outgoing;
                    }
                    case LEFT: {
                        if (this.fLeftIsLocal) {
                            return selected ? this.outgoingSelected : this.outgoing;
                        }
                        return selected ? this.incomingSelected : this.incoming;
                    }
                }
            } else {
                return selected ? this.conflictSelected : this.conflict;
            }
            return selected ? this.conflictSelected : this.conflict;
        }
        return selected ? this.outgoingSelected : this.outgoing;
    }

    protected final void updateColors() {
        RGB background = this.getBackground();
        this.unmergeableColor = this.fColorRegistry.getRGB(UNMERGEABLE_DIFF_COLOR_THEME_KEY);
        if (this.unmergeableColor == null) {
            this.unmergeableColor = new RGB(255, 205, 180);
        }
        this.unmergeableBorderColor = CompareColorImpl.interpolate(this.unmergeableColor, background, -0.5);
        this.requiredColor = this.fColorRegistry.getRGB(REQUIRED_DIFF_COLOR_THEME_KEY);
        if (this.requiredColor == null) {
            this.requiredColor = new RGB(215, 255, 200);
        }
        this.requiredBorderColor = CompareColorImpl.interpolate(this.requiredColor, background, -0.5);
        this.conflictSelected = this.fColorRegistry.getRGB(CONFLICTING_CHANGE_COLOR_THEME_KEY);
        if (this.conflictSelected == null) {
            this.conflictSelected = new RGB(255, 0, 0);
        }
        this.conflict = CompareColorImpl.interpolate(this.conflictSelected, background, 0.6);
        this.conflictFill = CompareColorImpl.interpolate(this.conflictSelected, background, 0.97);
        this.outgoingSelected = this.fColorRegistry.getRGB(OUTGOING_CHANGE_COLOR_THEME_KEY);
        if (this.outgoingSelected == null) {
            this.outgoingSelected = new RGB(0, 0, 0);
        }
        this.outgoing = CompareColorImpl.interpolate(this.outgoingSelected, background, 0.6);
        this.outgoingFill = CompareColorImpl.interpolate(this.outgoingSelected, background, 0.97);
        this.incomingSelected = this.fColorRegistry.getRGB(INCOMING_CHANGE_COLOR_THEME_KEY);
        if (this.incomingSelected == null) {
            this.incomingSelected = new RGB(0, 0, 255);
        }
        this.incoming = CompareColorImpl.interpolate(this.incomingSelected, background, 0.6);
        this.incomingFill = CompareColorImpl.interpolate(this.incomingSelected, background, 0.97);
    }

    @Override
    public void dispose() {
        this.fColors.invalidateAll();
    }

    private RGB getBackground() {
        return this.fDisplay.getSystemColor(25).getRGB();
    }

    private static RGB interpolate(RGB fg, RGB bg, double scale) {
        RGB ret;
        if (fg != null && bg != null) {
            int red = (int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red);
            int green = (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green);
            int blue = (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue);
            ret = new RGB(CompareColorImpl.getValidComponent(red), CompareColorImpl.getValidComponent(green), CompareColorImpl.getValidComponent(blue));
        } else {
            ret = fg != null ? fg : (bg != null ? bg : new RGB(128, 128, 128));
        }
        return ret;
    }

    private static int getValidComponent(int colorComponent) {
        int validvalue = colorComponent;
        if (colorComponent > 255) {
            return 255;
        }
        if (colorComponent < 0) {
            return 0;
        }
        return validvalue;
    }

    @Override
    public Color getRequiredFillColor() {
        return this.getColor(this.requiredColor);
    }

    @Override
    public Color getUnmergeableFillColor() {
        return this.getColor(this.unmergeableColor);
    }

    @Override
    public Color getRequiredStrokeColor() {
        return this.getColor(this.requiredBorderColor);
    }

    @Override
    public Color getUnmergeableStrokeColor() {
        return this.getColor(this.unmergeableBorderColor);
    }
}

