/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Objects;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.team.core.variants.IResourceVariant;

public class ResourceVariantStorageProvider
implements IStorageProvider {
    private final String path;
    private final IResourceVariant variant;

    public ResourceVariantStorageProvider(String path, IResourceVariant variant) {
        this.path = path;
        this.variant = variant;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        return new StorageWrapper(this.path, this.variant.getStorage(monitor));
    }

    private static class StorageWrapper
    implements IStorage {
        private final String fullPath;
        private final IStorage storage;

        public StorageWrapper(String fullPath, IStorage storage) {
            this.fullPath = fullPath;
            this.storage = storage;
        }

        public Object getAdapter(Class adapter) {
            if (IResource.class.isAssignableFrom(adapter) && this.storage instanceof IFile) {
                return this.storage;
            }
            return this.storage.getAdapter(adapter);
        }

        public InputStream getContents() throws CoreException {
            return this.storage.getContents();
        }

        public IPath getFullPath() {
            return new Path(this.fullPath);
        }

        public String getName() {
            return this.storage.getName();
        }

        public boolean isReadOnly() {
            return this.storage.isReadOnly();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.fullPath, this.storage});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof StorageWrapper) {
                StorageWrapper other = (StorageWrapper)obj;
                return Objects.equal((Object)this.fullPath, (Object)other.fullPath) && Objects.equal((Object)this.storage, (Object)other.storage);
            }
            return false;
        }
    }
}

