/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.utils;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.compare.ide.EMFCompareIDEPlugin;
import org.eclipse.emf.compare.ide.hook.IResourceSetHook;
import org.eclipse.emf.compare.ide.internal.EMFCompareIDEMessages;
import org.eclipse.emf.compare.ide.internal.hook.ResourceSetHookRegistry;
import org.eclipse.emf.compare.ide.internal.utils.DisposableResourceSet;
import org.eclipse.emf.compare.ide.internal.utils.ProxyNotifierParserPool;
import org.eclipse.emf.compare.ide.internal.utils.StoragePathAdapter;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.policy.ILoadOnDemandPolicy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class NotLoadingResourceSet
extends ResourceSetImpl
implements DisposableResourceSet,
ProxyNotifierParserPool.IProxyCreationListener {
    private final Map<URI, IStorage> storageToURI;
    private final ResourceSetHookRegistry hookRegistry;
    private boolean isDisposed;
    private Queue<ProxyEntry> proxyQueue;
    private boolean allowResourceLoad;

    private NotLoadingResourceSet(Map<URI, IStorage> storagesToLoad, ResourceSetHookRegistry hookRegistry) {
        this.storageToURI = storagesToLoad;
        this.hookRegistry = hookRegistry;
        this.proxyQueue = new ConcurrentLinkedQueue<ProxyEntry>();
    }

    public static NotLoadingResourceSet create(StorageTraversal traversals, IProgressMonitor monitor, ResourceSetHookRegistry resourceSetHookRegistry) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.subTask(EMFCompareIDEMessages.getString("NotLoadingResourceSet.monitor.resolve"));
        ExtensibleURIConverterImpl converter = new ExtensibleURIConverterImpl();
        Set<? extends IStorage> storages = traversals.getStorages();
        LinkedHashMap<URI, IStorage> storageToURI = new LinkedHashMap<URI, IStorage>(storages.size());
        for (IStorage iStorage : storages) {
            IStorage iStorage2 = storageToURI.put(converter.normalize(ResourceUtil.createURIFor(iStorage)), iStorage);
        }
        NotLoadingResourceSet notLoadingResourceSet = new NotLoadingResourceSet(storageToURI, resourceSetHookRegistry);
        notLoadingResourceSet.setURIConverter((URIConverter)converter);
        notLoadingResourceSet.setURIResourceMap(new HashMap(storages.size() << 1));
        SubMonitor subMonitor = progress.newChild(60).setWorkRemaining(storages.size());
        notLoadingResourceSet.load((IProgressMonitor)subMonitor);
        subMonitor = progress.newChild(40);
        notLoadingResourceSet.resolveProxies(subMonitor);
        return notLoadingResourceSet;
    }

    private Collection<IResourceSetHook> getMatchingHooks(final Collection<URI> urisToLoad) {
        Collection<IResourceSetHook> hooks = this.hookRegistry == null ? Collections.emptyList() : Collections2.filter(this.hookRegistry.getResourceSetHooks(), (Predicate)new Predicate<IResourceSetHook>(){

            public boolean apply(IResourceSetHook input) {
                return input.isHookFor(urisToLoad);
            }
        });
        return hooks;
    }

    protected void demandLoadHelper(Resource resource) {
        IStorage storage = this.getMatchingStorage(resource);
        if (storage != null) {
            try {
                this.loadFromStorage(resource, storage);
            }
            catch (IOException e) {
                this.logLoadingFromStorageFailed(resource, storage, e);
            }
        } else {
            super.demandLoadHelper(resource);
        }
    }

    private void logLoadingFromStorageFailed(Resource resource, IStorage storage, Exception e) {
        Status errorStatus = new Status(4, "org.eclipse.emf.compare.ide", EMFCompareIDEMessages.getString("StorageResourceWrapper.failToLoad", resource.getURI().toString(), storage.getName()), (Throwable)e);
        EMFCompareIDEPlugin.getDefault().getLog().log((IStatus)errorStatus);
    }

    private IStorage getMatchingStorage(Resource resource) {
        URIConverter theURIConverter = this.getURIConverter();
        URI resourceNormalizedUri = theURIConverter.normalize(resource.getURI());
        return this.storageToURI.get(resourceNormalizedUri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadFromStorage(Resource resource, IStorage storage) throws IOException {
        InputStream stream = null;
        try {
            try {
                stream = storage.getContents();
                resource.load(stream, this.getLoadOptions());
                return;
            }
            catch (CoreException e) {
                this.logLoadingFromStorageFailed(resource, storage, (Exception)((Object)e));
                if (stream == null) return;
                stream.close();
                return;
            }
            catch (WrappedException e) {
                this.logLoadingFromStorageFailed(resource, storage, (Exception)((Object)e));
                if (stream == null) return;
                stream.close();
                return;
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected void handleDemandLoadException(Resource resource, IOException exception) {
        try {
            super.handleDemandLoadException(resource, exception);
        }
        catch (RuntimeException runtimeException) {}
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        ILoadOnDemandPolicy.Registry registry;
        this.checkNotDisposed();
        Resource cached = (Resource)this.getURIResourceMap().get(uri);
        if (cached != null) {
            return cached;
        }
        IStorage storage = this.storageToURI.get(uri);
        Resource resource = loadOnDemand && storage != null ? this.load(storage, uri, (IProgressMonitor)new NullProgressMonitor()) : (this.allowResourceLoad ? super.getResource(uri, loadOnDemand) : ((registry = EMFCompareRCPPlugin.getDefault().getLoadOnDemandPolicyRegistry()).hasAnyAuthorizingPolicy(uri) ? super.getResource(uri, true) : super.getResource(uri, false)));
        return resource;
    }

    private void resolveProxies(SubMonitor monitor) {
        int workRemaining = this.proxyQueue.size();
        int currentCount = 0;
        monitor.setWorkRemaining(workRemaining);
        while (!this.proxyQueue.isEmpty()) {
            EStructuralFeature proxyFeature;
            ProxyEntry proxyEntry = this.proxyQueue.poll();
            EObject eObject = proxyEntry.eObject;
            Object values = eObject.eGet(proxyFeature = proxyEntry.proxyFeature, true);
            if (values instanceof InternalEList) {
                ListIterator crossRefs = ((InternalEList)values).basicListIterator();
                while (crossRefs.hasNext()) {
                    URI proxyURI;
                    Resource targetRes;
                    Object nextValue = crossRefs.next();
                    if (!(nextValue instanceof EObject) || !((EObject)nextValue).eIsProxy() || (targetRes = this.getResource((proxyURI = ((InternalEObject)nextValue).eProxyURI()).trimFragment(), false)) == null) continue;
                    ((InternalEList)values).get(crossRefs.previousIndex());
                }
            }
            monitor.worked(1);
            if (++currentCount <= workRemaining) continue;
            workRemaining = this.proxyQueue.size();
            currentCount = 0;
            monitor.setWorkRemaining(workRemaining);
        }
    }

    private void load(IProgressMonitor monitor) {
        this.checkNotDisposed();
        ImmutableSet urisToLoad = ImmutableSet.copyOf(this.storageToURI.keySet());
        Collection<IResourceSetHook> hooks = this.getMatchingHooks((Collection<URI>)urisToLoad);
        for (IResourceSetHook iResourceSetHook : hooks) {
            iResourceSetHook.preLoadingHook(this, (Collection<? extends URI>)urisToLoad);
        }
        for (Map.Entry entry : this.storageToURI.entrySet()) {
            this.load((IStorage)entry.getValue(), (URI)entry.getKey(), monitor);
        }
        for (IResourceSetHook iResourceSetHook : hooks) {
            iResourceSetHook.postLoadingHook(this, (Collection<? extends URI>)urisToLoad);
        }
    }

    private Resource load(IStorage storage, URI uri, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Resource cached = (Resource)this.getURIResourceMap().get(uri);
        if (cached != null) {
            return cached;
        }
        Resource loaded = this.demandCreateResource(uri);
        this.getURIResourceMap().put(uri, loaded);
        try {
            this.loadFromStorage(loaded, storage);
            String fullPath = storage.getFullPath().toString();
            boolean isLocal = storage instanceof IFile;
            loaded.eAdapters().add((Object)new StoragePathAdapter(fullPath, isLocal));
            monitor.worked(1);
        }
        catch (IOException e) {
            this.logLoadingFromStorageFailed(loaded, storage, e);
        }
        return loaded;
    }

    public Map<Object, Object> getLoadOptions() {
        this.loadOptions = super.getLoadOptions();
        ProxyNotifierParserPool parserPool = new ProxyNotifierParserPool(false);
        parserPool.addProxyListener(this);
        this.loadOptions.put("USE_PARSER_POOL", parserPool);
        this.loadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        return this.loadOptions;
    }

    @Override
    public void dispose() {
        ImmutableList currentResources = ImmutableList.copyOf(this.getResources());
        ArrayList resourceSetUris = Lists.newArrayList((Iterable)Iterables.transform((Iterable)currentResources, (Function)new Function<Resource, URI>(){

            public URI apply(Resource input) {
                return input.getURI();
            }
        }));
        for (IResourceSetHook hook : this.getMatchingHooks(resourceSetUris)) {
            hook.onDispose((Iterable<Resource>)currentResources);
        }
        for (Resource resource : currentResources) {
            TreeIterator allContents = EcoreUtil.getAllProperContents((Resource)resource, (boolean)false);
            while (allContents.hasNext()) {
                EObject next = (EObject)allContents.next();
                next.eAdapters().clear();
            }
            resource.eAdapters().clear();
        }
        this.getResources().clear();
        this.eAdapters().clear();
        this.isDisposed = true;
    }

    public Resource createResource(URI uri, String contentType) {
        this.checkNotDisposed();
        return super.createResource(uri, contentType);
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        this.checkNotDisposed();
        return super.getEObject(uri, loadOnDemand);
    }

    public TreeIterator<Notifier> getAllContents() {
        this.checkNotDisposed();
        return super.getAllContents();
    }

    public EList<Resource> getResources() {
        this.checkNotDisposed();
        return super.getResources();
    }

    private void checkNotDisposed() {
        if (this.isDisposed) {
            throw new IllegalStateException("The resource set is disposed");
        }
    }

    @Override
    public void proxyCreated(Resource source, EObject eObject, EStructuralFeature eStructuralFeature, EObject proxy, int position) {
        ProxyEntry proxyEntry = new ProxyEntry(eObject, eStructuralFeature);
        this.proxyQueue.add(proxyEntry);
    }

    public void setAllowResourceLoad(boolean allowResourceLoad) {
        this.allowResourceLoad = allowResourceLoad;
    }

    private class ProxyEntry {
        private final EObject eObject;
        private final EStructuralFeature proxyFeature;

        public ProxyEntry(EObject eObject, EStructuralFeature proxyFeature) {
            this.eObject = eObject;
            this.proxyFeature = proxyFeature;
        }
    }
}

