/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.AbstractResolution;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyLocalResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.LocalModelResolution;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalModelsResolution
extends AbstractResolution {
    private final IResourceDependencyLocalResolver resolver;
    private final IResource left;
    private final IResource right;
    private final IResource origin;

    public LocalModelsResolution(IResolutionContext context, IResource left, IResource right, IResource origin, IProgressMonitor monitor) {
        super(context, monitor);
        this.left = (IResource)Preconditions.checkNotNull((Object)left);
        this.right = (IResource)Preconditions.checkNotNull((Object)right);
        this.origin = origin;
        this.resolver = context.getLocalResolver();
    }

    public SynchronizationModel run() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"run() - START");
        }
        try {
            if (this.allResourcesAreFiles()) {
                SynchronizationModel synchronizationModel = this.resolveLocalFiles();
                return synchronizationModel;
            }
            SynchronizationModel synchronizationModel = this.resolveLocalResources();
            return synchronizationModel;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"run() - FINISH");
            }
            this.monitor.setWorkRemaining(0);
        }
    }

    protected boolean allResourcesAreFiles() {
        return this.left instanceof IFile && this.right instanceof IFile && (this.origin == null || this.origin instanceof IFile);
    }

    private SynchronizationModel resolveLocalResources() {
        StorageTraversal originTraversal;
        StorageTraversal rightTraversal;
        StorageTraversal leftTraversal;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"resolveLocalResources()");
        }
        if (this.origin != null) {
            leftTraversal = this.resolveLocalModel(this.left, this.monitor.newChild(33));
            rightTraversal = this.resolveLocalModel(this.right, this.monitor.newChild(33));
            originTraversal = this.resolveLocalModel(this.origin, this.monitor.newChild(34));
        } else {
            leftTraversal = this.resolveLocalModel(this.left, this.monitor.newChild(50));
            rightTraversal = this.resolveLocalModel(this.right, this.monitor.newChild(50));
            originTraversal = new StorageTraversal((Set)Sets.newLinkedHashSet());
        }
        return new SynchronizationModel(leftTraversal, rightTraversal, originTraversal);
    }

    private StorageTraversal resolveLocalModel(IResource start, SubMonitor subMonitor) {
        LocalModelResolution comp = new LocalModelResolution(this.context, (IProgressMonitor)subMonitor);
        return comp.run(start);
    }

    private SynchronizationModel resolveLocalFiles() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"resolveLocalFiles()");
        }
        return this.call(new Callable<SynchronizationModel>(){

            @Override
            public SynchronizationModel call() throws Exception {
                Set<Object> originTraversal;
                Set<IStorage> rightTraversal;
                Set<IStorage> leftTraversal;
                URI originURI;
                ImmutableSet startingPoints;
                if (LocalModelsResolution.this.logger.isDebugEnabled()) {
                    LocalModelsResolution.this.logger.debug((Object)"Updating dependencies");
                }
                if (LocalModelsResolution.this.origin instanceof IFile) {
                    LocalModelsResolution.this.resolver.updateDependencies((IProgressMonitor)LocalModelsResolution.this.monitor, LocalModelsResolution.this.diagnostic, (IFile)LocalModelsResolution.this.left, (IFile)LocalModelsResolution.this.right, (IFile)LocalModelsResolution.this.origin);
                } else {
                    LocalModelsResolution.this.resolver.updateDependencies((IProgressMonitor)LocalModelsResolution.this.monitor, LocalModelsResolution.this.diagnostic, (IFile)LocalModelsResolution.this.left, (IFile)LocalModelsResolution.this.right);
                }
                URI leftURI = ResourceUtil.createURIFor((IFile)((IFile)LocalModelsResolution.this.left));
                URI rightURI = ResourceUtil.createURIFor((IFile)((IFile)LocalModelsResolution.this.right));
                if (LocalModelsResolution.this.origin instanceof IFile) {
                    startingPoints = ImmutableSet.of((Object)((IFile)LocalModelsResolution.this.left), (Object)((IFile)LocalModelsResolution.this.right), (Object)((IFile)LocalModelsResolution.this.origin));
                    originURI = ResourceUtil.createURIFor((IFile)((IFile)LocalModelsResolution.this.origin));
                } else {
                    startingPoints = ImmutableSet.of((Object)((IFile)LocalModelsResolution.this.left), (Object)((IFile)LocalModelsResolution.this.right));
                    originURI = null;
                }
                if (LocalModelsResolution.this.monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (LocalModelsResolution.this.logger.isDebugEnabled()) {
                    LocalModelsResolution.this.logger.debug((Object)"Computing traversals");
                }
                if (LocalModelsResolution.this.origin instanceof IFile) {
                    leftTraversal = LocalModelsResolution.this.resolveTraversal((IFile)LocalModelsResolution.this.left, (Set<URI>)ImmutableSet.of((Object)rightURI, (Object)originURI));
                    rightTraversal = LocalModelsResolution.this.resolveTraversal((IFile)LocalModelsResolution.this.right, (Set<URI>)ImmutableSet.of((Object)leftURI, (Object)originURI));
                    originTraversal = LocalModelsResolution.this.resolveTraversal((IFile)LocalModelsResolution.this.origin, (Set<URI>)ImmutableSet.of((Object)leftURI, (Object)rightURI));
                } else {
                    leftTraversal = LocalModelsResolution.this.resolveTraversal((IFile)LocalModelsResolution.this.left, Collections.singleton(rightURI));
                    rightTraversal = LocalModelsResolution.this.resolveTraversal((IFile)LocalModelsResolution.this.right, Collections.singleton(leftURI));
                    originTraversal = Collections.emptySet();
                }
                if (LocalModelsResolution.this.logger.isDebugEnabled()) {
                    LocalModelsResolution.this.logger.debug((Object)"Computing synchronization model");
                }
                Sets.SetView intersection = Sets.intersection(leftTraversal, rightTraversal);
                if (!originTraversal.isEmpty()) {
                    intersection = Sets.intersection((Set)intersection, originTraversal);
                }
                LocalModelsResolution.this.logCoherenceThreats(Iterables.transform((Iterable)startingPoints, (Function)ResourceUtil.asURI()), Iterables.transform((Iterable)intersection, (Function)ResourceUtil.asURI()));
                LinkedHashSet actualLeft = new LinkedHashSet(Sets.difference(leftTraversal, (Set)intersection));
                LinkedHashSet actualRight = new LinkedHashSet(Sets.difference(rightTraversal, (Set)intersection));
                LinkedHashSet actualOrigin = new LinkedHashSet(Sets.difference(originTraversal, (Set)intersection));
                SynchronizationModel synchronizationModel = new SynchronizationModel(new StorageTraversal(actualLeft), new StorageTraversal(actualRight), new StorageTraversal(actualOrigin), (Diagnostic)LocalModelsResolution.this.diagnostic.getDiagnostic());
                return synchronizationModel;
            }
        });
    }

    private void logCoherenceThreats(Iterable<URI> startingPoints, Iterable<URI> removedFromModel) {
        LinkedHashSet<URI> coherenceThreats = new LinkedHashSet<URI>();
        for (URI start : startingPoints) {
            for (URI removed : removedFromModel) {
                if (!this.context.getDependencyProvider().hasChild(removed, start)) continue;
                coherenceThreats.add(removed);
            }
        }
        if (!coherenceThreats.isEmpty()) {
            String message = EMFCompareIDEUIMessages.getString("ModelResolver.coherenceWarning");
            String details = Iterables.toString(coherenceThreats);
            EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.ide.ui", String.valueOf(message) + '\n' + details));
        }
    }
}

