/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.internal.merge.IMergeData;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl.AbstractStructuralFeatureAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureMapKeyChangeAccessorImpl
extends AbstractStructuralFeatureAccessor {
    public FeatureMapKeyChangeAccessorImpl(AdapterFactory adapterFactory, FeatureMapChange diff, IMergeViewer.MergeViewerSide side) {
        super(adapterFactory, (Diff)diff, side);
    }

    @Override
    public ImmutableList<? extends IMergeViewerItem> getItems() {
        EStructuralFeature leftKey = this.getKey(IMergeViewer.MergeViewerSide.LEFT);
        EStructuralFeature rightKey = this.getKey(IMergeViewer.MergeViewerSide.RIGHT);
        EStructuralFeature ancestorKey = this.getKey(IMergeViewer.MergeViewerSide.ANCESTOR);
        MergeViewerItem item = new MergeViewerItem(this.getComparison(), this.getInitialDiff(), leftKey, rightKey, ancestorKey, this.getSide(), this.getRootAdapterFactory());
        return ImmutableList.of((Object)item);
    }

    public FeatureMapChange getFeatureMapChange() {
        return (FeatureMapChange)this.getInitialDiff();
    }

    private EStructuralFeature getKey(IMergeViewer.MergeViewerSide side) {
        EStructuralFeature key = null;
        FeatureMapChange diff = (FeatureMapChange)this.getInitialDiff();
        FeatureMap.Entry entry = (FeatureMap.Entry)diff.getValue();
        if (side != IMergeViewer.MergeViewerSide.ANCESTOR && side.convertToDifferenceSource().equals((Object)diff.getSource()) && diff.getState() != DifferenceState.MERGED) {
            key = entry.getEStructuralFeature();
        } else if (diff.getState() == DifferenceState.MERGED && !this.isMergedTargetIsSource(diff)) {
            key = entry.getEStructuralFeature();
        } else {
            Object value = entry.getValue();
            EObject eObject = this.getEObject(side);
            List list = ReferenceUtil.getAsList((EObject)eObject, (EStructuralFeature)this.getStructuralFeature());
            IEqualityHelper equalityHelper = this.getComparison().getEqualityHelper();
            for (Object object : list) {
                if (!(object instanceof FeatureMap.Entry) || !equalityHelper.matchingValues(value, ((FeatureMap.Entry)object).getValue())) continue;
                key = ((FeatureMap.Entry)object).getEStructuralFeature();
                break;
            }
        }
        return key;
    }

    private boolean isMergedTargetIsSource(FeatureMapChange diff) {
        IMergeData mergeData = (IMergeData)EcoreUtil.getExistingAdapter((Notifier)diff, IMergeData.class);
        return diff.getSource() == mergeData.getMergeTarget();
    }
}

