/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyRemoteResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.RemoteMonitoredProxyCreationListener;
import org.eclipse.emf.compare.ide.ui.tests.logical.resolver.AbstractMonitoredProxyCreationListenerTest;
import org.eclipse.emf.ecore.EObject;
import org.junit.Test;
import org.mockito.Mockito;

public class RemoteMonitoredProxyCreationListenerTest
extends AbstractMonitoredProxyCreationListenerTest {
    RemoteMonitoredProxyCreationListener sut;

    @Test
    public void testCorrectProxy() {
        this.prepareTest("platform:/resource/to", CrossReferenceResolutionScope.WORKSPACE);
        this.sut = new RemoteMonitoredProxyCreationListener(this.monitor, this.remoteResolver, this.diagnostic);
        this.sut.proxyCreated(this.source, this.eObject, this.feature, (EObject)this.proxy, 3);
        ((IResourceDependencyRemoteResolver)Mockito.verify((Object)this.remoteResolver)).demandRemoteResolve(this.synchronizedResourceSet, this.to, this.diagnostic, this.monitor);
    }

    @Test
    public void testNonPlatformResource() {
        this.prepareTest("nonplatform:/resource/to", CrossReferenceResolutionScope.WORKSPACE);
        this.sut = new RemoteMonitoredProxyCreationListener(this.monitor, this.remoteResolver, this.diagnostic);
        this.sut.proxyCreated(this.source, this.eObject, this.feature, (EObject)this.proxy, 3);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.localResolver});
    }

    @Test
    public void testNonAbsolutePlatformResource() {
        this.prepareTest("platform:relative/file", CrossReferenceResolutionScope.WORKSPACE);
        this.sut = new RemoteMonitoredProxyCreationListener(this.monitor, this.remoteResolver, this.diagnostic);
        this.sut.proxyCreated(this.source, this.eObject, this.feature, (EObject)this.proxy, 3);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.localResolver});
    }

    @Test
    public void testWrongResolutionScope() {
        this.prepareTest("platform:/resource/to", CrossReferenceResolutionScope.SELF);
        this.sut = new RemoteMonitoredProxyCreationListener(this.monitor, this.remoteResolver, this.diagnostic);
        this.sut.proxyCreated(this.source, this.eObject, this.feature, (EObject)this.proxy, 3);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.localResolver});
    }
}

