/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeNonConflictingRunnable;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.spec.ComparisonSpec;
import org.eclipse.emf.compare.internal.spec.ConflictSpec;
import org.eclipse.emf.compare.internal.spec.DiffSpec;
import org.eclipse.emf.compare.internal.spec.MatchSpec;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.junit.Assert;
import org.junit.Test;

public class MergeNonConflictingRunnableRefinementTest {
    private static final IMerger.Registry MERGER_REGISTRY = IMerger.RegistryImpl.createStandaloneInstance();

    static {
        MERGER_REGISTRY.add((IMerger)new AbstractMerger(){

            public boolean isMergerFor(Diff target) {
                return true;
            }
        });
    }

    protected Diff createDiff(final String name, DifferenceSource source) {
        DiffSpec diff = new DiffSpec(){

            public String toString() {
                return name;
            }
        };
        diff.setSource(source);
        return diff;
    }

    protected Conflict createConflict(ConflictKind kind, Diff ... diffs) {
        ConflictSpec conflict = new ConflictSpec();
        conflict.setKind(kind);
        conflict.getDifferences().addAll(Arrays.asList(diffs));
        return conflict;
    }

    protected Comparison createComparison(List<Diff> differences, List<Conflict> conflicts) {
        ComparisonSpec comparison = new ComparisonSpec();
        MatchSpec match = new MatchSpec();
        match.getDifferences().addAll(differences);
        comparison.getMatches().add((Object)match);
        comparison.getConflicts().addAll(conflicts);
        comparison.setThreeWay(false);
        return comparison;
    }

    @Test
    public void testMergeNonConflictingWithBStartB() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        Diff leftA = this.createDiff("LeftA", DifferenceSource.LEFT);
        Diff leftB = this.createDiff("LeftB", DifferenceSource.LEFT);
        Diff leftC = this.createDiff("LeftC", DifferenceSource.LEFT);
        leftA.getRefines().add((Object)leftB);
        leftA.getRefines().add((Object)leftC);
        Diff rightA = this.createDiff("RightA", DifferenceSource.RIGHT);
        Diff rightB = this.createDiff("RightB", DifferenceSource.RIGHT);
        Diff rightC = this.createDiff("RightC", DifferenceSource.RIGHT);
        rightA.getRefines().add((Object)rightB);
        rightA.getRefines().add((Object)rightC);
        Conflict conflict = this.createConflict(ConflictKind.REAL, leftB, rightB);
        Comparison comparison = this.createComparison(Arrays.asList(leftB, leftC, leftA, rightB, rightC, rightA), Arrays.asList(conflict));
        this.mergeNonConflictingChanges(comparison, mergeMode, true);
        this.verifyAllUnresolved((List<Diff>)comparison.getDifferences());
    }

    @Test
    public void testMergeNonConflictingWithBStartC() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        Diff leftA = this.createDiff("LeftA", DifferenceSource.LEFT);
        Diff leftB = this.createDiff("LeftB", DifferenceSource.LEFT);
        Diff leftC = this.createDiff("LeftC", DifferenceSource.LEFT);
        leftA.getRefines().add((Object)leftB);
        leftA.getRefines().add((Object)leftC);
        Diff rightA = this.createDiff("RightA", DifferenceSource.RIGHT);
        Diff rightB = this.createDiff("RightB", DifferenceSource.RIGHT);
        Diff rightC = this.createDiff("RightC", DifferenceSource.RIGHT);
        rightA.getRefines().add((Object)rightB);
        rightA.getRefines().add((Object)rightC);
        Conflict conflict = this.createConflict(ConflictKind.REAL, leftB, rightB);
        Comparison comparison = this.createComparison(Arrays.asList(leftC, leftB, leftA, rightB, rightC, rightA), Arrays.asList(conflict));
        this.mergeNonConflictingChanges(comparison, mergeMode, true);
        this.verifyAllUnresolved((List<Diff>)comparison.getDifferences());
    }

    @Test
    public void testMergeNonConflictingWithBStartA() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        Diff leftA = this.createDiff("LeftA", DifferenceSource.LEFT);
        Diff leftB = this.createDiff("LeftB", DifferenceSource.LEFT);
        Diff leftC = this.createDiff("LeftC", DifferenceSource.LEFT);
        leftA.getRefines().add((Object)leftB);
        leftA.getRefines().add((Object)leftC);
        Diff rightA = this.createDiff("RightA", DifferenceSource.RIGHT);
        Diff rightB = this.createDiff("RightB", DifferenceSource.RIGHT);
        Diff rightC = this.createDiff("RightC", DifferenceSource.RIGHT);
        rightA.getRefines().add((Object)rightB);
        rightA.getRefines().add((Object)rightC);
        Conflict conflict = this.createConflict(ConflictKind.REAL, leftB, rightB);
        Comparison comparison = this.createComparison(Arrays.asList(leftA, leftC, leftB, rightB, rightC, rightA), Arrays.asList(conflict));
        this.mergeNonConflictingChanges(comparison, mergeMode, true);
        this.verifyAllUnresolved((List<Diff>)comparison.getDifferences());
    }

    @Test
    public void testMergeNonConflictingWithAStartB() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        Diff leftA = this.createDiff("LeftA", DifferenceSource.LEFT);
        Diff leftB = this.createDiff("LeftB", DifferenceSource.LEFT);
        Diff leftC = this.createDiff("LeftC", DifferenceSource.LEFT);
        leftA.getRefines().add((Object)leftB);
        leftA.getRefines().add((Object)leftC);
        Diff rightA = this.createDiff("RightA", DifferenceSource.RIGHT);
        Diff rightB = this.createDiff("RightB", DifferenceSource.RIGHT);
        Diff rightC = this.createDiff("RightC", DifferenceSource.RIGHT);
        rightA.getRefines().add((Object)rightB);
        rightA.getRefines().add((Object)rightC);
        Conflict conflict = this.createConflict(ConflictKind.REAL, leftA, rightB);
        Comparison comparison = this.createComparison(Arrays.asList(leftB, leftC, leftA, rightB, rightC, rightA), Arrays.asList(conflict));
        this.mergeNonConflictingChanges(comparison, mergeMode, true);
        this.verifyAllUnresolved((List<Diff>)comparison.getDifferences());
    }

    @Test
    public void testMergeNonConflictingWithAStartC() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        Diff leftA = this.createDiff("LeftA", DifferenceSource.LEFT);
        Diff leftB = this.createDiff("LeftB", DifferenceSource.LEFT);
        Diff leftC = this.createDiff("LeftC", DifferenceSource.LEFT);
        leftA.getRefines().add((Object)leftB);
        leftA.getRefines().add((Object)leftC);
        Diff rightA = this.createDiff("RightA", DifferenceSource.RIGHT);
        Diff rightB = this.createDiff("RightB", DifferenceSource.RIGHT);
        Diff rightC = this.createDiff("RightC", DifferenceSource.RIGHT);
        rightA.getRefines().add((Object)rightB);
        rightA.getRefines().add((Object)rightC);
        Conflict conflict = this.createConflict(ConflictKind.REAL, leftA, rightB);
        Comparison comparison = this.createComparison(Arrays.asList(leftC, leftB, leftA, rightB, rightC, rightA), Arrays.asList(conflict));
        this.mergeNonConflictingChanges(comparison, mergeMode, true);
        this.verifyAllUnresolved((List<Diff>)comparison.getDifferences());
    }

    @Test
    public void testMergeNonConflictingWithAStartA() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        Diff leftA = this.createDiff("LeftA", DifferenceSource.LEFT);
        Diff leftB = this.createDiff("LeftB", DifferenceSource.LEFT);
        Diff leftC = this.createDiff("LeftC", DifferenceSource.LEFT);
        leftA.getRefines().add((Object)leftB);
        leftA.getRefines().add((Object)leftC);
        Diff rightA = this.createDiff("RightA", DifferenceSource.RIGHT);
        Diff rightB = this.createDiff("RightB", DifferenceSource.RIGHT);
        Diff rightC = this.createDiff("RightC", DifferenceSource.RIGHT);
        rightA.getRefines().add((Object)rightB);
        rightA.getRefines().add((Object)rightC);
        Conflict conflict = this.createConflict(ConflictKind.REAL, leftA, rightB);
        Comparison comparison = this.createComparison(Arrays.asList(leftA, leftC, leftB, rightB, rightC, rightA), Arrays.asList(conflict));
        this.mergeNonConflictingChanges(comparison, mergeMode, true);
        this.verifyAllUnresolved((List<Diff>)comparison.getDifferences());
    }

    @Test
    public void testMergeNonConflictingTwoTiersWithCStartE() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        Diff leftA = this.createDiff("LeftA", DifferenceSource.LEFT);
        Diff leftB = this.createDiff("LeftB", DifferenceSource.LEFT);
        Diff leftC = this.createDiff("LeftC", DifferenceSource.LEFT);
        Diff leftD = this.createDiff("LeftD", DifferenceSource.LEFT);
        Diff leftE = this.createDiff("LeftE", DifferenceSource.LEFT);
        leftA.getRefines().add((Object)leftB);
        leftA.getRefines().add((Object)leftC);
        leftB.getRefines().add((Object)leftD);
        leftB.getRefines().add((Object)leftE);
        Diff rightA = this.createDiff("RightA", DifferenceSource.RIGHT);
        Diff rightB = this.createDiff("RightB", DifferenceSource.RIGHT);
        Diff rightC = this.createDiff("RightC", DifferenceSource.RIGHT);
        rightA.getRefines().add((Object)rightB);
        rightA.getRefines().add((Object)rightC);
        Conflict conflict = this.createConflict(ConflictKind.REAL, leftC, rightB);
        Comparison comparison = this.createComparison(Arrays.asList(leftE, leftC, leftB, leftA, leftD, rightB, rightC, rightA), Arrays.asList(conflict));
        this.mergeNonConflictingChanges(comparison, mergeMode, true);
        this.verifyAllUnresolved((List<Diff>)comparison.getDifferences());
    }

    @Test
    public void testMergeNonConflictingSharedRefiningWithCStartC() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        Diff leftA = this.createDiff("LeftA", DifferenceSource.LEFT);
        Diff leftB = this.createDiff("LeftB", DifferenceSource.LEFT);
        Diff leftC = this.createDiff("LeftC", DifferenceSource.LEFT);
        Diff leftD = this.createDiff("LeftD", DifferenceSource.LEFT);
        Diff leftE = this.createDiff("LeftE", DifferenceSource.LEFT);
        leftA.getRefines().add((Object)leftC);
        leftA.getRefines().add((Object)leftD);
        leftB.getRefines().add((Object)leftD);
        leftB.getRefines().add((Object)leftE);
        Diff rightA = this.createDiff("RightA", DifferenceSource.RIGHT);
        Diff rightB = this.createDiff("RightB", DifferenceSource.RIGHT);
        Diff rightC = this.createDiff("RightC", DifferenceSource.RIGHT);
        rightA.getRefines().add((Object)rightB);
        rightA.getRefines().add((Object)rightC);
        Conflict conflict = this.createConflict(ConflictKind.REAL, leftD, rightB);
        Comparison comparison = this.createComparison(Arrays.asList(leftC, leftE, leftB, leftA, leftD, rightB, rightC, rightA), Arrays.asList(conflict));
        this.mergeNonConflictingChanges(comparison, mergeMode, true);
        this.verifyAllUnresolved((List<Diff>)comparison.getDifferences());
    }

    @Test
    public void testMergeNonConflictingSharedRefiningWithCStartA() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        Diff leftA = this.createDiff("LeftA", DifferenceSource.LEFT);
        Diff leftB = this.createDiff("LeftB", DifferenceSource.LEFT);
        Diff leftC = this.createDiff("LeftC", DifferenceSource.LEFT);
        Diff leftD = this.createDiff("LeftD", DifferenceSource.LEFT);
        Diff leftE = this.createDiff("LeftE", DifferenceSource.LEFT);
        leftA.getRefines().add((Object)leftC);
        leftA.getRefines().add((Object)leftD);
        leftB.getRefines().add((Object)leftD);
        leftB.getRefines().add((Object)leftE);
        Diff rightA = this.createDiff("RightA", DifferenceSource.RIGHT);
        Diff rightB = this.createDiff("RightB", DifferenceSource.RIGHT);
        Diff rightC = this.createDiff("RightC", DifferenceSource.RIGHT);
        rightA.getRefines().add((Object)rightB);
        rightA.getRefines().add((Object)rightC);
        Conflict conflict = this.createConflict(ConflictKind.REAL, leftD, rightB);
        Comparison comparison = this.createComparison(Arrays.asList(leftA, leftB, leftE, leftC, leftD, rightB, rightC, rightA), Arrays.asList(conflict));
        this.mergeNonConflictingChanges(comparison, mergeMode, true);
        this.verifyAllUnresolved((List<Diff>)comparison.getDifferences());
    }

    protected void verifyAllUnresolved(List<Diff> diffs) {
        for (Diff diff : diffs) {
            Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff.getState());
        }
    }

    private void mergeNonConflictingChanges(Comparison comparison, MergeMode mergeMode, boolean leftToRight) {
        boolean isRightEditable;
        boolean isLeftEditable;
        switch (mergeMode) {
            case LEFT_TO_RIGHT: 
            case RIGHT_TO_LEFT: {
                isLeftEditable = true;
                isRightEditable = true;
                break;
            }
            case ACCEPT: 
            case REJECT: {
                isLeftEditable = true;
                isRightEditable = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        MergeNonConflictingRunnable mergeNonConflicting = new MergeNonConflictingRunnable(isLeftEditable, isRightEditable, mergeMode, (IDiffRelationshipComputer)new DiffRelationshipComputer(MERGER_REGISTRY));
        mergeNonConflicting.merge(comparison, leftToRight, MERGER_REGISTRY);
    }
}

